<?php
/**
 * Ayyash Starter Content.
 *
 * @package Ayyash
 * @author ThemeRox
 * @version 1.0.0
 * @since Ayyash 1.0.5
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/**
 * Function to return the array of starter content for the theme.
 *
 * @since Ayyash 1.0.5
 *
 * @return array A filtered array of args for the starter_content.
 */
function ayyash_get_starter_content() {
	// phpcs:disable WordPressVIPMinimum.Security.Mustache.OutputNotation

	ob_start();
	?>
	<!-- wp:cover {"customGradient":"linear-gradient(292deg,rgb(8,163,238) 0%,rgb(6,74,243) 100%)","contentPosition":"center center","isDark":false,"align":"full","className":"ayyash-starter-banner"} -->
	<div class="wp-block-cover alignfull is-light ayyash-starter-banner"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient" style="background:linear-gradient(292deg,rgb(8,163,238) 0%,rgb(6,74,243) 100%)"></span>
		<div class="wp-block-cover__inner-container">
			<!-- wp:group {"tagName":"header","align":"full","className":"ayyash-starter-banner"} -->
			<header class="wp-block-group alignfull ayyash-starter-banner">
				<!-- wp:group {"style":{"spacing":{"padding":{"top":"60px"}}},"className":"container"} -->
				<div class="wp-block-group container" style="padding-top:60px">
					<!-- wp:columns {"verticalAlignment":"center","className":"ayyash-starter-banner-wrap"} -->
					<div class="wp-block-columns are-vertically-aligned-center ayyash-starter-banner-wrap" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px">
						<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"}}},"className":"ayyash-starter-banner-content"} -->
						<div class="wp-block-column is-vertically-aligned-center ayyash-starter-banner-content" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px">
							<!-- wp:heading {"level":1,"style":{"typography":{"textTransform":"capitalize","fontStyle":"normal","fontWeight":"700","lineHeight":"1.3"}},"textColor":"white","fontSize":"ayyash-heading-1"} -->
							<h1 class="has-white-color has-text-color has-ayyash-heading-1-font-size" style="font-style:normal;font-weight:700;line-height:1.3;text-transform:capitalize"><?php esc_html_e( 'Create and grow your unique website today', 'ayyash' ); ?></h1>
							<!-- /wp:heading -->

							<!-- wp:paragraph {"align":"left","placeholder":"Write title…","style":{"typography":{"fontStyle":"normal","fontWeight":"500","lineHeight":"1.5"}},"textColor":"white","fontSize":"ayyash-heading-6"} -->
							<p class="has-text-align-left has-white-color has-text-color has-ayyash-heading-6-font-size" style="font-style:normal;font-weight:500;line-height:1.5"><?php esc_html_e( 'Explore all the possibilities with the Ayyash WordPress theme.', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->

							<!-- wp:buttons {"layout":{"type":"flex"}} -->
							<div class="wp-block-buttons"><!-- wp:button {"textColor":"ayyash-heading","style":{"color":{"background":"#fbb42f"},"border":{"radius":"10px"},"spacing":{"padding":{"top":"15px","bottom":"15px","left":"30px","right":"30px"}},"typography":{"fontSize":"17px"}}} -->
								<div class="wp-block-button has-custom-font-size" style="font-size:17px">
									<a href="https://www.wpayyash.com" class="wp-block-button__link has-ayyash-heading-color has-text-color has-background wp-element-button" style="border-radius:10px;background-color:#fbb42f;padding-top:15px;padding-right:30px;padding-bottom:15px;padding-left:30px">
										<?php esc_html_e( 'Get Started', 'ayyash' ); ?>
									</a>
								</div>
								<!-- /wp:button -->

								<!-- wp:button {"textColor":"white","style":{"border":{"radius":"10px"},"spacing":{"padding":{"top":"15px","bottom":"15px","left":"30px","right":"30px"}},"typography":{"fontSize":"17px"},"color":{"background":"#ffffff00"}},"className":"is-style-outline"} -->
								<div class="wp-block-button has-custom-font-size is-style-outline" style="font-size:17px">
									<a href="https://www.wpayyash.com" class="wp-block-button__link has-white-color has-text-color has-background wp-element-button" style="border-radius:10px;background-color:#ffffff00;padding-top:15px;padding-right:30px;padding-bottom:15px;padding-left:30px">
										<?php esc_html_e( 'Learn More', 'ayyash' ); ?>
									</a>
								</div>
								<!-- /wp:button -->
							</div>
							<!-- /wp:buttons -->
						</div>
						<!-- /wp:column -->

						<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"}}},"className":"ayyash-starter-banner-image"} -->
						<div class="wp-block-column is-vertically-aligned-center ayyash-starter-banner-image" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":2233,"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full">
								<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/banner.svg" alt="Banner" class="wp-image-2233"/>
							</figure>
							<!-- /wp:image -->
						</div>
						<!-- /wp:column -->
					</div>
					<!-- /wp:columns -->
				</div>
				<!-- /wp:group -->
			</header>
			<!-- /wp:group -->
		</div>
	</div>
	<!-- /wp:cover -->

	<!-- wp:cover {"overlayColor":"ayyash-heading","minHeight":50,"align":"full","className":"ayyash-starter-feature"} -->
	<div class="wp-block-cover alignfull ayyash-starter-feature" style="min-height:50px"><span aria-hidden="true" class="wp-block-cover__background has-ayyash-heading-background-color has-background-dim-100 has-background-dim"></span>
		<div class="wp-block-cover__inner-container">
			<!-- wp:columns {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"}}},"className":"container"} -->
			<div class="wp-block-columns container" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:column {"className":"container"} -->
				<div class="wp-block-column container"><!-- wp:image {"id":2288,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/pre-built-websites.svg" alt="pre-built websites" class="wp-image-2288"/></figure>
					<!-- /wp:image -->

					<!-- wp:spacer {"height":"10px"} -->
					<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"ayyash-heading-6"} -->
					<h2 class="has-ayyash-heading-6-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Pre-Built Websites', 'ayyash' ); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:spacer {"height":"20px"} -->
					<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"}}} -->
					<p style="font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'Reduce website design time by using pixel perfect ready to use website', 'ayyash' ); ?></p>
					<!-- /wp:paragraph --></div>
				<!-- /wp:column -->

				<!-- wp:column {"className":"container"} -->
				<div class="wp-block-column container"><!-- wp:image {"id":2295,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/customize-without-code.svg" alt="Customize Without Code" class="wp-image-2295"/></figure>
					<!-- /wp:image -->

					<!-- wp:spacer {"height":"10px"} -->
					<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"ayyash-heading-6"} -->
					<h2 class="has-ayyash-heading-6-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Customize Without Code', 'ayyash' ); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:spacer {"height":"20px"} -->
					<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"}}} -->
					<p style="font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'Reduce website design time by using pixel perfect ready to use website', 'ayyash' ); ?></p>
					<!-- /wp:paragraph --></div>
				<!-- /wp:column -->

				<!-- wp:column {"className":"container"} -->
				<div class="wp-block-column container"><!-- wp:image {"id":2297,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/super-fast-performance.svg" alt="Super Fast Performance" class="wp-image-2297"/></figure>
					<!-- /wp:image -->

					<!-- wp:spacer {"height":"10px"} -->
					<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"ayyash-heading-6"} -->
					<h2 class="has-ayyash-heading-6-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Super Fast Performance', 'ayyash' ); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:spacer {"height":"20px"} -->
					<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"}}} -->
					<p style="font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'Reduce website design time by using pixel perfect ready to use website', 'ayyash' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
	</div>
	<!-- /wp:cover -->

	<!-- wp:group {"className":"ayyash-starter-process-wrap ayyash-starter-section"} -->
	<div class="wp-block-group ayyash-starter-process-wrap ayyash-starter-section">
		<!-- wp:group {"align":"wide","className":"ayyash-starter-section-header container"} -->
		<div class="wp-block-group alignwide ayyash-starter-section-header container">
			<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"textColor":"ayyash-primary","fontSize":"ayyash-heading-6"} -->
			<p class="has-text-align-center has-ayyash-primary-color has-text-color has-ayyash-heading-6-font-size" style="font-style:normal;font-weight:600">Our Working Process</p>
			<!-- /wp:paragraph -->

			<!-- wp:spacer {"height":"6px"} -->
			<div style="height:6px" aria-hidden="true" class="wp-block-spacer"></div>
			<!-- /wp:spacer -->

			<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700","textTransform":"capitalize","lineHeight":"1.3"}},"fontSize":"ayyash-heading-3"} -->
			<h2 class="has-text-align-center has-ayyash-heading-3-font-size" style="font-style:normal;font-weight:700;line-height:1.3;text-transform:capitalize">Three Simple Step To Start<br>Working Process</h2>
			<!-- /wp:heading -->

			<!-- wp:spacer {"height":"15px"} -->
			<div style="height:15px" aria-hidden="true" class="wp-block-spacer"></div>
			<!-- /wp:spacer -->

			<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#2d3748"}},"className":"container"} -->
			<p class="has-text-align-center container has-text-color" style="color:#2d3748"><?php esc_html_e( 'Find effective digital reach or your business, powered by human behavior, driven by data we provide experts to create', 'ayyash' ); ?></p>
			<!-- /wp:paragraph --></div>
		<!-- /wp:group -->

		<!-- wp:columns {"className":"container ayyash-starter-process"} -->
		<div class="wp-block-columns container ayyash-starter-process"><!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"align":"center","id":2376,"sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/research-project.png" alt="" class="wp-image-2376"/></figure>
				<!-- /wp:image -->

				<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500","textTransform":"capitalize"}},"textColor":"ayyash-heading","fontSize":"ayyash-heading-5"} -->
				<h3 class="has-text-align-center has-ayyash-heading-color has-text-color has-ayyash-heading-5-font-size" style="font-style:normal;font-weight:500;text-transform:capitalize"><?php esc_html_e( 'Research Project', 'ayyash' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:spacer {"height":"10px"} -->
				<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
				<!-- /wp:spacer -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"16px"}}} -->
				<p class="has-text-align-center" style="font-size:16px"><?php esc_html_e( 'Find effective digital reach or your business, powered by human behaviour.', 'ayyash' ); ?></p>
				<!-- /wp:paragraph --></div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"align":"center","id":2387,"sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/targeting.png" alt="" class="wp-image-2387"/></figure>
				<!-- /wp:image -->

				<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500","textTransform":"capitalize"}},"textColor":"ayyash-heading","fontSize":"ayyash-heading-5"} -->
				<h3 class="has-text-align-center has-ayyash-heading-color has-text-color has-ayyash-heading-5-font-size" style="font-style:normal;font-weight:500;text-transform:capitalize"><?php esc_html_e( 'Targeting', 'ayyash' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:spacer {"height":"10px"} -->
				<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
				<!-- /wp:spacer -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"16px"}}} -->
				<p class="has-text-align-center" style="font-size:16px"><?php esc_html_e( 'Find effective digital reach or your business, powered by human behaviour.', 'ayyash' ); ?></p>
				<!-- /wp:paragraph --></div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:image {"align":"center","id":2388,"sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/results.png" alt="" class="wp-image-2388"/></figure>
				<!-- /wp:image -->

				<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500","textTransform":"capitalize"}},"textColor":"ayyash-heading","fontSize":"ayyash-heading-5"} -->
				<h3 class="has-text-align-center has-ayyash-heading-color has-text-color has-ayyash-heading-5-font-size" style="font-style:normal;font-weight:500;text-transform:capitalize"><?php esc_html_e( 'Results', 'ayyash' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:spacer {"height":"10px"} -->
				<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
				<!-- /wp:spacer -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"16px"}}} -->
				<p class="has-text-align-center" style="font-size:16px"><?php esc_html_e( 'Find effective digital reach or your business, powered by human behaviour.', 'ayyash' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->

	<!-- wp:cover {"dimRatio":90,"minHeight":50,"isDark":false,"align":"full","className":"ayyash-starter-services-wrap ayyash-starter-section-small "} -->
	<div class="wp-block-cover alignfull is-light ayyash-starter-services-wrap ayyash-starter-section-small" style="min-height:50px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-90 has-background-dim"></span>
		<div class="wp-block-cover__inner-container">
			<!-- wp:group {"className":"container","layout":{"type":"constrained"}} -->
			<div class="wp-block-group container">
				<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700","textTransform":"capitalize","lineHeight":1.3}},"textColor":"white","className":"ayyash-starter-section-header","fontSize":"ayyash-heading-3"} -->
				<h2 class="has-text-align-center ayyash-starter-section-header has-white-color has-text-color has-ayyash-heading-3-font-size" style="font-style:normal;font-weight:700;line-height:1.3;text-transform:capitalize"><?php esc_html_e( 'Some More Reasons to Love Our Services', 'ayyash' ); ?></h2>
				<!-- /wp:heading -->

				<!-- wp:group {"tagName":"section","backgroundColor":"white","className":"has-radius ayyash-starter-services","layout":{"type":"default"}} -->
				<section class="wp-block-group has-radius ayyash-starter-services has-white-background-color has-background">
					<!-- wp:columns -->
					<div class="wp-block-columns">
						<!-- wp:column -->
						<div class="wp-block-column">
							<!-- wp:image {"id":2426,"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/high-performance.svg" alt="" class="wp-image-2426"/></figure>
							<!-- /wp:image -->

							<!-- wp:spacer {"height":"20px"} -->
							<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:heading {"level":3,"style":{"color":{"text":"#1a202c"}},"fontSize":"ayyash-heading-6"} -->
							<h3 class="has-text-color has-ayyash-heading-6-font-size" style="color:#1a202c"><?php esc_html_e( 'High Performance', 'ayyash' ); ?></h3>
							<!-- /wp:heading -->

							<!-- wp:spacer {"height":"8px"} -->
							<div style="height:8px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"},"color":{"text":"#2d3748"}}} -->
							<p class="has-text-color" style="color:#2d3748;font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'Find effective digital reach or your business powered by human', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:column -->

						<!-- wp:column -->
						<div class="wp-block-column">
							<!-- wp:image {"id":2441,"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/investment-planning.svg" alt="" class="wp-image-2441"/></figure>
							<!-- /wp:image -->

							<!-- wp:spacer {"height":"20px"} -->
							<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:heading {"level":3,"style":{"color":{"text":"#1a202c"}},"fontSize":"ayyash-heading-6"} -->
							<h3 class="has-text-color has-ayyash-heading-6-font-size" style="color:#1a202c"><?php esc_html_e( 'Investment Planning', 'ayyash' ); ?></h3>
							<!-- /wp:heading -->

							<!-- wp:spacer {"height":"8px"} -->
							<div style="height:8px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"},"color":{"text":"#2d3748"}}} -->
							<p class="has-text-color" style="color:#2d3748;font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'To obtain higher performance Our leaders first identify', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:column -->

						<!-- wp:column -->
						<div class="wp-block-column">
							<!-- wp:image {"id":2443,"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/risk-management.svg" alt="" class="wp-image-2443"/></figure>
							<!-- /wp:image -->

							<!-- wp:spacer {"height":"20px"} -->
							<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:heading {"level":3,"textColor":"ayyash-heading","fontSize":"ayyash-heading-6"} -->
							<h3 class="has-ayyash-heading-color has-text-color has-ayyash-heading-6-font-size"><?php esc_html_e( 'Risk Management', 'ayyash' ); ?></h3>
							<!-- /wp:heading -->

							<!-- wp:spacer {"height":"8px"} -->
							<div style="height:8px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"},"color":{"text":"#2d3748"}}} -->
							<p class="has-text-color" style="color:#2d3748;font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'Obstacles to forward progress and then develop a coherent', 'ayyash' ); ?></p>
							<!-- /wp:paragraph --></div>
						<!-- /wp:column -->
					</div>
					<!-- /wp:columns -->

					<!-- wp:columns -->
					<div class="wp-block-columns">
						<!-- wp:column -->
						<div class="wp-block-column"><!-- wp:image {"id":2446,"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/corporate-finance.svg" alt="" class="wp-image-2446"/></figure>
							<!-- /wp:image -->

							<!-- wp:spacer {"height":"20px"} -->
							<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:heading {"level":3,"textColor":"ayyash-heading","fontSize":"ayyash-heading-6"} -->
							<h3 class="has-ayyash-heading-color has-text-color has-ayyash-heading-6-font-size"><?php esc_html_e( 'Corporate Finance', 'ayyash' ); ?></h3>
							<!-- /wp:heading -->

							<!-- wp:spacer {"height":"8px"} -->
							<div style="height:8px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"},"color":{"text":"#2d3748"}}} -->
							<p class="has-text-color" style="color:#2d3748;font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'Find effective digital reach or your business powered by human', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:column -->

						<!-- wp:column -->
						<div class="wp-block-column"><!-- wp:image {"id":2447,"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/premium-support.svg" alt="" class="wp-image-2447"/></figure>
							<!-- /wp:image -->

							<!-- wp:spacer {"height":"20px"} -->
							<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:heading {"level":3,"textColor":"ayyash-heading","fontSize":"ayyash-heading-6"} -->
							<h3 class="has-ayyash-heading-color has-text-color has-ayyash-heading-6-font-size"><?php esc_html_e( 'Premium Support', 'ayyash' ); ?></h3>
							<!-- /wp:heading -->

							<!-- wp:spacer {"height":"8px"} -->
							<div style="height:8px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"},"color":{"text":"#2d3748"}}} -->
							<p class="has-text-color" style="color:#2d3748;font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'Find effective digital reach or your business powered by human', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:column -->

						<!-- wp:column -->
						<div class="wp-block-column">
							<!-- wp:image {"id":2448,"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/business-analysis.svg" alt="" class="wp-image-2448"/></figure>
							<!-- /wp:image -->

							<!-- wp:spacer {"height":"20px"} -->
							<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:heading {"level":3,"textColor":"ayyash-heading","fontSize":"ayyash-heading-6"} -->
							<h3 class="has-ayyash-heading-color has-text-color has-ayyash-heading-6-font-size"><?php esc_html_e( 'Business Analysis', 'ayyash' ); ?></h3>
							<!-- /wp:heading -->

							<!-- wp:spacer {"height":"8px"} -->
							<div style="height:8px" aria-hidden="true" class="wp-block-spacer"></div>
							<!-- /wp:spacer -->

							<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400"},"color":{"text":"#2d3748"}}} -->
							<p class="has-text-color" style="color:#2d3748;font-size:16px;font-style:normal;font-weight:400"><?php esc_html_e( 'Find effective digital reach or your business powered by human', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:column -->
					</div>
					<!-- /wp:columns -->
				</section>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
	</div>
	<!-- /wp:cover -->

	<!-- wp:group {"align":"full","style":{"color":{"background":"#f4f5f5"}},"className":"ayyash-starter-section","layout":{"type":"constrained"}} -->
	<div class="wp-block-group alignfull ayyash-starter-section has-background" style="background-color:#f4f5f5">
		<!-- wp:group {"className":"container","layout":{"type":"constrained"}} -->
		<div class="wp-block-group container">
			<!-- wp:group {"className":"ayyash-starter-section-header"} -->
			<div class="wp-block-group ayyash-starter-section-header">
				<!-- wp:heading {"textAlign":"center","style":{"color":{"text":"#1a202c"},"typography":{"fontStyle":"normal","fontWeight":"700","textTransform":"capitalize","lineHeight":"1.3"}},"fontSize":"ayyash-heading-3"} -->
				<h2 class="has-text-align-center has-text-color has-ayyash-heading-3-font-size" style="color:#1a202c;font-style:normal;font-weight:700;line-height:1.3;text-transform:capitalize"><?php esc_html_e( 'Featured Works', 'ayyash' ); ?></h2>
				<!-- /wp:heading -->

				<!-- wp:spacer {"height":"15px"} -->
				<div style="height:15px" aria-hidden="true" class="wp-block-spacer"></div>
				<!-- /wp:spacer -->

				<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#2d3748"}}} -->
				<p class="has-text-align-center has-text-color" style="color:#2d3748"><?php esc_html_e( 'Find effective digital reach or your business, powered by human behaviour', 'ayyash' ); ?></p>
				<!-- /wp:paragraph --></div>
			<!-- /wp:group -->

			<!-- wp:columns -->
			<div class="wp-block-columns"><!-- wp:column {"verticalAlignment":"top","backgroundColor":"white","className":"has-radius has-hidden-overflow"} -->
				<div class="wp-block-column is-vertically-aligned-top has-radius has-hidden-overflow has-white-background-color has-background"><!-- wp:image {"align":"full","id":2145,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/featured-1.jpg" alt="" class="wp-image-2145"/></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"}}},"className":"has-bottom-left-radius has-bottom-right-radius","layout":{"type":"constrained"}} -->
					<div class="wp-block-group has-bottom-left-radius has-bottom-right-radius" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"style":{"color":{"text":"#1a202c"},"typography":{"lineHeight":"1.3"}},"fontSize":"ayyash-heading-5"} -->
						<h2 class="has-text-color has-ayyash-heading-5-font-size" style="color:#1a202c;line-height:1.3"><?php esc_html_e( 'Awesome Mobile App', 'ayyash' ); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:spacer {"height":"6px"} -->
						<div style="height:6px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:paragraph {"style":{"typography":{"fontSize":"14px","lineHeight":1.6}}} -->
						<p style="font-size:14px;line-height:1.6"><?php esc_html_e( 'Jul 4, 2022', 'ayyash' ); ?></p>
						<!-- /wp:paragraph --></div>
					<!-- /wp:group --></div>
				<!-- /wp:column -->

				<!-- wp:column {"verticalAlignment":"top","backgroundColor":"white","className":"has-radius has-hidden-overflow"} -->
				<div class="wp-block-column is-vertically-aligned-top has-radius has-hidden-overflow has-white-background-color has-background"><!-- wp:image {"align":"full","id":2148,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/featured-2.jpg" alt="" class="wp-image-2148"/></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"}}},"layout":{"type":"constrained"}} -->
					<div class="wp-block-group" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"style":{"color":{"text":"#1a202c"},"typography":{"lineHeight":"1.3"}},"fontSize":"ayyash-heading-5"} -->
						<h2 class="has-text-color has-ayyash-heading-5-font-size" style="color:#1a202c;line-height:1.3"><?php esc_html_e( 'Man Illustration', 'ayyash' ); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:spacer {"height":"6px"} -->
						<div style="height:6px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:paragraph {"style":{"typography":{"fontSize":"14px","lineHeight":1.6}}} -->
						<p style="font-size:14px;line-height:1.6"><?php esc_html_e( 'Jul 4, 2022', 'ayyash' ); ?></p>
						<!-- /wp:paragraph --></div>
					<!-- /wp:group --></div>
				<!-- /wp:column -->

				<!-- wp:column {"verticalAlignment":"top","backgroundColor":"white","className":"has-radius has-hidden-overflow"} -->
				<div class="wp-block-column is-vertically-aligned-top has-radius has-hidden-overflow has-white-background-color has-background"><!-- wp:image {"align":"full","id":2150,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/featured-3.jpg" alt="" class="wp-image-2150"/></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"}}},"layout":{"type":"constrained"}} -->
					<div class="wp-block-group" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"style":{"color":{"text":"#1a202c"},"typography":{"lineHeight":"1.3"}},"fontSize":"ayyash-heading-5"} -->
						<h2 class="has-text-color has-ayyash-heading-5-font-size" style="color:#1a202c;line-height:1.3"><?php esc_html_e( 'Mobile App Development', 'ayyash' ); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:spacer {"height":"6px"} -->
						<div style="height:6px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:paragraph {"style":{"typography":{"fontSize":"14px","lineHeight":1.6}}} -->
						<p style="font-size:14px;line-height:1.6"><?php esc_html_e( 'Jul 4, 2022', 'ayyash' ); ?></p>
						<!-- /wp:paragraph --></div>
					<!-- /wp:group --></div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"ayyash-starter-section-small is-aligned-center-smaller"} -->
	<div class="wp-block-group ayyash-starter-section-small is-aligned-center-smaller">
		<!-- wp:columns {"className":"container"} -->
		<div class="wp-block-columns container">
			<!-- wp:column {"verticalAlignment":"center","width":"42%"} -->
			<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:42%">
				<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"700","textTransform":"capitalize","lineHeight":"1.3"}},"fontSize":"ayyash-heading-4"} -->
				<h2 class="has-ayyash-heading-4-font-size" style="font-style:normal;font-weight:700;line-height:1.3;text-transform:capitalize"><?php esc_html_e( 'We provide Best Quality Websites for business', 'ayyash' ); ?></h2>
				<!-- /wp:heading -->

				<!-- wp:spacer {"height":"15px"} -->
				<div style="height:15px" aria-hidden="true" class="wp-block-spacer"></div>
				<!-- /wp:spacer -->

				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Find effective digital reach or your business, powered by human behaviour, driven by data we provide experts.', 'ayyash' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center","width":"44%"} -->
			<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:44%"></div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center","width":"14%"} -->
			<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:14%"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons">
					<!-- wp:button {"style":{"color":{"background":"#fbb42f","text":"#1a202c"},"border":{"radius":"10px"},"typography":{"fontSize":"16px"}}} -->
					<div class="wp-block-button has-custom-font-size" style="font-size:16px">
						<a href="https://www.wpayyash.com" class="wp-block-button__link has-text-color has-background wp-element-button" style="border-radius:10px;color:#1a202c;background-color:#fbb42f">
							<?php esc_html_e( 'Contact Us', 'ayyash' ); ?>
						</a>
					</div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->

	<!-- wp:cover {"dimRatio":90,"isDark":false,"align":"full","className":"ayyash-starter-teamwork-wrap ayyash-starter-section-small"} -->
	<div class="wp-block-cover alignfull is-light ayyash-starter-teamwork-wrap ayyash-starter-section-small"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-90 has-background-dim"></span>
		<div class="wp-block-cover__inner-container">
			<!-- wp:group {"className":"container"} -->
			<div class="wp-block-group container">
				<!-- wp:columns {"verticalAlignment":"center"} -->
				<div class="wp-block-columns are-vertically-aligned-center">
					<!-- wp:column {"verticalAlignment":"center","width":"40%"} -->
					<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40%">
						<!-- wp:group {"className":"ayyash-starter-teamwork-thumb"} -->
						<div class="wp-block-group ayyash-starter-teamwork-thumb">
							<!-- wp:image {"id":2614,"sizeSlug":"full","linkDestination":"none","className":"is-style-default has-radius has-full-size-img"} -->
							<figure class="wp-block-image size-full is-style-default has-radius has-full-size-img"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/teamwork.jpg" alt="" class="wp-image-2614"/></figure>
							<!-- /wp:image -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:column -->

					<!-- wp:column {"verticalAlignment":"center","className":"is-aligned-center-smaller"} -->
					<div class="wp-block-column is-vertically-aligned-center is-aligned-center-smaller">
						<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"600"},"color":{"text":"#064af3"}},"fontSize":"ayyash-heading-6"} -->
						<p class="has-text-color has-ayyash-heading-6-font-size" style="color:#064af3;font-style:normal;font-weight:600;line-height:1.3"><?php esc_html_e( 'achievement', 'ayyash' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:spacer {"height":"6px"} -->
						<div style="height:6px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"}},"textColor":"white","fontSize":"ayyash-heading-3"} -->
						<h2 class="has-white-color has-text-color has-ayyash-heading-3-font-size" style="font-style:normal;font-weight:700"><?php esc_html_e( 'Teamwork and intelligence win championships.', 'ayyash' ); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:spacer {"height":"15px"} -->
						<div style="height:15px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:paragraph {"style":{"color":{"text":"#fbebeb"}}} -->
						<p class="has-text-color" style="color:#fbebeb"><?php esc_html_e( 'Find effective digital reach or your business, powered by human behaviour, driven by data we provide experts to create. To obtain higher performance, Our leaders first identify the critical obstacles', 'ayyash' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:group {"textColor":"white","className":"ayyash-starter-teamwork-counterup"} -->
						<div class="wp-block-group ayyash-starter-teamwork-counterup has-white-color has-text-color">
							<!-- wp:columns -->
							<div class="wp-block-columns">
								<!-- wp:column -->
								<div class="wp-block-column">
									<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"600"}},"className":"counter","fontSize":"ayyash-heading-3"} -->
									<h3 class="has-text-align-center counter has-ayyash-heading-3-font-size" style="font-style:normal;font-weight:600;line-height:1.3"><?php esc_html_e( '290', 'ayyash' ); ?></h3>
									<!-- /wp:heading -->

									<!-- wp:spacer {"height":"5px"} -->
									<div style="height:5px" aria-hidden="true" class="wp-block-spacer"></div>
									<!-- /wp:spacer -->

									<!-- wp:paragraph {"align":"center"} -->
									<p class="has-text-align-center"><?php esc_html_e( 'Years of working experience', 'ayyash' ); ?></p>
									<!-- /wp:paragraph --></div>
								<!-- /wp:column -->

								<!-- wp:column -->
								<div class="wp-block-column"><!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"600"}},"className":"counter","fontSize":"ayyash-heading-3"} -->
									<h3 class="has-text-align-center counter has-ayyash-heading-3-font-size" style="font-style:normal;font-weight:600;line-height:1.3"><?php esc_html_e( '112', 'ayyash' ); ?></h3>
									<!-- /wp:heading -->

									<!-- wp:spacer {"height":"5px"} -->
									<div style="height:5px" aria-hidden="true" class="wp-block-spacer"></div>
									<!-- /wp:spacer -->

									<!-- wp:paragraph {"align":"center"} -->
									<p class="has-text-align-center"><?php esc_html_e( 'Established Branches Globally', 'ayyash' ); ?></p>
									<!-- /wp:paragraph -->
								</div>
								<!-- /wp:column -->

								<!-- wp:column -->
								<div class="wp-block-column"><!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"lineHeight":"1.3","fontStyle":"normal","fontWeight":"600"}},"className":"counter","fontSize":"ayyash-heading-3"} -->
									<h3 class="has-text-align-center counter has-ayyash-heading-3-font-size" style="font-style:normal;font-weight:600;line-height:1.3"><?php esc_html_e( '915', 'ayyash' ); ?></h3>
									<!-- /wp:heading -->

									<!-- wp:spacer {"height":"5px"} -->
									<div style="height:5px" aria-hidden="true" class="wp-block-spacer"></div>
									<!-- /wp:spacer -->

									<!-- wp:paragraph {"align":"center"} -->
									<p class="has-text-align-center"><?php esc_html_e( 'Satisfied Clients From Corporate World', 'ayyash' ); ?></p>
									<!-- /wp:paragraph -->
								</div>
								<!-- /wp:column -->
							</div>
							<!-- /wp:columns -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:column -->
				</div>
				<!-- /wp:columns -->
			</div>
			<!-- /wp:group -->
		</div>
	</div>
	<!-- /wp:cover -->

	<!-- wp:group {"className":"ayyash-starter-blog-wrap ayyash-starter-section"} -->
	<div class="wp-block-group ayyash-starter-blog-wrap ayyash-starter-section"><!-- wp:group {"className":"ayyash-starter-section-header container"} -->
		<div class="wp-block-group ayyash-starter-section-header container"><!-- wp:heading {"textAlign":"center","style":{"color":{"text":"#1a202c"},"typography":{"fontStyle":"normal","fontWeight":"700","textTransform":"capitalize","lineHeight":"1.3"}},"fontSize":"ayyash-heading-3"} -->
			<h2 class="has-text-align-center has-text-color has-ayyash-heading-3-font-size" style="color:#1a202c;font-style:normal;font-weight:700;line-height:1.3;text-transform:capitalize"><?php esc_html_e( 'Latest Posts', 'ayyash' ); ?></h2>
			<!-- /wp:heading -->

			<!-- wp:spacer {"height":"15px"} -->
			<div style="height:15px" aria-hidden="true" class="wp-block-spacer"></div>
			<!-- /wp:spacer -->

			<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#2d3748"}}} -->
			<p class="has-text-align-center has-text-color" style="color:#2d3748"><?php esc_html_e( 'Find effective digital reach or your business, powered by human behaviour', 'ayyash' ); ?></p>
			<!-- /wp:paragraph --></div>
		<!-- /wp:group -->

		<!-- wp:group {"className":"container","layout":{"type":"constrained"}} -->
		<div class="wp-block-group container"><!-- wp:columns -->
			<div class="wp-block-columns"><!-- wp:column {"verticalAlignment":"top","backgroundColor":"white"} -->
				<div class="wp-block-column is-vertically-aligned-top has-white-background-color has-background"><!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"}}},"className":"has-radius has-border has-inner-shadow","layout":{"type":"constrained"}} -->
					<div class="wp-block-group has-radius has-border has-inner-shadow" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"full","id":2276,"sizeSlug":"full","linkDestination":"none"} -->
						<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/blog-1.jpg" alt="" class="wp-image-2276"/></figure>
						<!-- /wp:image -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:group {"className":"post-tags","layout":{"type":"flex","flexWrap":"nowrap","orientation":"horizontal"}} -->
						<div class="wp-block-group post-tags"><!-- wp:html -->
							<i class="ai ai-tags" aria-hidden="true"></i>
							<!-- /wp:html -->

							<!-- wp:paragraph -->
							<p><?php esc_html_e( 'Review', 'ayyash' ); ?></p>
							<!-- /wp:paragraph --></div>
						<!-- /wp:group -->

						<!-- wp:spacer {"height":"10px"} -->
						<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:heading {"level":3,"style":{"color":{"text":"#1a202c"},"typography":{"lineHeight":"1.3"}},"fontSize":"ayyash-heading-5"} -->
						<h3 class="has-text-color has-ayyash-heading-5-font-size" style="color:#1a202c;line-height:1.3"><?php esc_html_e( 'Why every startup should', 'ayyash' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:paragraph -->
						<p><?php esc_html_e( 'More off this less hello salamander lied porpoise much over tightly...', 'ayyash' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
						<div class="wp-block-group">
							<!-- wp:paragraph {"style":{"typography":{"fontSize":"14px","lineHeight":1.6}}} -->
							<p style="font-size:14px;line-height:1.6"><?php esc_html_e( 'Jul 4, 2022', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:group -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons"><!-- wp:button {"style":{"color":{"background":"#fbb42f","text":"#1a202c"},"border":{"radius":"10px"},"typography":{"fontSize":"16px"}}} -->
							<div class="wp-block-button has-custom-font-size" style="font-size:16px"><a class="wp-block-button__link has-text-color has-background wp-element-button" style="border-radius:10px;color:#1a202c;background-color:#fbb42f">Read More</a></div>
							<!-- /wp:button --></div>
						<!-- /wp:buttons --></div>
					<!-- /wp:group --></div>
				<!-- /wp:column -->

				<!-- wp:column {"verticalAlignment":"top","backgroundColor":"white"} -->
				<div class="wp-block-column is-vertically-aligned-top has-white-background-color has-background"><!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"}}},"className":"has-radius has-border has-inner-shadow","layout":{"type":"constrained"}} -->
					<div class="wp-block-group has-radius has-border has-inner-shadow" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"full","id":2278,"sizeSlug":"full","linkDestination":"none"} -->
						<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/blog-2.jpg" alt="" class="wp-image-2278"/></figure>
						<!-- /wp:image -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:group {"className":"post-tags","layout":{"type":"flex","flexWrap":"nowrap","orientation":"horizontal"}} -->
						<div class="wp-block-group post-tags"><!-- wp:html -->
							<i class="ai ai-tags" aria-hidden="true"></i>
							<!-- /wp:html -->

							<!-- wp:paragraph -->
							<p><?php esc_html_e( 'Business', 'ayyash' ); ?></p>
							<!-- /wp:paragraph --></div>
						<!-- /wp:group -->

						<!-- wp:spacer {"height":"10px"} -->
						<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:heading {"level":3,"style":{"color":{"text":"#1a202c"},"typography":{"lineHeight":"1.3"}},"fontSize":"ayyash-heading-5"} -->
						<h3 class="has-text-color has-ayyash-heading-5-font-size" style="color:#1a202c;line-height:1.3"><?php esc_html_e( '12 Ways to monetize your', 'ayyash' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:paragraph -->
						<p><?php esc_html_e( 'More off this less hello salamander lied porpoise much over tightly...', 'ayyash' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
						<div class="wp-block-group">
							<!-- wp:paragraph {"style":{"typography":{"fontSize":"14px","lineHeight":1.6}}} -->
							<p style="font-size:14px;line-height:1.6"><?php esc_html_e( 'Nov 3, 2022', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:group -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons"><!-- wp:button {"style":{"color":{"background":"#fbb42f","text":"#1a202c"},"border":{"radius":"10px"},"typography":{"fontSize":"16px"}}} -->
							<div class="wp-block-button has-custom-font-size" style="font-size:16px"><a class="wp-block-button__link has-text-color has-background wp-element-button" style="border-radius:10px;color:#1a202c;background-color:#fbb42f">Read More</a></div>
							<!-- /wp:button --></div>
						<!-- /wp:buttons --></div>
					<!-- /wp:group --></div>
				<!-- /wp:column -->

				<!-- wp:column {"verticalAlignment":"top","backgroundColor":"white"} -->
				<div class="wp-block-column is-vertically-aligned-top has-white-background-color has-background"><!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"}}},"className":"has-radius has-border has-inner-shadow","layout":{"type":"constrained"}} -->
					<div class="wp-block-group has-radius has-border has-inner-shadow" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"full","id":2279,"sizeSlug":"full","linkDestination":"none"} -->
						<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/blog-3.jpg" alt="" class="wp-image-2279"/></figure>
						<!-- /wp:image -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:group {"className":"post-tags","layout":{"type":"flex","flexWrap":"nowrap","orientation":"horizontal"}} -->
						<div class="wp-block-group post-tags"><!-- wp:html -->
							<i class="ai ai-tags" aria-hidden="true"></i>
							<!-- /wp:html -->

							<!-- wp:paragraph -->
							<p><?php esc_html_e( 'Video', 'ayyash' ); ?></p>
							<!-- /wp:paragraph --></div>
						<!-- /wp:group -->

						<!-- wp:spacer {"height":"10px"} -->
						<div style="height:10px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:heading {"level":3,"style":{"color":{"text":"#1a202c"},"typography":{"lineHeight":"1.3"}},"fontSize":"ayyash-heading-5"} -->
						<h3 class="has-text-color has-ayyash-heading-5-font-size" style="color:#1a202c;line-height:1.3"><?php esc_html_e( 'How to start a podcast', 'ayyash' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:paragraph -->
						<p><?php esc_html_e( 'More off this less hello salamander lied porpoise much over tightly...', 'ayyash' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
						<div class="wp-block-group">
							<!-- wp:paragraph {"style":{"typography":{"fontSize":"14px","lineHeight":1.6}}} -->
							<p style="font-size:14px;line-height:1.6"><?php esc_html_e( 'Jul 4, 2022', 'ayyash' ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:group -->

						<!-- wp:spacer {"height":"20px"} -->
						<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons"><!-- wp:button {"style":{"color":{"background":"#fbb42f","text":"#1a202c"},"border":{"radius":"10px"},"typography":{"fontSize":"16px"}}} -->
							<div class="wp-block-button has-custom-font-size" style="font-size:16px"><a class="wp-block-button__link has-text-color has-background wp-element-button" style="border-radius:10px;color:#1a202c;background-color:#fbb42f">Read More</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:group -->

	<!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/cta-bg.png","id":2653,"dimRatio":80,"customOverlayColor":"#0746e5","minHeight":50,"align":"full","className":"ayyash-starter-cta-wrap ayyash-starter-section-small"} -->
	<div class="wp-block-cover alignfull ayyash-starter-cta-wrap ayyash-starter-section-small" style="min-height:50px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-80 has-background-dim" style="background-color:#0746e5"></span><img class="wp-block-cover__image-background wp-image-2653" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/dist/images/starter-content/cta-bg.png" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"className":"container","layout":{"type":"constrained"}} -->
			<div class="wp-block-group container"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700","lineHeight":"1.3"}},"fontSize":"ayyash-heading-3"} -->
				<h2 class="has-text-align-center has-ayyash-heading-3-font-size" style="font-style:normal;font-weight:700;line-height:1.3"><?php esc_html_e( 'Ready to get started?', 'ayyash' ); ?></h2>
				<!-- /wp:heading -->

				<!-- wp:spacer {"height":"20px"} -->
				<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
				<!-- /wp:spacer -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"16px"}}} -->
				<p class="has-text-align-center" style="font-size:16px"><?php echo wp_kses_post( 'Download your copy of Ayyash today and create your next website faster than ever.<br>All pre-built websites with all features are included.' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons">
					<!-- wp:button {"textColor":"ayyash-heading","style":{"color":{"background":"#fbb42f"},"border":{"radius":"10px"},"spacing":{"padding":{"top":"15px","bottom":"15px","left":"30px","right":"30px"}},"typography":{"fontSize":"17px"}},"className":"has-shadow"} -->
					<div class="wp-block-button has-custom-font-size has-shadow" style="font-size:17px">
						<a href="https://www.wpayyash.com" class="wp-block-button__link has-ayyash-heading-color has-text-color has-background wp-element-button" style="border-radius:10px;background-color:#fbb42f;padding-top:15px;padding-right:30px;padding-bottom:15px;padding-left:30px">
							<?php esc_html_e( 'Get Started', 'ayyash' ); ?>
						</a>
					</div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
	</div>
	<!-- /wp:cover -->

	<?php
	$home_content = ob_get_clean();

	// Define and register starter content to showcase the theme on new sites.
	$starter_content = array(
		// Specify the core-defined pages to create and add custom thumbnails to some of them.
		'posts'     => array(
			'front' => array(
				'post_type'    => 'page',
				'template'     => 'template-starter.php',
				'post_title'   => esc_html_x( 'Create and grow your unique website today', 'Theme starter content', 'ayyash' ),
				'post_content' => $home_content,
			),
			'about',
			'blog',
			'contact',
		),
		// Default to a static front page and assign the front and posts pages.
		'options'   => array(
			'show_on_front'  => 'page',
			'page_on_front'  => '{{front}}',
			'page_for_posts' => '{{blog}}',
		),
		// Set up nav menus for each of the two areas registered in the theme.
		'nav_menus' => array(
			'primary' => array(
				'name'  => esc_html__( 'Primary menu', 'ayyash' ),
				'items' => array(
					'link_home',
					'page_about'   => array(
						'type'      => 'post_type',
						'object'    => 'page',
						'object_id' => '{{about}}',
					),
					'page_blog'    => array(
						'type'      => 'post_type',
						'object'    => 'page',
						'object_id' => '{{blog}}',
					),
					'page_contact' => array(
						'type'      => 'post_type',
						'object'    => 'page',
						'object_id' => '{{contact}}',
					),
				),
			),
			'mobile'  => array(
				'name'  => esc_html__( 'Mobile Menu', 'ayyash' ),
				'items' => array(
					'link_home',
					'page_about',
					'page_blog',
					'page_contact',
					'link_facebook',
					'link_twitter',
					'link_instagram',
					'link_email',
				),
			),
		),
		'widgets'   => array(
			'main-sidebar'         => array(
				'search'          => array(
					'search',
					array(
						'title' => '',
					),
				),
				'recent-posts'    => array(
					'recent-posts',
					array(
						'title' => _x( 'Recent Posts', 'Theme starter content', 'ayyash' ),
					),
				),
				'recent-comments' => array(
					'recent-comments',
					array(
						'title' => _x( 'Recent Comments', 'Theme starter content', 'ayyash' ),
					),
				),
				'archives'        => array(
					'archives',
					array(
						'title' => _x( 'Archives', 'Theme starter content', 'ayyash' ),
					),
				),
				'categories'      => array(
					'categories',
					array(
						'title' => _x( 'Categories', 'Theme starter content', 'ayyash' ),
					),
				),
				'meta'            => array(
					'meta',
					array(
						'title' => _x( 'Meta', 'Theme starter content', 'ayyash' ),
					),
				),
			),
			'footer-top-widget'    => array(
				'text_business_info' => array(
					'title'  => _x( 'Find Us', 'Theme starter content', 'ayyash' ),
					'text'   => implode(
						'',
						array(
							'<strong>' . _x( 'Address', 'Theme starter content', 'ayyash' ) . "</strong>\n",
							_x( '123 Main Street', 'Theme starter content', 'ayyash' ) . "\n" . _x( 'New York, NY 10001', 'Theme starter content', 'ayyash' ) . "\n\n",
							'<strong>' . _x( 'Hours', 'Theme starter content', 'ayyash' ) . "</strong>\n",
							_x( 'Monday&ndash;Friday: 9:00AM&ndash;5:00PM', 'Theme starter content', 'ayyash' ) . "\n" . _x( 'Saturday &amp; Sunday: 11:00AM&ndash;3:00PM', 'Theme starter content', 'ayyash' ),
						)
					),
					'filter' => true,
					'visual' => true,
				),
				'text_about'         => array(
					'text',
					array(
						'title'  => _x( 'About This Site', 'Theme starter content', 'ayyash' ),
						'text'   => _x( 'This may be a good place to introduce yourself and your site or include some credits.', 'Theme starter content', 'ayyash' ),
						'filter' => true,
						'visual' => true,
					),
				),
			),
			'footer-widget'        => array(),
			'footer-bottom-widget' => array(),
		),
	);

	// phpcs:enable

	/**
	 * Filters the array of starter content.
	 *
	 * @param array $starter_content Array of starter content.
	 */
	return apply_filters( 'ayyash_starter_content', $starter_content );
}

// End of file starter-content.php.
