<?php

// phpcs:disable
use Ayyash\AdminOptions\Ayyash_Admin_Options;
// phpcs:enable

$ayyash_recommended_plugins = Ayyash_Admin_Options::recommended_plugins();

$installed_plugins = apply_filters( 'all_plugins', get_plugins() );
foreach ( $ayyash_recommended_plugins as $ayyash_recommended_plugin ) {
	$is_plugin_active = is_plugin_active( $ayyash_recommended_plugin['file'] );
	$is_installed     = isset( $installed_plugins[ $ayyash_recommended_plugin['file'] ] );
	$classes          = 'ayyash-options-button';
	if ( ! $is_installed ) {
		$classes .= ' install-now button-primary';
		$label    = __( 'Install', 'ayyash' );
	} elseif ( $is_plugin_active ) {
		$classes .= ' deactivate-now button-primary';
		$label    = __( 'Deactivate', 'ayyash' );
	} else {
		$classes .= ' activate-now button-primary';
		$label    = __( 'Activate', 'ayyash' );
	}
	?>
	<div class="ayyash-options-plugin-card__wrap plugin-card plugin-card-<?php echo esc_attr( $ayyash_recommended_plugin['slug'] );
	echo $is_plugin_active ? ' plugin-activated' : ''; ?>">
		<div class="ayyash-options-plugin-card__body">
			<?php
			printf(
				'<img src="https://ps.w.org/%s/assets/%s" alt="%s">',
				esc_attr( $ayyash_recommended_plugin['slug'] ),
				esc_attr( $ayyash_recommended_plugin['icon'] ),
				esc_html( $ayyash_recommended_plugin['name'] )
			); ?>
		</div><!-- end .ayyash-options-plugin-card__body -->
		<div class="ayyash-options-plugin-card__footer">

			<div class="ayyash-options-plugin-card__footer-title ayyash-option-plugin-name" title="<?php echo esc_attr( $ayyash_recommended_plugin['name'] ); ?>">
				<?php echo esc_html( $ayyash_recommended_plugin['name'] ); ?>
			</div><!-- end .ayyash-options-plugin-card__footer-title -->

			<div class="ayyash-options-plugin-card__footer-link">
				<?php
				$ayyash_recommended_plugin_name = sprintf(
				/* translators: %s. Plugin Name. */
					__( 'Install %s now', 'ayyash' ),
					$ayyash_recommended_plugin['name']
				);
				printf(
					'<button class="%s" data-mainfile="%s" data-slug="%s" aria-label="%s" data-name="%s">%s</button>',
					esc_attr( $classes ),
					esc_attr( $ayyash_recommended_plugin['file'] ),
					esc_attr( $ayyash_recommended_plugin['slug'] ),
					esc_attr( $ayyash_recommended_plugin_name ),
					esc_attr( $ayyash_recommended_plugin['name'] ),
					esc_html( $label )
				);
				?>
			</div><!-- end .ayyash-options-plugin-card__footer-link -->
		</div><!-- end .ayyash-options-plugin-card__footer -->

	</div><!-- end .ayyash-options-plugin-card__wrap -->
	<?php
}
