<?php
/**
 * Mega Menu
 *
 * @version 1.0.0
 * @package Ayyash/MegaMenu
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/** @define "AYYASH_THEME_DIR" "./../../" */ // phpcs:ignore Generic.Commenting.DocComment.MissingShort

// phpcs:disable WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require AYYASH_THEME_DIR . 'inc/menu/class-ayyash-walker-nav-menu-edit-custom.php';
require AYYASH_THEME_DIR . 'inc/menu/class-ayyash-walker-nav-menu-custom.php';

require AYYASH_THEME_DIR . 'inc/menu/class-ayyash-megamenu-api.php';
require AYYASH_THEME_DIR . 'inc/menu/class-ayyash-icons-dialog.php';
// phpcs:enable

// Menu Helper Functions.

if ( ! function_exists( 'ayyash_site_menu' ) ) {
	/**
	 * Site menu.
	 *
	 * @return void
	 */
	function ayyash_site_menu() {
		$mobile_grid = ayyash_get_mod( 'layout_header_menu_mobileshow' );
		switch ( $mobile_grid ) {
			case 'sm':
				$mobile_grid = 'd-none d-md-flex';
				break;
			case 'md':
				$mobile_grid = ' d-none d-lg-flex';
				break;
			case 'lg':
				$mobile_grid = ' d-none d-xl-flex';
				break;
			case 'xl':
				$mobile_grid = ' d-none';
				break;
			default:
				$mobile_grid = ' d-none d-md-flex';
		}
		?>
		<div id="site-nav" class="<?php echo esc_attr( $mobile_grid ); ?>" role="navigation">
			<?php
			if ( has_nav_menu( 'primary' ) ) {
				wp_nav_menu( array( 'theme_location' => 'primary' ) );
			} else {
				?>
				<div class="menu-not-assigned pull-right"><a href="<?php echo esc_url( admin_url( 'nav-menus.php' ) ); ?>" class="ayyash-sticky-item"><?php esc_html_e( 'No Menu Assigned , Please Add', 'ayyash' ); ?></a></div>
			<?php } ?>
		</div>
		<?php
	}
}

// End of file menu.php
