<?php
/**
 * @package Ayyash
 * @author  Ayyash
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/**
 * Contains methods for adding Layout Customization Panel and all settings under it
 *
 * @since Pxlrtheme 1.0
 */
class Ayyash_Customize_WooCommerce {

	/**
	 * Register panel and add settings.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer Instance.
	 *
	 * @return void
	 */
	public static function register( $wp_customize ) {

		$panel_id = 'woocommerce';

		$wp_customize->add_panel(
			$panel_id,
			array(
				'priority'       => 35,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => 'WooCommerce',
			)
		);

		// Woocommerce General.
		$section_id = 'woocommerce_general';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'General', 'ayyash' ),
				'priority'   => 9,
				'capability' => 'edit_theme_options',
				'panel'      => $panel_id,
			)
		);

		$setting_id = $section_id . '_enable_product_flying_cart';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Enable Product Flying Cart', 'ayyash' ),
					'description' => __(
						'Enable product zoom feature at single product page',
						'ayyash'
					),
					'section'     => $section_id,
					'settings'    => $setting_id,
					'type'        => 'checkbox',
				)
			)
		);

		// Enable Product Zoom.
		$setting_id = $section_id . '_enable_product_zoom';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Enable Product Zoom', 'ayyash' ),
					'description' => __(
						'Enable product zoom feature at single product page',
						'ayyash'
					),
					'section'     => $section_id,
					'settings'    => $setting_id,
					'type'        => 'checkbox',
				)
			)
		);

		// Enable Product Lightbox.
		$setting_id = $section_id . '_enable_product_lightbox';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Enable Product Lightbox', 'ayyash' ),
					'description' => __(
						'Enable product lightbox feature at single product page',
						'ayyash'
					),
					'section'     => $section_id,
					'settings'    => $setting_id,
					'type'        => 'checkbox',
				)
			)
		);

		// Enable Product Gallery Slider.
		$setting_id = $section_id . '_enable_product_gallery_slider';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Enable Product Gallery Slider', 'ayyash' ),
					'description' => __(
						'Enable product gallery slider feature at single product page',
						'ayyash'
					),
					'section'     => $section_id,
					'settings'    => $setting_id,
					'type'        => 'checkbox',
				)
			)
		);

		// Woocommerce Shop & Archive.
		$section_id = 'woocommerce_shop_archive';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Shop', 'ayyash' ),
				'priority'   => 9,
				'capability' => 'edit_theme_options',
				'panel'      => $panel_id,
			)
		);

		// Shop page Title Bar.
		$setting_id = $section_id . '_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Shop & Archive Title.
		$setting_id = $section_id . '_title';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Shop Title', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Shop & Archive Post Per page.
		$setting_id = $section_id . '_per_page';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Shop Posts Per Page', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// Shop Layout.
		$setting_id = $section_id . '_layout';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Shop Layout.
		$setting_id = $section_id . '_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Shop Sidebar', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Shop Column.
		$setting_id = $section_id . '_column';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Shop Column', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Shop & Archive Shop Result Count.
		$setting_id = $section_id . '_sort';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Shop Sort', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Shop & Archive Shop Result Count.
		$setting_id = $section_id . '_result_count';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Shop Result Count', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Product Catalogue.
		$section_id = 'woocommerce_product_catalog';

		$setting_id = $section_id . '_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Woocommerce Single.
		$section_id = 'woocommerce_single';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Single', 'ayyash' ),
				'priority'   => 13,
				'capability' => 'edit_theme_options',
				'panel'      => $panel_id,
			)
		);

		// Shop Single Layout.
		$setting_id = $section_id . '_layout';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Shop Single Layout.
		$setting_id = $section_id . '_sidebar';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Single Product Sidebar', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Shop Single Up-Sells Count.
		$setting_id = $section_id . '_upsells_count';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'esc_attr',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Up-Sells Count', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// Shop Single Related Item Count.
		$setting_id = $section_id . '_related_item_count';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Related Item Count', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// Shop Single Related Item Column.
		$setting_id = $section_id . '_related_product_column';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Related Products Column', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Shop Single attribute Label.
		$setting_id = $section_id . '_attribute_label';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);
		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'   => __( 'Product Attributes', 'ayyash' ),
					'section' => $section_id,
					'type'    => 'helptext',
				)
			)
		);

		// Shop Single attribute.
		$setting_id = $section_id . '_attribute';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Product Attribute Style', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Woocommerce shop category and tag page.
		$section_id = 'woocommerce_taxonomy_archive';
		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Archive', 'ayyash' ),
				'priority'   => 13,
				'capability' => 'edit_theme_options',
				'panel'      => $panel_id,
			)
		);

		$setting_id = $section_id . '_cat_label';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);
		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'   => __( 'Category Archive settings', 'ayyash' ),
					'section' => $section_id,
					'type'    => 'helptext',
				)
			)
		);

		//layout
		$setting_id = $section_id . '_cat_layout';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// sidebar.
		$setting_id = $section_id . '_cat_sidebar';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Category Archive Sidebar', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = $section_id . '_tag_label';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);
		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'   => __( 'Tag Archive settings', 'ayyash' ),
					'section' => $section_id,
					'type'    => 'helptext',
				)
			)
		);

		//layout
		$setting_id = $section_id . '_tag_layout';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// sidebar.
		$setting_id = $section_id . '_tag_sidebar';
		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Tag Archive Sidebar', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Woocommerce Cart.
		$section_id = 'woocommerce_cart';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Cart', 'ayyash' ),
				'priority'   => 15,
				'capability' => 'edit_theme_options',
				'panel'      => $panel_id,
			)
		);

		$setting_id = $section_id . '_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Cart Layout Settings.
		$setting_id = $section_id . '_sidebar_layout';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Cart Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Shop Single Layout.
		$setting_id = $section_id . '_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Cart Sidebar', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Cart Up-Sells Count.
		$setting_id = $section_id . '_cross_sell_count';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Cross Sell Count', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// Cart Up-Sells Column.
		$setting_id = $section_id . '_cross_sell_column';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Cross Sell Column', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Woocommerce Checkout.
		$section_id = 'woocommerce_checkout';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Checkout', 'ayyash' ),
				'priority'   => 16,
				'capability' => 'edit_theme_options',
				'panel'      => $panel_id,
			)
		);

		$setting_id = $section_id . '_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = $section_id . '_sidebar_layout';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Cart Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = $section_id . '_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Checkout Sidebar', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// My Account Page Settings.
		$section_id = 'woocommerce_myaccount';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'My Account', 'ayyash' ),
				'priority'   => 16,
				'capability' => 'edit_theme_options',
				'panel'      => $panel_id,
			)
		);

		$setting_id = $section_id . '_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = $section_id . '_sidebar_layout';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Cart Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = $section_id . '_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Checkout Sidebar', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = $section_id . '_sign_in_image';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'theme_mod',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'         => __( 'Signin image', 'ayyash' ),
					'description'   => __( 'Will be display in WooCommerce Sign in form page', 'ayyash' ),
					'section'       => $section_id,
					'settings'      => $setting_id,
					'height'        => '',
					'width'         => '',
					'flex_height'   => '',
					'flex_width'    => '',
					'button_labels' => [
						'select'       => __( 'Select Signin image', 'ayyash' ),
						'change'       => __( 'Change Signin image', 'ayyash' ),
						'remove'       => __( 'Remove', 'ayyash' ),
						'default'      => __( 'Default', 'ayyash' ),
						'placeholder'  => __( 'No Signin image selected', 'ayyash' ),
						'frame_title'  => __( 'Select Signin image', 'ayyash' ),
						'frame_button' => __( 'Choose Signin image', 'ayyash' ),
					],
				)
			)
		);

		$setting_id = $section_id . '_sign_up_image';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'theme_mod',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'         => __( 'Signup image', 'ayyash' ),
					'description'   => __( 'Will be display in WooCommerce Sign in form page when user registration is enabled for myaccount page from <b>WooCommerce > Settings > Accounts & Privacy > account creation</b> section', 'ayyash' ),
					'section'       => $section_id,
					'settings'      => $setting_id,
					'height'        => '',
					'width'         => '',
					'flex_height'   => '',
					'flex_width'    => '',
					'button_labels' => [
						'select'       => __( 'Select Signup image', 'ayyash' ),
						'change'       => __( 'Change Signup image', 'ayyash' ),
						'remove'       => __( 'Remove', 'ayyash' ),
						'default'      => __( 'Default', 'ayyash' ),
						'placeholder'  => __( 'No Signup image selected', 'ayyash' ),
						'frame_title'  => __( 'Select Signup image', 'ayyash' ),
						'frame_button' => __( 'Choose Signup image', 'ayyash' ),
					],
				)
			)
		);
	}
}
