<?php
/**
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}


/**
 * Contains methods for customizing the theme customization screen.
 *
 * @link http://codex.wordpress.org/Theme_Customization_API
 * @since Pxlrtheme 1.0
 */
class Ayyash_Customize_Typography {

	const PANEL_ID = 'typography';

	/**
	 * Register panel and add settings.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer Instance.
	 *
	 * @return void
	 */
	public static function register( $wp_customize ) {

		$wp_customize->remove_section( 'colors' );

		$wp_customize->add_panel(
			self::PANEL_ID,
			array(
				'priority'       => 10,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Typography', 'ayyash' ),
				'description'    => '',
			)
		);

		self::typography_global( $wp_customize );
		self::typography_site( $wp_customize );
		self::typography_heading( $wp_customize );
		self::typography_menu( $wp_customize );
		self::typography_mega_menu( $wp_customize );
		self::typography_sidebar( $wp_customize );
		self::typography_footer( $wp_customize );

	}

	protected static function typography_global( $wp_customize ) {
		$section_id = 'typography';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Global', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = $section_id . '_global_scale';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id . '_heading',
				[
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Type Scale', 'ayyash' ),
				]
			)
		);

		$wp_customize->add_setting(
			$setting_id,
			[
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'esc_attr',
			]
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				[
					'label'       => '',
					'section'     => $section_id,
					'settings'    => $setting_id,
					'description' => sprintf(
						/* translators: %1$s: Type-scale doc link tag open %2$s: link tag close */
						__( 'Typographic (or type) scale for balanced and friendly font sizing based on base (global text or body) font-size. %1$sRead more%2$s', 'ayyash' ),
						'<a href="https://docs.ayyash.com/docs/ayyash/typography/" target="_blank" rel="noopener">',
						'</a>'
					),
					'type'        => 'select',
					'choices'     => [
						'1.067' => __( 'Minor Second', 'ayyash' ),
						'1.125' => __( 'Major Second', 'ayyash' ),
						'1.2'   => __( 'Minor Third', 'ayyash' ),
						'1.25'  => __( 'Major Third', 'ayyash' ),
						'1.333' => __( 'Perfect Fourth', 'ayyash' ),
						'1.414' => __( 'Augmented Fourth', 'ayyash' ),
						'1.5'   => __( 'Perfect Fifth', 'ayyash' ),
						'1.618' => __( 'Golden Ratio', 'ayyash' ),
					],
				]
			)
		);

		/* Global */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Body', 'ayyash' ), 'global' );

		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Headings', 'ayyash' ), 'heading', 'size' );
	}

	protected static function typography_site_title( $wp_customize ) {
		$section_id = 'typography_site_title';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Site Title', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		/* Site Title */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Site Title', 'ayyash' ), '', true );
	}

	protected static function typography_heading( $wp_customize ) {
		$section_id = 'typography_heading';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Text Headings', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		/* H1 */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'H1', 'ayyash' ), 'h1' );

		/* H2 */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'H2', 'ayyash' ), 'h2' );

		/* H3 */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'H3', 'ayyash' ), 'h3' );

		/* H4 */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'H4', 'ayyash' ), 'h4' );

		/* H5 */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'H5', 'ayyash' ), 'h5' );

		/* H6 */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'H6', 'ayyash' ), 'h6' );
	}

	protected static function typography_menu( $wp_customize ) {

		$section_id = 'typography_menu';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Main Menu', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		/* Menu Items */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Menu Items', 'ayyash' ), null, 'line_height' );

		/* Sub Menu Items */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Sub Menu Items', 'ayyash' ), 'sub' );

		/* Mobile Menu Items */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Mobile Menu Items', 'ayyash' ), 'mobile' );
	}

	protected static function typography_mega_menu( $wp_customize ) {

		$section_id = 'typography_mega_menu';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Mega Menu', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);
		/* Menu Title */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Mega Menu Title', 'ayyash' ), null );

		/* Menu Items */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Mega Menu Items', 'ayyash' ), 'sub' );

	}

	protected static function typography_site( $wp_customize ) {

		$section_id = 'typography_site';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Site Title & Tagline', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		/* Site Title */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Site Title', 'ayyash' ), 'title' );

		/* Site Tagline */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Site Tagline', 'ayyash' ), 'tagline' );

	}

	protected static function typography_sidebar( $wp_customize ) {

		$section_id = 'typography_sidebar';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Sidebar', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		/* Site Title */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Widget Title', 'ayyash' ), 'title' );

		/* Site Tagline */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Widget Body', 'ayyash' ), 'body' );

	}

	protected static function typography_footer( $wp_customize ) {

		$section_id = 'typography_footer';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Footer', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		/* Widget Title */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Widget Title', 'ayyash' ), 'title' );

		/* Widget Body */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Widget Body', 'ayyash' ), 'body' );

		/* Secondary Footer */
		ayyash_generate_font_control( $wp_customize, $section_id, __( 'Footer Text', 'ayyash' ), 'text' );

	}
}
