<?php
/**
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/**
 * Contains methods for adding Layout Customization Panel and all settings under it
 *
 * @since Pxlrtheme 1.0
 */
class Ayyash_Customize_Layout {

	const PANEL_ID = 'layout';

	/**
	 * Register panel and add settings.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer Instance.
	 *
	 * @return void
	 */
	public static function register( $wp_customize ) {

		$wp_customize->add_panel(
			self::PANEL_ID,
			array(
				'priority'       => 10,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => 'Layout',
			)
		);

		self::global_layout( $wp_customize );
		self::header_layout( $wp_customize );
		self::title_layout( $wp_customize );
		self::layout_blog_home( $wp_customize );
		self::layout_blog( $wp_customize );
		self::layout_archive( $wp_customize );
		self::layout_search( $wp_customize );
		self::layout_post( $wp_customize );
		self::layout_page( $wp_customize );
		self::layout_footer( $wp_customize );
	}

	protected static function global_layout( $wp_customize ) {
		/*******************
		 * // Global Section
		 */

		$section_id = 'layout_global';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Global', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		// Site Layout
		$setting_id = 'layout_global_site';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Site Layout', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Site Layout
		$setting_id = 'layout_global_content_layout';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Container Layout', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_global_content_layout_max_width';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Container Max Width', 'ayyash' ),
					'description' => __( 'Max width applicable only container-fluid case for Container Layout', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		// Content Width
		$setting_id = 'layout_global_content_grid';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Content Width', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Sidebar Width
		$setting_id = 'layout_global_sidebar_grid';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Width', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);
	}

	protected static function header_layout( $wp_customize ) {
		/******************
		 * // Header Section
		 */

		$section_id = 'layout_header';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Header', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		/*
		----------------------------------------------------------------------
		 * Topbar/ Secondary header
		 *----------------------------------------------------------------------*/

		$setting_id = 'layout_header_top_bar_section_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Top Bar / Secondary Header Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change Top Bar / Secondary header Related Settings', 'ayyash' ),
				)
			)
		);

		// Show Secondary Header
		$setting_id = 'layout_header_secondary';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Secondary Header', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Secondary Header Layout
		$setting_id = 'layout_header_secondary_layout';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Secondary Header Layout', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Header Callout Text
		$setting_id = 'layout_header_callout';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Textarea_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Secondary Header Callout Text', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		/*
		----------------------------------------------------------------------
		 * End of secondary header
		 *----------------------------------------------------------------------*/

		/*
		----------------------------------------------------------------------
		 * Start Main Header and Menu Configuration
		 *----------------------------------------------------------------------*/
		$setting_id = 'layout_header_header_section_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Header and Menu Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change Header settings and related configuration', 'ayyash' ),
				)
			)
		);

		// Header Height
		$setting_id = 'layout_header_height';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header Height', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Mobile Menu show grid section
		$setting_id = 'layout_header_menu_mobileshow';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Mobile Menu / Hide Main Menu', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Mobile Menu Style
		$setting_id = 'layout_header_mobile_menu_style';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Mobile Menu Style', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Main Menu Alignment
		$setting_id = 'layout_header_menu_alignment';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Main Menu Alignment', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);


		// Main Menu Styles
		$setting_id = 'layout_header_menu_style';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Main Menu Color Styles', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Main Menu Hover Styles
		$setting_id = 'layout_header_menu_hover_style';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Main Menu Color Hover Styles', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);


		// Main Submenu Alignment
		$setting_id = 'layout_header_submenu_alignment';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Main Submenu Alignment', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Submenu Width
		$setting_id = 'layout_header_submenu_width';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Submenu Width', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Submenu Top Padding
		$setting_id = 'layout_header_submenu_top_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Submenu Top Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Submenu Bottom Padding
		$setting_id = 'layout_header_submenu_bottom_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Submenu Bottom Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);
		// Submenu Left Padding
		$setting_id = 'layout_header_submenu_left_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Submenu Left Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Submenu Right Padding
		$setting_id = 'layout_header_submenu_right_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Submenu Right Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);


		// Menu left Left spacing
		$setting_id = 'layout_header_menu_left_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Menu item Left Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Menu left right spacing
		$setting_id = 'layout_header_menu_right_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Menu item Right Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Mega Menu bottom spacing
		$setting_id = 'layout_header_mega_menu_bottom_spacing';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Mega Menu item Spacing', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Show Search Icon
		$setting_id = 'layout_header_search';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Search Icon', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Show Mini Cart
		$setting_id = 'layout_header_show_mini_cart';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Mincart at Menu', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Show mobile backdrop background
		$setting_id = 'layout_header_mobile_backdrop_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show mobile backdrop background', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Show Header bottom border
		$setting_id = 'layout_header_bottom_border';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show header bottom border', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		/*
		----------------------------------------------------------------------
		 * Header button Settings
		 *----------------------------------------------------------------------*/
		$setting_id = 'layout_header_button_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Header Button Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change header button related settings', 'ayyash' ),
				)
			)
		);

		// Enable Header Button
		$setting_id = 'layout_header_button';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Header Button', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Header button text
		$setting_id = 'layout_header_button_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header Button Text', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// Header button url
		$setting_id = 'layout_header_button_url';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header Button link', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// Header button Top Padding
		$setting_id = 'layout_header_button_top_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header button Top Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Header button Bottom Padding
		$setting_id = 'layout_header_button_bottom_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header button Bottom Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Header button Left Padding
		$setting_id = 'layout_header_button_left_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header button Left Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Header button Right Padding
		$setting_id = 'layout_header_button_right_padding';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header button Right Padding', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);


		// Header button border radius
		$setting_id = 'layout_header_button_border_radius';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header button border radius', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Header button url
		$setting_id = 'layout_header_button_line_height';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Header Button Line Height (px)', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);


		/*
		----------------------------------------------------------------------
		 * Sticky Settings
		 *----------------------------------------------------------------------*/

		// Sticky Section Separator

		$setting_id = 'layout_header_header_sticky_section_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Sticky Header Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change sticky header related settings', 'ayyash' ),
				)
			)
		);


		// Enable Sticky Header
		$setting_id = 'layout_header_sticky';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Sticky Header', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Sticky Header Height
		$setting_id = 'layout_header_sticky_height';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sticky Header Height', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);


		/*
		----------------------------------------------------------------------
		 *Transparent background Settings
		 *----------------------------------------------------------------------*/

		// Transparent background Section Separator

		$setting_id = 'layout_header_transparent_bg_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Transparent Header Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change transparent header related settings', 'ayyash' ),
				)
			)
		);

		// Main Header transparency
		$setting_id = 'layout_header_transparency_positioning';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Transparent Header', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Main Header transparency disable on posts
		$setting_id = 'layout_header_transparency_front_page';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Disable on Front Page ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Main Header transparency disable on posts
		$setting_id = 'layout_header_transparency_disable_posts';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Disable on Posts ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Main Header transparency disable on pages
		$setting_id = 'layout_header_transparency_disable_pages';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Disable on Pages ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Main Header transparency disable on archives
		$setting_id = 'layout_header_transparency_disable_archives';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Disable on Archives ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Main Header transparency disable on Search page
		$setting_id = 'layout_header_transparency_disable_search';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Disable on Search Page?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Main Header transparency disable on Search page
		$setting_id = 'layout_header_transparency_disable_404';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Disable on 404 Page?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Main Header transparency disable on woocommerce page
		$setting_id = 'layout_header_transparency_disable_products';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Disable on Products & product related Pages?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Exclude pages for transparent header
		$setting_id = 'layout_header_transparency_exclude_pages';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Textarea_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Enable Transparent Header in specific pages', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
					'description' => __( 'Enter page id or slug you want to enable transparent header in specific pages ( For multiple pages use comma to separate )', 'ayyash' ),
				)
			)
		);

		// Header button Top Bottom Padding
		$setting_id = 'layout_transparent_header_top_margin';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Transparent Header Top Margin', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		/*
		----------------------------------------------------------------------
		 * End of header Settings
		 *----------------------------------------------------------------------*/
	}

	protected static function title_layout( $wp_customize ) {
		/******************
		 * // Title Bar Section
		 */

		$section_id = 'title_bar';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Breadcrumb', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		/*
		----------------------------------------------------------------------
		 * Title Bar Settings
		 *----------------------------------------------------------------------*/

		$setting_id = 'title_bar_h2';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Breadcrumb Section', 'ayyash' ),
				)
			)
		);

		$setting_id = 'title_bar_title_container';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Background Image', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// Show Secondary Header
		$setting_id = 'layout_enable_title_breadcrumb';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show title on breadcrumb', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);
	}

	protected static function layout_blog_home( $wp_customize ) {

		$section_id = 'layout_blog_home';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Blog Home', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'layout_blog_home_cat_menu_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Category Menu & Date Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change Category Menu & Date Settings', 'ayyash' ),
				)
			)
		);

		// Show Category menu
		$setting_id = 'layout_blog_home_category';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Category Menu', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Category Multi Select
		$args = array(
			'hide_empty' => false,
		);

		$categories = get_categories( $args );

		$category_list = [];
		foreach ( $categories as $category ) {
			$category_list[ $category->slug ] = $category->name;
		}

		$setting_id = 'layout_blog_home_categories_menu_control';

		$values = ayyash_get_default( $setting_id );

		if ( ! is_array( $values ) ) {
			$values = empty( $values ) ? [] : [ $values ];
		}

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => $values,
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_array_of_strings',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Multi_Select_Control(
				$wp_customize,
				$setting_id,
				[
					'label'    => __( 'Select Category Menu Items', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => $category_list,
				]
			)
		);

		// Show Date
		$setting_id = 'layout_blog_home_date';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Date', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Date Formats
		$setting_id = 'layout_blog_home_date_format';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Date Formats', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices($setting_id),
				)
			)
		);

		// Sticky Post Separator
		$setting_id = 'layout_blog_home_sticky_post_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Sticky Posts Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change Sticky Post Related Settings', 'ayyash' ),
				)
			)
		);

		// Show Sticky Post
		$setting_id = 'layout_blog_home_sticky_post';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Sticky Post', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Sticky Posts per page
		$setting_id = 'layout_blog_home_sticky_posts_per_page';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sticky Posts Per Page', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices($setting_id),
				)
			)
		);

		$setting_id = 'layout_home_enable_sticky_post_slider';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Sticky Post Slider', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_home_sticky_post_slider_enable_arrow';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Sticky Post Slider Arrow', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_home_sticky_post_slider_enable_dots';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Sticky Post Slider Dots', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_home_sticky_post_slider_enable_autoplay';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Sticky Post Slider Autoplay', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);


		// Post tab Separator
		$setting_id = 'layout_blog_home_post_tab_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Blog Posts Tab Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change Posts Tab Related Settings', 'ayyash' ),
				)
			)
		);

		// Show Post Tab
		$setting_id = 'layout_blog_home_post_tab';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Post Tab', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Posts tab per page
		$setting_id = 'layout_blog_home_post_tab_posts_per_page';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Post tab Posts Per Page', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices($setting_id),
				)
			)
		);

		$setting_id = 'layout_blog_home_latest_posts_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Latest Posts Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Change Latest Posts Related Settings', 'ayyash' ),
				)
			)
		);
		// latest Posts title
		$setting_id = 'layout_blog_home_latest_posts_title';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Latest Posts Title', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// latest post Column
		$setting_id = 'layout_blog_home_latest_posts_column';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Latest Posts Column', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices($setting_id),
				)
			)
		);

		// latest post thumbnail position
		$setting_id = 'layout_blog_home_latest_posts_thumbnail_position';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Latest Posts thumbnail Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices($setting_id),
				)
			)
		);

		// latest post Show View All button
		$setting_id = 'layout_blog_home_latest_posts_view_btn';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Latest Posts View All Button', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// latest post Excerpt length
		$setting_id = 'layout_blog_home_latest_posts_excerpt_length';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Latest Posts Excerpts Length', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices($setting_id),
				)
			)
		);

		// latest post posts per page
		$setting_id = 'layout_blog_home_latest_posts_per_page';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default($setting_id),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Latest Posts Per Page', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices($setting_id),
				)
			)
		);

		// Category Multi Select
		$setting_id = 'layout_blog_home_category_multiselect_separator';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'type'              => 'helptext',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Category Multi Select Settings', 'ayyash' ),
					'section'     => $section_id,
					'type'        => 'helptext',
					'description' => __( 'Select Category Multi Select you want show for your blog homepage', 'ayyash' ),
				)
			)
		);

		// Category Multi Select
		$args = array(
			'hide_empty' => false,
		);

		$categories = get_categories( $args );

		$category_list = [];
		foreach ( $categories as $category ) {
			$category_list[ $category->slug ] = $category->name;
		}

		$setting_id = 'layout_blog_home_categories_control';

		$values = ayyash_get_default( $setting_id );

		if ( ! is_array( $values ) ) {
			$values = empty( $values ) ? [] : [ $values ];
		}

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => $values,
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_array_of_strings',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Multi_Select_Control(
				$wp_customize,
				$setting_id,
				[
					'label'    => __( 'Categories Multi Select', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => $category_list,
				]
			)
		);

		// Categories Select
		$selected_categories = ayyash_get_mod('layout_blog_home_categories_control');
		if ( ! empty( $selected_categories ) ) {
			foreach ( $selected_categories as $category ) {
				$term_details = get_term_by('slug', $category, 'category');

				// Category Separator
				$setting_id  = 'layout_blog_home_' . $category . '_separator';
				$label       = 'Category ' . $term_details->name . ' Settings';
				$description = 'Change ' . $term_details->name . ' Related Settings';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'type'              => 'helptext',
						'sanitize_callback' => 'sanitize_text_field',
					)
				);

				$wp_customize->add_control(
					new Ayyash_Customize_Misc_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'       => $label,
							'section'     => $section_id,
							'type'        => 'helptext',
							'description' => $description,
						)
					)
				);

				// category title
				$setting_id = 'layout_blog_home_' . $category . '_title';
				$label      = ucfirst($term_details->name) . ' Section Title';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'default'           => ayyash_get_default($setting_id),
						'type'              => 'theme_mod',
						'sanitize_callback' => 'sanitize_text_field',
					)
				);

				$wp_customize->add_control(
					new WP_Customize_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'    => $label,
							'section'  => $section_id,
							'settings' => $setting_id,
						)
					)
				);

				// category Column
				$setting_id = 'layout_blog_home_' . $category . '_column';
				$label      = ucfirst($term_details->name) . ' Post Column';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'default'           => ayyash_get_default($setting_id),
						'type'              => 'theme_mod',
						'sanitize_callback' => 'ayyash_sanitize_choice',
					)
				);

				$wp_customize->add_control(
					new WP_Customize_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'    => $label,
							'section'  => $section_id,
							'settings' => $setting_id,
							'type'     => 'select',
							'choices'  => ayyash_get_choices($setting_id),
						)
					)
				);

				// category post thumbnail position
				$setting_id = 'layout_blog_home_' . $category . '_thumbnail_position';
				$label      = ucfirst($term_details->name) . ' Thumbnail Position';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'default'           => ayyash_get_default($setting_id),
						'type'              => 'theme_mod',
						'sanitize_callback' => 'ayyash_sanitize_choice',
					)
				);

				$wp_customize->add_control(
					new WP_Customize_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'    => $label,
							'section'  => $section_id,
							'settings' => $setting_id,
							'type'     => 'select',
							'choices'  => ayyash_get_choices($setting_id),
						)
					)
				);

				// Show View All button
				$setting_id = 'layout_blog_home_' . $category . '_view_btn';
				$label      = 'Show ' . ucfirst($term_details->name) . ' Post View All Button';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'default'           => ayyash_get_default($setting_id),
						'type'              => 'theme_mod',
						'sanitize_callback' => 'absint',
					)
				);

				$wp_customize->add_control(
					new WP_Customize_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'    => $label,
							'section'  => $section_id,
							'settings' => $setting_id,
							'type'     => 'checkbox',
						)
					)
				);

				// Category Excerpt length
				$setting_id = 'layout_blog_home_' . $category . '_excerpt_length';
				$label      = ucfirst($term_details->name) . ' Posts Excerpts Length';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'default'           => ayyash_get_default($setting_id),
						'type'              => 'theme_mod',
						'sanitize_callback' => 'absint',
					)
				);

				$wp_customize->add_control(
					new Ayyash_Customizer_Range_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'    => $label,
							'section'  => $section_id,
							'settings' => $setting_id,
							'choices'  => ayyash_get_choices($setting_id),
						)
					)
				);

				// Category Excerpt length
				$setting_id = 'layout_blog_home_' . $category . '_post_per_page';
				$label      = ucfirst($term_details->name) . ' Posts Per Page';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'default'           => ayyash_get_default($setting_id),
						'type'              => 'theme_mod',
						'sanitize_callback' => 'absint',
					)
				);

				$wp_customize->add_control(
					new Ayyash_Customizer_Range_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'    => $label,
							'section'  => $section_id,
							'settings' => $setting_id,
							'choices'  => ayyash_get_choices($setting_id),
						)
					)
				);

				// category post selected sidebar
				$setting_id = 'layout_blog_home_' . $category . '_sidebar';
				$label      = 'Select ' . ucfirst($term_details->name) . ' Category Sidebar';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'default'           => ayyash_get_default($setting_id),
						'type'              => 'theme_mod',
						'sanitize_callback' => 'ayyash_sanitize_choice',
					)
				);

				$wp_customize->add_control(
					new WP_Customize_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'    => $label,
							'section'  => $section_id,
							'settings' => $setting_id,
							'type'     => 'select',
							'choices'  => ayyash_get_choices($setting_id),
						)
					)
				);

				// Category Sidebar Position
				$setting_id = 'layout_blog_home_' . $category . '_sidebar_position';
				$label      = 'Select ' . ucfirst($term_details->name) . ' Category Sidebar Position';

				$wp_customize->add_setting(
					$setting_id,
					array(
						'default'           => ayyash_get_default( $setting_id ),
						'type'              => 'theme_mod',
						'sanitize_callback' => 'ayyash_sanitize_choice',
					)
				);

				$wp_customize->add_control(
					new WP_Customize_Control(
						$wp_customize,
						$setting_id,
						array(
							'label'    => $label,
							'section'  => $section_id,
							'settings' => $setting_id,
							'type'     => 'select',
							'choices'  => ayyash_get_choices( $setting_id ),
						)
					)
				);
			}
		}
	}

	protected static function layout_blog( $wp_customize ) {
		/******************************************
		 * // Blog (Posts Page) Section
		 */

		$section_id = 'layout_blog';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Blog (Posts Page)', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'layout_blog_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_blog_style';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Style', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_blog_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_blog_excerpt_length';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Excerpt Length', 'ayyash' ),
					'description' => __( 'Number or word you want to show on archive content', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'layout_blog_meta';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Post Meta', 'ayyash' ),
				)
			)
		);

		$setting_id = 'layout_blog_meta-tags';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Tags', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_blog_meta-cats';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Categories', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		if ( ayyash_is_plugin_active( 'regenerate-thumbnails' ) ) {
			$desc = sprintf(
			/* translators: %s: Regenerate Thumbnail Plugin Page Link */
				__( 'After changing any of the post thumbnail sizes please use <a href="%s" target="_blank"><b>Regenerate Thumbnail</b></a> plugin to resize (regenerate) thumbnails.', 'ayyash' ),
				esc_url( admin_url( 'tools.php?page=regenerate-thumbnails' ) )
			);
		} else {
			$desc = sprintf(
			/* translators: %s: Regenerate Thumbnail Plugin Installation Link */
				__( 'After changing any of the post thumbnail sizes please install and use <a href="%s" target="_blank"><b>Regenerate Thumbnail</b></a> plugin to resize (regenerate) thumbnails.', 'ayyash' ),
				admin_url( 'themes.php?page=tgmpa-install-plugins&plugin_status=install' )
			);
		}

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section'     => $section_id,
					'type'        => 'helptext',
					'label'       => __( 'Post Thumbnail Sizes', 'ayyash' ),
					'description' => $desc,
				)
			)
		);

		$setting_id = 'layout_blog_normal_image';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Blog Normal Image Size', 'ayyash' ),
					'description' => __( 'Single Blog / Blog Normal Layout Image Size ( width,height )', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'layout_blog_medium_image';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Blog Medium Image Size', 'ayyash' ),
					'description' => __( 'Blog Medium Layout Image Size ( width,height ).', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'layout_blog_grid_image';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Blog Grid Image Size', 'ayyash' ),
					'description' => __( 'Blog Grid layout Image Size ( width,height )', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);
	}

	protected static function layout_archive( $wp_customize ) {
		/******************************************
		 * // Archives Section
		 */

		$section_id = 'layout_archive';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Archives', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'layout_archive_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_archive_style';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Style', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_archive_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_archive_meta';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Post Meta', 'ayyash' ),
				)
			)
		);

		$setting_id = 'layout_archive_meta-tags';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Tags', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);
	}

	protected static function layout_search( $wp_customize ) {
		/******************************************
		 * // Search Results Section
		 */

		$section_id = 'layout_search';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Search Results', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'layout_search_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_search_style';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Style', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_search_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_search_meta';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Post Meta', 'ayyash' ),
				)
			)
		);

		$setting_id = 'layout_search_meta-cats';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Categories', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_search_meta-tags';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Tags', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);
	}

	protected static function layout_post( $wp_customize ) {
		/******************************************
		 * // Single Post
		 */

		$section_id = 'layout_post';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Single Post', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'layout_post_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_post_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_post_ft-img-hide';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Hide Featured Image', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_post_ft-img-enlarge';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Enlarge Featured Image', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
					'type'        => 'checkbox',
					'description' => __( 'Enalrge the featured image width to the 100% width of the view port/window', 'ayyash' ),
				)
			)
		);

		$setting_id = 'layout_post_content_align';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Content Alignment', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_post_title';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Post Title ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_related_post';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Related Posts', 'ayyash' ),
				)
			)
		);

		$setting_id = 'layout_show_related_post';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Related Posts', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Related Post Number
		$setting_id = 'layout_related_post_number';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Post Number', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		//  show related post column
		$setting_id = 'layout_related_post_column';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Post Column', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_enable_related_post_thumbnail';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Post thumbnail', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_enable_related_post_preview_thumbnail';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Post Preview thumbnail', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_enable_related_post_slider';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Slider', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_related_post_slider_enable_arrow';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Slider Arrow', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_related_post_slider_enable_dots';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Slider Dots', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_related_post_slider_enable_autoplay';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable Slider Autoplay', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);


		$setting_id = 'layout_post_meta';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Post Meta', 'ayyash' ),
				)
			)
		);

		$setting_id = 'layout_post_meta-cats';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Categories', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_post_meta-tags';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Tags', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);
	}

	protected static function layout_page( $wp_customize ) {
		/******************************************
		 * // Single Page
		 */

		$section_id = 'layout_page';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Single Page', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'layout_page_sidebar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Sidebar Position', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_page_title-bar';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Breadcrumb ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_page_ft-img-hide';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Hide Featured Image', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		$setting_id = 'layout_page_ft-img-enlarge';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Enlarge Featured Image', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
					'type'        => 'checkbox',
					'description' => __( 'Enalrge the featured image width to the 100% width of the view port/window', 'ayyash' ),
				)
			)
		);

		$setting_id = 'layout_page_content_align';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Content Alignment', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = 'layout_page_title';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Page Title ?', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		/*
		----------------------------------------------------------------------
		 * End Of Single Page
		 *----------------------------------------------------------------------*/
	}

	protected static function layout_footer( $wp_customize ) {
		/******************
		 * // Footer Section
		 */

		$section_id = 'layout_footer';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Footer', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'layout_footer_settings';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Footer Settings', 'ayyash' ),
				)
			)
		);

		// Footer Column

		$setting_id = 'layout_footer_widget_column';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Widget Column', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Copyright top margin
		$setting_id = 'layout_footer_credits_top_margin';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Credits top margin', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// Copyright bottom margin
		$setting_id = 'layout_footer_credits_bottom_margin';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Credits bottom margin', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		// footer social icon
		$setting_id = 'layout_footer_social';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Show Social Icons', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// footer scroll to top
		$setting_id = 'layout_footer_scroll_to_top';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Enable scroll to top', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'checkbox',
				)
			)
		);

		// Footer copyright Text.
		$setting_id = 'layout_footer_footer_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			new Ayyash_Textarea_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Footer Copyright Text', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);


	}

}
