<?php
/**
 * @package Ayyash
 * @author  ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

class Ayyash_Customize_Dokan {
	/**
	 * Register panel and add settings.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer Instance.
	 *
	 * @return void
	 */
	public static function register( $wp_customize ) {
		$panel_id = 'dokan';

		$wp_customize->add_panel(
			$panel_id,
			array(
				'priority'       => 200,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => 'Dokan',
			)
		);

		// Dokan General.
		$section_id = 'dokan_template';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'General', 'ayyash' ),
				'priority'   => 9,
				'capability' => 'edit_theme_options',
				'panel'      => $panel_id,
			)
		);

		$setting_id = $section_id . '_style';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Select Template', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);

		$setting_id = $section_id . '_store_per_page';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control(
			new Ayyash_Customizer_Range_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Store Per Page', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);
		$setting_id = $section_id . '_store_columns';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'ayyash_sanitize_choice',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Store Column Per Row', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
					'type'     => 'select',
					'choices'  => ayyash_get_choices( $setting_id ),
				)
			)
		);
	}
}
