<?php
/**
 * Contains methods for adding Colors Customization Panel and all settings under it
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/**
 * @class Ayyash_Customize_Colors
 */
class Ayyash_Customize_Colors {

	const PANEL_ID = 'colors';

	/**
	 * Register panel and add settings.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer Instance.
	 *
	 * @return void
	 */
	public static function register( $wp_customize ) {

		$wp_customize->remove_section( 'colors' );

		$wp_customize->add_panel(
			self::PANEL_ID,
			array(
				'priority'       => 10,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Colors', 'ayyash' ),
				'description'    => '',
			)
		);

		self::register_colors_global( $wp_customize );
		self::register_colors_header( $wp_customize );
		self::register_colors_header_button( $wp_customize );
		self::register_colors_header_second( $wp_customize );
		self::register_colors_menu( $wp_customize );
		self::register_colors_mega_menu( $wp_customize );
		self::register_colors_title( $wp_customize );
		// @TODO Fix css support, then re-enable footer top color settings.
		//self::register_colors_footer_top( $wp_customize ); // phpcs:ignore Squiz.PHP.CommentedOutCode.Found
		self::register_colors( $wp_customize );

	}

	/**
	 * Global Section.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @return void
	 */
	protected static function register_colors_global( $wp_customize ) {
		$section_id = 'colors_global';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Global', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'colors_global_accent';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Primary Color', 'ayyash' ),
					'description' => __( 'Used for Links & Buttons', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_accent_shade';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Secondary Color', 'ayyash' ),
					'description' => __( 'Used for Links & Buttons hover state', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_alt';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Form Elements Background Color', 'ayyash' ),
					'description' => __( 'Used for Form Elements', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_alt_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Form Elements Text Color', 'ayyash' ),
					'description' => __( 'Used for Form Elements', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_border';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Border Color', 'ayyash' ),
					'description' => __( 'Used for Borders for all content elements', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_heading';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Heading Color', 'ayyash' ),
					'description' => __( 'Used for headings - h1 to h6', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Text Color', 'ayyash' ),
					'description' => __( 'Used for content text', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_site_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Site Background Color', 'ayyash' ),
					'description' => __( 'Used for background color of the site, It will apply if site layout Boxed selected.', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_content_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Content Background Color', 'ayyash' ),
					'description' => __( 'Used for background color of the site content', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_sticky_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Sticky Post Background Color', 'ayyash' ),
					'description' => __( 'Used for background color of the sticky post archive layout', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_global_gradient';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Gradient Stop Color', 'ayyash' ),
					'description' => __( 'Used for gradient stop color that extends primary or secondary color', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);
	}

	/**
	 * Header Section.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @return void
	 */
	protected static function register_colors_header( $wp_customize ) {
		$section_id = 'colors_header';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Header', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'colors_header_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'        => __( 'Background Color', 'ayyash' ),
					'description'  => __( 'Header background color', 'ayyash' ),
					'section'      => $section_id,
					'settings'     => $setting_id,
					'show_opacity' => true, // Optional.
				)
			)
		);
	}

	/**
	 * Header Section Second.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @return void
	 */
	protected static function register_colors_header_button( $wp_customize ) {
		/****************
		 * Header Button Section
		 */
		$section_id = 'colors_header';

		$setting_id = 'colors_header_button';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Header Button', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_header_button_bgcolor';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Background Color', 'ayyash' ),
					'description' => __( 'Header Button Background Color', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_header_button_bgcolor_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Background Hover Color', 'ayyash' ),
					'description' => __( 'Header Button Background Hover Color', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_header_button_color';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Color', 'ayyash' ),
					'description' => __( 'Header Button Color', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_header_button_hover_color';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Hover Color', 'ayyash' ),
					'description' => __( 'Header Button Hover Color', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);

		$setting_id = 'colors_header_button_border_color';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Border Color', 'ayyash' ),
					'description' => __( 'Header Button Border Color', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);
		$setting_id = 'colors_header_button_border_hover_color';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'       => __( 'Border Hover Color', 'ayyash' ),
					'description' => __( 'Header Button Border Hover Color', 'ayyash' ),
					'section'     => $section_id,
					'settings'    => $setting_id,
				)
			)
		);
	}

	/**
	 * Header Section Second.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @return void
	 */
	protected static function register_colors_header_second( $wp_customize ) {
		/****************
		 * Secondary Header Section
		 */
		$section_id = 'colors_header';

		$setting_id = 'colors_header_second';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Secondary Header', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_header2_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_header2_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_header2_sc_si';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Social Icon Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_header2_sc_si_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Social Icon Hover Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_header2_sc_si_hover_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Social Icon Hover background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);
	}

	/**
	 * Main Menu Section.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @return void
	 */
	protected static function register_colors_menu( $wp_customize ) {
		/**
		 * Main Menu Section
		 */
		$section_id = 'colors_menu';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Main Menu', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'colors_menu_menu_h';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Menu Items', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_menu_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Hover/Focus Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_menu_sub_h';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Sub Menu Items', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_menu_sub_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_sub_border';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Border Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_sub_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_sub_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Hover/Focus Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_sub_hover_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Hover/Focus Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		/**
		 * Mobile Menu Colors
		 */

		$setting_id = 'colors_menu_mob_sub_h';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Mobile Menu', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_menu_mob_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Menu Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_color';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Menu Item Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_mob_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Hover/Focus Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_mob_hover_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Hover/Focus Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_menu_mob_border';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Menu Item Border Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);
	}

	/**
	 * Mega Menu Section.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @return void
	 */
	protected static function register_colors_mega_menu( $wp_customize ) {
		/**
		 * Mega Menu Section
		 */
		$section_id = 'colors_mega_menu';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Mega Menu', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'colors_mega_menu_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_mega_title_menu_h';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Menu Title', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_mega_menu_title';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_mega_menu_title_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Hover/Focus Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_mega_menu_item_h';

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				$setting_id,
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Mega Menu Items', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_mega_menu_item';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_mega_menu_item_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Hover/Focus Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

	}

	/**
	 * Breadcrumb Section Section.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @return void
	 */
	protected static function register_colors_title( $wp_customize ) {
		$section_id = 'colors_title';

		$wp_customize->add_section(
			$section_id,
			array(
				'title'      => __( 'Breadcrumb Section', 'ayyash' ),
				'priority'   => 35,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			)
		);

		$setting_id = 'colors_title_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_title_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);
	}


	/**
	 * Footer Section.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 * @return void
	 */
	protected static function register_colors( $wp_customize ) {
		$footers = [
			'main' => __( 'Main', 'ayyash' ),
		];

		$priority = 35;

		foreach ( $footers as $slug => $label ) {

			$section_id    = 'colors_footer_' . $slug;
			$section_title = sprintf(
			/* translators: %s Footer Position Name. */
				__( '%s Footer', 'ayyash' ),
				$label
			);

			$wp_customize->add_section(
				$section_id,
				[
					'title'      => $section_title,
					'priority'   => $priority,
					'capability' => 'edit_theme_options',
					'panel'      => self::PANEL_ID,
				]
			);

			$priority += 10;

			$setting_id = 'colors_footer_' . $slug . '_heading';

			// Section Heading
			$wp_customize->add_control(
				new Ayyash_Customize_Misc_Control(
					$wp_customize,
					$setting_id,
					array(
						'section' => $section_id,
						'type'    => 'heading',
						'label'   => $section_title,
					)
				)
			);

			$setting_id = 'colors_footer_' . $slug . '_bg';

			$wp_customize->add_setting(
				$setting_id,
				array(
					'default'           => ayyash_get_default( $setting_id ),
					'type'              => 'theme_mod',
					'sanitize_callback' => 'maybe_hash_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					$setting_id,
					array(
						'label'    => __( 'Background Color', 'ayyash' ),
						'section'  => $section_id,
						'settings' => $setting_id,
					)
				)
			);

			$setting_id = 'colors_footer_' . $slug . '_heading';

			$wp_customize->add_setting(
				$setting_id,
				array(
					'default'           => ayyash_get_default( $setting_id ),
					'type'              => 'theme_mod',
					'sanitize_callback' => 'maybe_hash_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					$setting_id,
					array(
						'label'    => __( 'Heading Color', 'ayyash' ),
						'section'  => $section_id,
						'settings' => $setting_id,
					)
				)
			);

			$setting_id = 'colors_footer_' . $slug . '_text';

			$wp_customize->add_setting(
				$setting_id,
				array(
					'default'           => ayyash_get_default( $setting_id ),
					'type'              => 'theme_mod',
					'sanitize_callback' => 'maybe_hash_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					$setting_id,
					array(
						'label'    => __( 'Text Color', 'ayyash' ),
						'section'  => $section_id,
						'settings' => $setting_id,
					)
				)
			);

			$setting_id = 'colors_footer_' . $slug . '_link';

			$wp_customize->add_setting(
				$setting_id,
				array(
					'default'           => ayyash_get_default( $setting_id ),
					'type'              => 'theme_mod',
					'sanitize_callback' => 'maybe_hash_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					$setting_id,
					array(
						'label'    => __( 'Link Color', 'ayyash' ),
						'section'  => $section_id,
						'settings' => $setting_id,
					)
				)
			);

			$setting_id = 'colors_footer_' . $slug . '_link_hover';

			$wp_customize->add_setting(
				$setting_id,
				array(
					'default'           => ayyash_get_default( $setting_id ),
					'type'              => 'theme_mod',
					'sanitize_callback' => 'maybe_hash_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					$setting_id,
					array(
						'label'    => __( 'Link Hover Color', 'ayyash' ),
						'section'  => $section_id,
						'settings' => $setting_id,
					)
				)
			);
		}

		$section_id = 'colors_footer_second';

		$wp_customize->add_section(
			$section_id,
			[
				'title'      => __( 'Secondary Footer', 'ayyash' ),
				'priority'   => $priority,
				'capability' => 'edit_theme_options',
				'panel'      => self::PANEL_ID,
			]
		);

		//Footer Secondary Settings

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				'colors_footer_sc_heading',
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Secondary Footer Colors', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_footer_sc_set_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Secondary Footer Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// Footer Social Icons

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				'colors_footer_sc_si_heading',
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Social Icon Colors', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_footer_sc_si_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Social Icon Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_footer_sc_si';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Social Icon Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_footer_sc_si_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Social Icon Hover Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_footer_sc_si_hover_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Social Icon Hover background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		// copyright & credit.

		$wp_customize->add_control(
			new Ayyash_Customize_Misc_Control(
				$wp_customize,
				'colors_footer_sc_heading',
				array(
					'section' => $section_id,
					'type'    => 'heading',
					'label'   => __( 'Credit & Copyright Colors', 'ayyash' ),
				)
			)
		);

		$setting_id = 'colors_footer_sc_bg';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Background Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_footer_sc_text';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Text Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_footer_sc_link';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Link Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);

		$setting_id = 'colors_footer_sc_link_hover';

		$wp_customize->add_setting(
			$setting_id,
			array(
				'default'           => ayyash_get_default( $setting_id ),
				'type'              => 'theme_mod',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				$setting_id,
				array(
					'label'    => __( 'Link Hover Color', 'ayyash' ),
					'section'  => $section_id,
					'settings' => $setting_id,
				)
			)
		);
	}
}
