<?php
/**
 * Google Fonts Helper.
 *
 * @package Ayyash
 * @author ThemeRox
 * @version 1.0.2
 * @since Ayyash 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

if ( ! function_exists( 'ayyash_get_all_fonts' ) ) :
	/**
	 * Returns an Array of all the Available Font Options
	 *
	 * @param bool $show_header
	 * @return array
	 */
	function ayyash_get_all_fonts( $show_header = true ) {

		if ( $show_header ) {
			return array_merge(
				[
					'------- Standard Fonts -------' => [
						'disabled' => true,
						'variants' => [],
					],
				],
				ayyash_get_standard_fonts(),
				[
					'------- Google Fonts -------' => [
						'disabled' => true,
						'variants' => [],
					],
				],
				ayyash_get_google_fonts()
			);
		}

		return array_merge(
			ayyash_get_standard_fonts(),
			ayyash_get_google_fonts()
		);
	}
endif;

if ( ! function_exists( 'ayyash_get_standard_fonts' ) ) :
	/**
	 * Returns an Array of all the Available Standard Fonts
	 *
	 * @return array
	 */
	function ayyash_get_standard_fonts() {
		return apply_filters( 'ayyash_get_standard_fonts', [
			__( 'Default', 'ayyash' ) => [
				'variants' => [
					'100',
					'200',
					'300',
					'regular',
					'500',
					'600',
					'700',
					'800',
					'900',
				],
			],
			'Serif'                   => [ 'variants' => [ 'regular' ] ],
			'Sans Serif'              => [ 'variants' => [ 'regular' ] ],
			'Monospaced'              => [ 'variants' => [ 'regular' ] ],
		] );
	}
endif;

if ( ! function_exists( 'ayyash_get_google_fonts' ) ) :
	/**
	 * Returns an Array of all the Available Google Fonts
	 *
	 * @return array
	 */
	function ayyash_get_google_fonts() {
		static $fonts;
		if ( null === $fonts ) {
			/** @define "AYYASH_THEME_DIR" "./../../" */
			$fonts = file_get_contents( AYYASH_THEME_DIR . 'assets/fonts.json' );
			if ( $fonts ) {
				$fonts = json_decode( $fonts, true );
			}
		}
		return $fonts ? $fonts : [];
	}
endif;
