<?php
/**
 * Customizer Defaults.
 *
 * @package Ayyash
 * @author  Ayyash
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound,WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound

// Get Sidebar.
$sidebar_list         = [ 'default' => __( 'Default', 'ayyash' ) ];
$ayyash_get_sidebars  = wp_get_sidebars_widgets();
$ayyash_get_sidebars  = array_slice( $ayyash_get_sidebars, 1 );
$ayyash_grid_list     = [
	1  => __( 'Grid Column 1', 'ayyash' ),
	2  => __( 'Grid Column 2', 'ayyash' ),
	3  => __( 'Grid Column 3', 'ayyash' ),
	4  => __( 'Grid Column 4', 'ayyash' ),
	5  => __( 'Grid Column 5', 'ayyash' ),
	6  => __( 'Grid Column 6', 'ayyash' ),
	7  => __( 'Grid Column 7', 'ayyash' ),
	8  => __( 'Grid Column 8', 'ayyash' ),
	9  => __( 'Grid Column 9', 'ayyash' ),
	10 => __( 'Grid Column 10', 'ayyash' ),
	11 => __( 'Grid Column 11', 'ayyash' ),
	12 => __( 'Grid Column 12', 'ayyash' ),
];
$ayyash_sidebar_pos   = [
	'left'  => __( 'Left', 'ayyash' ),
	'right' => __( 'Right', 'ayyash' ),
	'none'  => __( 'None', 'ayyash' ),
];
$ayyash_yes_no        = [
	1 => __( 'Yes', 'ayyash' ),
	0 => __( 'No', 'ayyash' ),
];
$ayyash_blog_style    = [
	'normal' => __( 'Normal', 'ayyash' ),
	'medium' => __( 'Medium', 'ayyash' ),
	'grid'   => __( 'Grid', 'ayyash' ),
];
$ayyash_content_align = [
	'left'   => __( 'Left', 'ayyash' ),
	'center' => __( 'Center', 'ayyash' ),
	'right'  => __( 'Right', 'ayyash' ),
];

foreach ( $ayyash_get_sidebars as $key => $sidebar ) {
	$str   = str_replace( '-', ' ', $key );
	$value = ucwords( $str );
	// Add to the list.
	$sidebar_list[ $key ] = $value;
}

// date formats
$date_formats = [ 'l j, Y', 'F j, Y', 'jS F, Y', 'jS M, Y', 'jS, F, Y', 'Y-m-d', 'd/m/Y', 'd/m/y', 'd.m.Y' ];
$dates_arr    = [];
foreach ( $date_formats as $date_format ) {
	$dates_arr[ $date_format ] = wp_date( $date_format );
}

$social_profiles = [
	[
		'label' => 'Facebook',
		'url'   => 'https://www.facebook.com/pixelaarllc/',
		'icon'  => 'ai ai-facebook',
	],
	[
		'label' => 'Instagram',
		'url'   => '#',
		'icon'  => 'ai ai-instagram',
	],

	[
		'label' => 'Twitter',
		'url'   => '#',
		'icon'  => 'ai ai-twitter',
	],
	[
		'label' => 'Linkedin',
		'url'   => 'https://bd.linkedin.com/company/pixelaar-fzc-llc?trk=ppro_cprof',
		'icon'  => 'ai ai-linkedin',
	],
	[
		'label' => 'Pinterest',
		'url'   => '#',
		'icon'  => 'ai ai-pinterest',
	],
	[
		'label' => 'Dribbble',
		'url'   => 'https://dribbble.com/pixelaarllc',
		'icon'  => 'ai ai-dribbble',
	],
];

// Default Options.
$ayyash_defaults = [
	'blogname'                                          => __( 'Ayyash Demo', 'ayyash' ),
	'title_tagline_hide_title'                          => 0,
	'title_tagline_hide_tagline'                        => 1,
	'sticky_label'                                      => __( 'Featured', 'ayyash' ),
	's_config_lazyload_enable'                          => '1',

	'preload_enable'                                    => 0,
	'preload_animation_type'                            => 'pulse',
	'preload_animation_speed'                           => 'slow',
	'preload_text_enable'                               => 1,
	'preload_text'                                      => 'loading',
	'preload_text_size'                                 => 36,
	'preload_img_enable'                                => 0,
	'preload_img_size'                                  => 100,

	'social_profiles'                                   => $social_profiles,
	'layout_global_site'                                => 'wide',
	'layout_global_content_layout'                      => 'container',
	'layout_global_content_layout_max_width'            => '',
	'layout_global_content_grid'                        => 9,
	'layout_global_sidebar_grid'                        => 3,
	'layout_header_secondary'                           => 1,
	'layout_header_secondary_layout'                    => 'callout_icons',
	'layout_header_callout'                             => __( 'Call us Now! 1-555-333-666 | Email us at info@pixelaar.com', 'ayyash' ),
	'layout_header_sticky'                              => 0,
	'layout_header_height'                              => 85,
	'layout_header_sticky_height'                       => 100,
	'layout_header_sticky_menu_top_padding'             => 0,
	'layout_header_search'                              => 0,
	'layout_header_show_mini_cart'                      => 1,
	'layout_header_mobile_backdrop_bg'                  => 1,
	'layout_header_bottom_border'                       => 1,

	'layout_header_button'                              => 0,
	'layout_header_button_text'                         => __( 'Button', 'ayyash' ),
	'layout_header_button_url'                          => '#',
	'layout_header_button_top_padding'                  => 15,
	'layout_header_button_bottom_padding'               => 15,
	'layout_header_button_left_padding'                 => 20,
	'layout_header_button_right_padding'                => 20,
	'layout_header_button_border_radius'                => 5,

	'layout_header_transparency_positioning'            => 0,
	'layout_header_transparency_front_page'             => 0,
	'layout_header_transparency_disable_posts'          => 1,
	'layout_header_transparency_disable_pages'          => 1,
	'layout_header_transparency_disable_archives'       => 1,
	'layout_header_transparency_disable_search'         => 1,
	'layout_header_transparency_disable_404'            => 1,
	'layout_header_transparency_disable_products'       => 1,

	'layout_header_logo_right_space'                    => 25,
	'layout_header_menu_mobileshow'                     => 'md',
	'layout_header_mobile_menu_style'                   => 'off-canvas-left-mobile-menu',
	'layout_header_menu_alignment'                      => 'right',
	'layout_header_menu_style'                          => 'menu-text',
	'layout_header_menu_hover_style'                    => 'menu-hover-primary',
	'layout_header_submenu_alignment'                   => 'left',
	'layout_header_submenu_width'                       => 280,
	'layout_header_submenu_top_padding'                 => 13,
	'layout_header_submenu_bottom_padding'              => 13,
	'layout_header_submenu_left_padding'                => 20,
	'layout_header_submenu_right_padding'               => 20,
	'layout_header_menu_left_padding'                   => 15,
	'layout_header_menu_right_padding'                  => 15,
	'layout_header_mega_menu_bottom_spacing'            => 12,
	'layout_transparent_header_top_margin'              => 0,
	'layout_footer_widget_column'                       => 4,
	'layout_footer_social'                              => 1,
	'layout_footer_credits_top_margin'                  => 30,
	'layout_footer_credits_bottom_margin'               => 30,
	'layout_footer_scroll_to_top'                       => 1,
	'layout_footer_footer_text'                         => '',

	'layout_blog_home_category'                         => 1,
	'layout_blog_home_date'                             => 1,
	'layout_blog_home_date_format'                      => 'l j, Y',
	'layout_blog_home_sticky_post'                      => 1,
	'layout_blog_home_sticky_posts_per_page'            => 3,
	'layout_blog_home_post_tab'                         => 0,
	'layout_blog_home_post_tab_posts_per_page'          => 5,
	'layout_blog_home_latest_posts_title'               => __( 'Latest Posts', 'ayyash' ),
	'layout_blog_home_latest_posts_column'              => 3,
	'layout_blog_home_latest_posts_thumbnail_position'  => 'default',
	'layout_blog_home_latest_posts_per_page'            => 6,
	'layout_blog_home_latest_posts_excerpt_length'      => 10,

	'layout_blog_sidebar'                               => 'right',
	'layout_blog_style'                                 => 'normal',
	'layout_blog_title-bar'                             => 1,
	'layout_blog_meta'                                  => '',
	'layout_blog_meta-cats'                             => 1,
	'layout_blog_meta-tags'                             => 1,
	'layout_blog_excerpt_length'                        => 50,
	'layout_blog_normal_image'                          => '1400,700',
	'layout_blog_medium_image'                          => '277,395',
	'layout_blog_grid_image'                            => '400,320',
	'layout_archive_sidebar'                            => 'right',
	'layout_archive_style'                              => 'normal',
	'layout_archive_title-bar'                          => 1,
	'layout_archive_meta'                               => '',
	//'layout_archive_meta-cats'                          => 1, @TODO tobe removed
	'layout_archive_meta-tags'                          => 1,
	'layout_search_sidebar'                             => 'right',
	'layout_search_style'                               => 'normal',
	'layout_search_title-bar'                           => 1,
	'layout_search_meta'                                => '',
	'layout_search_meta-cats'                           => 1,
	'layout_search_meta-tags'                           => 1,
	'layout_post_sidebar'                               => 'right',
	'layout_post_title-bar'                             => 1,
	'layout_post_title'                                 => 1,
	'layout_post_ft-img-hide'                           => 0,
	'layout_post_ft-img-enlarge'                        => 1,
	'layout_post_content_align'                         => '',
	'layout_show_related_post'                          => 1,
	'layout_related_post_number'                        => 6,
	'layout_related_post_column'                        => 2,
	'layout_enable_related_post_thumbnail'              => 1,
	'layout_enable_related_post_preview_thumbnail'      => 1,
	'layout_enable_related_post_slider'                 => 1,
	'layout_related_post_slider_enable_arrow'           => 1,
	'layout_related_post_slider_enable_dots'            => 1,
	'layout_related_post_slider_enable_autoplay'        => 1,
	'layout_post_meta'                                  => '',
	'layout_post_meta-cats'                             => 1,
	'layout_post_meta-tags'                             => 1,
	'layout_page_sidebar'                               => 'none',
	'layout_page_title-bar'                             => 1,
	'layout_page_title'                                 => 0,
	'layout_page_ft-img-hide'                           => 0,
	'layout_page_ft-img-enlarge'                        => 1,
	'layout_page_content_align'                         => '',

	'colors_global_accent'                              => '', // '#2626f3',
	'colors_global_accent_shade'                        => '', // '#0000f2',
	'colors_global_alt'                                 => '', // '#FFFFFF',
	'colors_global_alt_text'                            => '', // '#333333',
	'colors_global_border'                              => '', // '#e5e5e5',
	'colors_global_heading'                             => '', // '#222222',
	'colors_global_text'                                => '', // '#333333',
	'colors_global_site_bg'                             => '', // '#dddddd',
	'colors_global_content_bg'                          => '', // '#f9f9f9',
	'colors_global_sticky_bg'                           => '', // '#edf2ef',
	'colors_header_bg'                                  => '', // '#FFFFFF',
	'colors_header_border'                              => '', // '#e0e0e0',

	'colors_header_button_bgcolor'                      => '',
	'colors_header_button_bgcolor_hover'                => '',
	'colors_header_button_color'                        => '',
	'colors_header_button_hover_color'                  => '',
	'colors_header_button_border_color'                 => '',
	'colors_header_button_border_hover_color'           => '',
	'colors_header_button_border_line_height'           => '',

	'colors_header2_bg'                                 => '', // '#2626f3',
	'colors_header2_text'                               => '', // '#FFFFFF',
	'colors_header2_sc_si'                              => '', // '#FFFFFF',
	'colors_header2_sc_si_hover'                        => '', // '#FFFFFF',
	'colors_header2_sc_si_hover_bg'                     => '', // '#000000',

	'colors_menu_text'                                  => '', // '#757575',
	'colors_menu_hover'                                 => '', // '#0000f2',
	'colors_menu_sub_text'                              => '', // '#FFFFFF',
	'colors_menu_sub_hover'                             => '', // '#bfbfbf',
	'colors_menu_sub_hover_bg'                          => '', // '#1515b7',
	'colors_menu_sub_bg'                                => '', // '#2626f3',
	'colors_menu_sub_border'                            => '', // '#1919e1',
	'colors_menu_color'                                 => '', // '#FFFFFF',

	'colors_menu_mob_bg'                                => '', // '#2626f3',
	'colors_menu_mob_hover'                             => '', // '#bfbfbf',
	'colors_menu_mob_hover_bg'                          => '', // '#1515b7',
	'colors_menu_mob_border'                            => '', // '#969696',

	'colors_title_bg'                                   => '', // '#f5f5f5',
	'colors_title_text'                                 => '', // '#333333',
	'colors_footer_bg'                                  => '', // '#FFFFFF',
	'colors_footer_heading'                             => '', // '#FFFFFF',
	'colors_footer_text'                                => '', // '#777777',
	'colors_footer_link'                                => '', // '#757575',
	'colors_footer_link_hover'                          => '', // '#2626f3',
	'colors_footer_top_border'                          => '', // '#c1c1c1',
	'colors_footer_border'                              => '', // '#c1c1c1',
	'colors_footer_sc_set_bg'                           => '', // '#DEE1E7',
	'colors_footer_sc_bg'                               => '', // '#FFFFFF',
	'colors_footer_sc_text'                             => '', // '#777777',
	'colors_footer_sc_link'                             => '', // '#353535',
	'colors_footer_sc_link_hover'                       => '', // '#2626f3',
	'colors_footer_sc_si_bg'                            => '', // '#2626f3',
	'colors_footer_sc_si'                               => '', // '#959ca0',
	'colors_footer_sc_si_hover'                         => '', // '#FFFFFF',
	'colors_footer_sc_si_hover_bg'                      => '', // '#0000f2',

	'colors_footer_top_icon'                            => '',
	'colors_footer_top_title'                           => '',
	'colors_footer_top_desc'                            => '',
	'typography_options_subsets'                        => [ 'latin' ],
	'typography_global_scale'                           => 1.125,
	'typography_global_font_family'                     => '',
	'typography_global_font_variant'                    => '',
	'typography_global_font_size'                       => '',
	'typography_global_line_height'                     => '',
	'typography_global_text_transform'                  => '',
	'typography_global_letter_spacing'                  => '',
	'typography_global_word_spacing'                    => '',
	'typography_heading_font_family'                    => '',
	'typography_heading_font_variant'                   => '',
	'typography_heading_font_size'                      => '',
	'typography_heading_line_height'                    => '',
	'typography_heading_text_transform'                 => '',
	'typography_heading_letter_spacing'                 => '',
	'typography_heading_word_spacing'                   => '',
	'typography_heading_h1_font_family'                 => '',
	'typography_heading_h1_font_variant'                => '',
	'typography_heading_h1_font_size'                   => '',
	'typography_heading_h1_line_height'                 => '',
	'typography_heading_h1_text_transform'              => '',
	'typography_heading_h1_letter_spacing'              => '',
	'typography_heading_h1_word_spacing'                => '',
	'typography_heading_h2_font_family'                 => '',
	'typography_heading_h2_font_variant'                => '',
	'typography_heading_h2_font_size'                   => '',
	'typography_heading_h2_line_height'                 => '',
	'typography_heading_h2_text_transform'              => '',
	'typography_heading_h2_letter_spacing'              => '',
	'typography_heading_h2_word_spacing'                => '',
	'typography_heading_h3_font_family'                 => '',
	'typography_heading_h3_font_variant'                => '',
	'typography_heading_h3_font_size'                   => '',
	'typography_heading_h3_line_height'                 => '',
	'typography_heading_h3_text_transform'              => '',
	'typography_heading_h3_letter_spacing'              => '',
	'typography_heading_h3_word_spacing'                => '',
	'typography_heading_h4_font_family'                 => '',
	'typography_heading_h4_font_variant'                => '',
	'typography_heading_h4_font_size'                   => '',
	'typography_heading_h4_line_height'                 => '',
	'typography_heading_h4_text_transform'              => '',
	'typography_heading_h4_letter_spacing'              => '',
	'typography_heading_h4_word_spacing'                => '',
	'typography_heading_h5_font_family'                 => '',
	'typography_heading_h5_font_variant'                => '',
	'typography_heading_h5_font_size'                   => '',
	'typography_heading_h5_line_height'                 => '',
	'typography_heading_h5_text_transform'              => '',
	'typography_heading_h5_letter_spacing'              => '',
	'typography_heading_h5_word_spacing'                => '',
	'typography_heading_h6_font_family'                 => '',
	'typography_heading_h6_font_variant'                => '',
	'typography_heading_h6_font_size'                   => '',
	'typography_heading_h6_line_height'                 => '',
	'typography_heading_h6_text_transform'              => '',
	'typography_heading_h6_letter_spacing'              => '',
	'typography_heading_h6_word_spacing'                => '',
	'typography_menu_font_family'                       => '',
	'typography_menu_font_variant'                      => '',
	'typography_menu_font_size'                         => '',
	'typography_menu_line_height'                       => false,
	'typography_menu_text_transform'                    => '',
	'typography_menu_letter_spacing'                    => '',
	'typography_menu_word_spacing'                      => '',
	'typography_menu_sub_font_family'                   => '',
	'typography_menu_sub_font_variant'                  => '',
	'typography_menu_sub_font_size'                     => '',
	'typography_menu_sub_line_height'                   => '',
	'typography_menu_sub_text_transform'                => '',
	'typography_menu_sub_letter_spacing'                => '',
	'typography_menu_sub_word_spacing'                  => '',
	'typography_menu_mobile_font_family'                => '',
	'typography_menu_mobile_font_variant'               => '',
	'typography_menu_mobile_font_size'                  => '',
	'typography_menu_mobile_line_height'                => '',
	'typography_menu_mobile_text_transform'             => '',
	'typography_menu_mobile_letter_spacing'             => '',
	'typography_menu_mobile_word_spacing'               => '',
	'typography_site_title_font_family'                 => '',
	'typography_site_title_font_variant'                => '',
	'typography_site_title_font_size'                   => '',
	'typography_site_title_line_height'                 => '',
	'typography_site_title_text_transform'              => '',
	'typography_site_title_letter_spacing'              => '',
	'typography_site_title_word_spacing'                => '',
	'typography_site_tagline_font_family'               => '',
	'typography_site_tagline_font_variant'              => '',
	'typography_site_tagline_font_size'                 => '',
	'typography_site_tagline_line_height'               => '',
	'typography_site_tagline_text_transform'            => '',
	'typography_site_tagline_letter_spacing'            => '',
	'typography_site_tagline_word_spacing'              => '',
	'typography_sidebar_title_font_family'              => '',
	'typography_sidebar_title_font_variant'             => '',
	'typography_sidebar_title_font_size'                => '20',
	'typography_sidebar_title_line_height'              => '',
	'typography_sidebar_title_text_transform'           => '',
	'typography_sidebar_title_letter_spacing'           => '',
	'typography_sidebar_title_word_spacing'             => '',
	'typography_sidebar_body_font_family'               => '',
	'typography_sidebar_body_font_variant'              => '',
	'typography_sidebar_body_font_size'                 => '',
	'typography_sidebar_body_line_height'               => '',
	'typography_sidebar_body_text_transform'            => '',
	'typography_sidebar_body_letter_spacing'            => '',
	'typography_sidebar_body_word_spacing'              => '',
	'typography_footer_title_font_family'               => '',
	'typography_footer_title_font_variant'              => '',
	'typography_footer_title_font_size'                 => '',
	'typography_footer_title_line_height'               => '',
	'typography_footer_title_text_transform'            => '',
	'typography_footer_title_letter_spacing'            => '',
	'typography_footer_title_word_spacing'              => '',
	'typography_footer_body_font_family'                => '',
	'typography_footer_body_font_variant'               => '',
	'typography_footer_body_font_size'                  => '',
	'typography_footer_body_line_height'                => '',
	'typography_footer_body_text_transform'             => '',
	'typography_footer_body_letter_spacing'             => '',
	'typography_footer_body_word_spacing'               => '',
	'typography_footer_text_font_family'                => '',
	'typography_footer_text_font_variant'               => '',
	'typography_footer_text_font_size'                  => '',
	'typography_footer_text_line_height'                => '',
	'typography_footer_text_text_transform'             => '',
	'typography_footer_text_letter_spacing'             => '',
	'typography_footer_text_word_spacing'               => '',

	'bg_image_global_site'                              => '',
	'title_bar_title_container'                         => '',
	'layout_enable_title_breadcrumb'                    => 0,
	'woocommerce_general_enable_product_flying_cart'    => 1,
	'woocommerce_general_enable_product_zoom'           => 1,
	'woocommerce_general_enable_product_lightbox'       => 1,
	'woocommerce_general_enable_product_gallery_slider' => 1,
	'woocommerce_shop_archive_title-bar'                => 1,
	'woocommerce_shop_archive_title'                    => 0,
	'woocommerce_shop_archive_per_page'                 => 9,
	'woocommerce_shop_archive_layout'                   => 'right',
	'woocommerce_shop_archive_sidebar'                  => 'shop-sidebar',
	'woocommerce_shop_archive_column'                   => 3,
	'woocommerce_shop_archive_sort'                     => 1,
	'woocommerce_shop_archive_result_count'             => 1,
	'woocommerce_single_layout'                         => 'none',
	'woocommerce_single_attribute'                      => 'default',
	'woocommerce_single_sidebar'                        => 'default',
	'woocommerce_single_upsells_count'                  => 4,
	'woocommerce_single_related_item_count'             => 4,
	'woocommerce_single_related_product_column'         => 4,
	'woocommerce_single_include_image_gallery'          => 1,
	'woocommerce_single_social_share'                   => 1,
	'woocommerce_taxonomy_archive_cat_layout'           => 'right',
	'woocommerce_taxonomy_archive_cat_sidebar'          => 'shop-sidebar',
	'woocommerce_taxonomy_archive_tag_layout'           => 'right',
	'woocommerce_taxonomy_archive_tag_sidebar'          => 'shop-sidebar',
	'woocommerce_cart_title-bar'                        => 1,
	'woocommerce_cart_cross_sell_count'                 => 2,
	'woocommerce_cart_cross_sell_column'                => 2,
	'woocommerce_cart_sidebar_layout'                   => 'none',
	'woocommerce_cart_sidebar'                          => 'default',
	'woocommerce_demo_store'                            => 0,
	'woocommerce_demo_store_info'                       => __( 'This is a demo store for testing purposes &emdash; no orders shall be fulfilled.', 'ayyash' ),
	'woocommerce_shop_page_display'                     => '',
	'woocommerce_category_archive_display'              => '',
	'woocommerce_default_catalog_orderby'               => 'menu_order',
	'woocommerce_product_catalog_title'                 => 1,
	'woocommerce_checkout_sidebar'                      => 'default',
	'woocommerce_checkout_sidebar_layout'               => 'none',
	'woocommerce_checkout_company_field'                => 'required',
	'woocommerce_checkout_address_2_field'              => 'optional',
	'woocommerce_checkout_phone_field'                  => 'required',
	'woocommerce_checkout_highlight_required_fields'    => 1,
	'wp_page_for_privacy_policy'                        => '',
	'woocommerce_terms_page_id'                         => '',
	'woocommerce_checkout_privacy_policy_text'          => __( 'Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our [privacy_policy].', 'ayyash' ),
	'woocommerce_checkout_terms_and_conditions_checkbox_text' => __( 'I have read and agree to the website [terms]', 'ayyash' ),
	'woocommerce_checkout_title-bar'                    => 1,
	'woocommerce_myaccount_title-bar'                   => 1,
	'woocommerce_myaccount_sidebar_layout'              => 'none',
	'woocommerce_myaccount_sidebar'                     => 'shop-sidebar',
	'woocommerce_single_image_width'                    => '600',
	'woocommerce_thumbnail_image_width'                 => '300',
	'woocommerce_thumbnail_cropping'                    => '1:1',

	//Dokan
	'dokan_template_style'                              => 1,
	'dokan_template_store_per_page'                     => 8,
	'dokan_template_store_columns'                      => 4,

	'layout_wpcf7_columns'                              => 'two-column',
	'layout_wpcf7_top_padding'                          => 15,
	'layout_wpcf7_bottom_padding'                       => 15,
	'layout_wpcf7_left_padding'                         => 20,
	'layout_wpcf7_right_padding'                        => 20,
	'layout_wpcf7_border_radius'                        => 0,
	'layout_wpcf7_gap'                                  => 30,
	'layout_wpcf7_textarea_height'                      => 200,
	'layout_wpcf7_btn_position'                         => 'left',
];

$ayyash_defaults['choices'] = [
	'layout_global_site'                               => [
		'wide'  => __( 'Wide', 'ayyash' ),
		'boxed' => __( 'Boxed', 'ayyash' ),
	],
	'layout_global_content_layout'                     => [
		'container'       => __( 'Container', 'ayyash' ),
		'container-fluid' => __( 'Container Fluid', 'ayyash' ),
	],
	'layout_global_content_grid'                       => $ayyash_grid_list,
	'layout_global_sidebar_grid'                       => $ayyash_grid_list,

	'preload_animation_type'                           => [
		'none'               => __( 'None', 'ayyash' ),
		'bounce'             => __( 'Bounce', 'ayyash' ),
		'flash'              => __( 'Flash', 'ayyash' ),
		'pulse'              => __( 'Pulse', 'ayyash' ),
		'rubberBand'         => __( 'Rubber Band', 'ayyash' ),
		'shakeX'             => __( 'Shake X', 'ayyash' ),
		'shakeY'             => __( 'Shake Y', 'ayyash' ),
		'headShake'          => __( 'Head Shake', 'ayyash' ),
		'swing'              => __( 'Swing', 'ayyash' ),
		'tada'               => __( 'Ta Da', 'ayyash' ),
		'wobble'             => __( 'Wooble', 'ayyash' ),
		'jello'              => __( 'Jello', 'ayyash' ),
		'heartBeat'          => __( 'Heart Beat', 'ayyash' ),
		'backInDown'         => __( 'Back In Down', 'ayyash' ),
		'backInLeft'         => __( 'Back In Left', 'ayyash' ),
		'backInRight'        => __( 'Back In Right', 'ayyash' ),
		'backInUp'           => __( 'Back In Up', 'ayyash' ),
		'backOutDown'        => __( 'Back Out Down', 'ayyash' ),
		'backOutLeft'        => __( 'Back Out Left', 'ayyash' ),
		'backOutRight'       => __( 'Back Out Right', 'ayyash' ),
		'backOutUp'          => __( 'Back Out Up', 'ayyash' ),
		'bounceIn'           => __( 'Bounce In', 'ayyash' ),
		'bounceInDown'       => __( 'Bounce In Down', 'ayyash' ),
		'bounceInLeft'       => __( 'Bounce In Left', 'ayyash' ),
		'bounceInRight'      => __( 'Bounce In Right', 'ayyash' ),
		'bounceInUp'         => __( 'Bounce In Up', 'ayyash' ),
		'bounceOut'          => __( 'Bounce Out ', 'ayyash' ),
		'bounceOutDown'      => __( 'Bounce Out Down', 'ayyash' ),
		'bounceOutLeft'      => __( 'Bounce Out Left', 'ayyash' ),
		'bounceOutRight'     => __( 'Bounce Out Right', 'ayyash' ),
		'bounceOutUp'        => __( 'Bounce Out Up', 'ayyash' ),
		'fadeIn'             => __( 'Fade In', 'ayyash' ),
		'fadeInDown'         => __( 'Fade In Down', 'ayyash' ),
		'fadeInDownBig'      => __( 'Fade In Down Big', 'ayyash' ),
		'fadeInLeft'         => __( 'Fade In Left', 'ayyash' ),
		'fadeInLeftBig'      => __( 'Fade In Left Big', 'ayyash' ),
		'fadeInRight'        => __( 'Fade In Right', 'ayyash' ),
		'fadeInRightBig'     => __( 'Fade In Right Big', 'ayyash' ),
		'fadeInUp'           => __( 'Fade In Up', 'ayyash' ),
		'fadeInUpBig'        => __( 'Fade In Big', 'ayyash' ),
		'fadeInTopLeft'      => __( 'Fade In Top Left', 'ayyash' ),
		'fadeInTopRight'     => __( 'Fade In Top Right', 'ayyash' ),
		'fadeInBottomLeft'   => __( 'Fade In Bottom Left', 'ayyash' ),
		'fadeInBottomRight'  => __( 'Fade In Bottom Right', 'ayyash' ),
		'fadeOut'            => __( 'Fade Out', 'ayyash' ),
		'fadeOutDown'        => __( 'Fade Out Down', 'ayyash' ),
		'fadeOutDownBig'     => __( 'Fade Out Down Big', 'ayyash' ),
		'fadeOutLeft'        => __( 'Fade Out Left', 'ayyash' ),
		'fadeOutLeftBig'     => __( 'Fade Out Left Big', 'ayyash' ),
		'fadeOutRight'       => __( 'Fade Out Right', 'ayyash' ),
		'fadeOutRightBig'    => __( 'Fade Out Right Big', 'ayyash' ),
		'fadeOutUp'          => __( 'Fade Out Up', 'ayyash' ),
		'fadeOutUpBig'       => __( 'Fade Out Big', 'ayyash' ),
		'fadeOutTopLeft'     => __( 'Fade Out Top Left', 'ayyash' ),
		'fadeOutTopRight'    => __( 'Fade Out Top Right', 'ayyash' ),
		'fadeOutBottomRight' => __( 'Fade Out Bottom Right', 'ayyash' ),
		'fadeOutBottomLeft'  => __( 'Fade Out Bottom Left', 'ayyash' ),
		'Flippers'           => __( 'Flippers', 'ayyash' ),
		'flip'               => __( 'Flip', 'ayyash' ),
		'flipInX'            => __( 'Flip In X', 'ayyash' ),
		'flipInY'            => __( 'Flip In Y', 'ayyash' ),
		'flipOutX'           => __( 'Flip Out X', 'ayyash' ),
		'flipOutY'           => __( 'Flip Out Y', 'ayyash' ),
		'Lightspeed'         => __( 'Light Speed', 'ayyash' ),
		'lightSpeedInRight'  => __( 'Light Speed In Right', 'ayyash' ),
		'lightSpeedInLeft'   => __( 'Light Speed In Left', 'ayyash' ),
		'lightSpeedOutRight' => __( 'Light Speed Out Right', 'ayyash' ),
		'lightSpeedOutLeft'  => __( 'Light Speed Out Left', 'ayyash' ),
		'rotateIn'           => __( 'Rotate In', 'ayyash' ),
		'rotateInDownLeft'   => __( 'Rotate In Down Left', 'ayyash' ),
		'rotateInDownRight'  => __( 'Rotate In Down Right', 'ayyash' ),
		'rotateInUpLeft'     => __( 'Rotate In Up Left', 'ayyash' ),
		'rotateInUpRight'    => __( 'Rotate In Up Right', 'ayyash' ),
		'Rotating'           => __( 'Rotating', 'ayyash' ),
		'rotateOut'          => __( 'Rotate Out', 'ayyash' ),
		'rotateOutDownLeft'  => __( 'Rotate Out Down Left', 'ayyash' ),
		'rotateOutDownRight' => __( 'Rotate Out Down Right', 'ayyash' ),
		'rotateOutUpLeft'    => __( 'Rotate Out Up Left', 'ayyash' ),
		'rotateOutUpRight'   => __( 'Rotate Out Up Right', 'ayyash' ),
		'Specials'           => __( 'Specials', 'ayyash' ),
		'hinge'              => __( 'Hinge', 'ayyash' ),
		'jackInTheBox'       => __( 'Jack In The Box', 'ayyash' ),
		'rollIn'             => __( 'Roll In', 'ayyash' ),
		'rollOut'            => __( 'Roll Out', 'ayyash' ),
		'zoomIn'             => __( 'Zoom In', 'ayyash' ),
		'zoomInDown'         => __( 'Zoom In Down', 'ayyash' ),
		'zoomInLeft'         => __( 'Zoom In Left', 'ayyash' ),
		'zoomInRight'        => __( 'Zoom In Right', 'ayyash' ),
		'zoomInUp'           => __( 'Zoom In Up', 'ayyash' ),
		'zoomOut'            => __( 'Zoom Out', 'ayyash' ),
		'zoomOutDown'        => __( 'Zoom Out Down', 'ayyash' ),
		'zoomOutLeft'        => __( 'Zoom Out left', 'ayyash' ),
		'zoomOutRight'       => __( 'Zoom Out Right', 'ayyash' ),
		'zoomOutUp'          => __( 'Zoom Out Up', 'ayyash' ),
		'slideInDown'        => __( 'Slide In Down', 'ayyash' ),
		'slideInLeft'        => __( 'Slide In Left', 'ayyash' ),
		'slideInRight'       => __( 'Slide In Right', 'ayyash' ),
		'slideInUp'          => __( 'Slide In Up', 'ayyash' ),
		'slideOutDown'       => __( 'Slide Out Down', 'ayyash' ),
		'slideOutLeft'       => __( 'Slide Out Left', 'ayyash' ),
		'slideOutRight'      => __( 'Slide Out Right', 'ayyash' ),
		'slideOutUp'         => __( 'Slide Out Up', 'ayyash' ),
	],
	'preload_animation_speed'                          => [
		'slower' => __( 'Slower', 'ayyash' ),
		'slow'   => __( 'Slow', 'ayyash' ),
		'fast'   => __( 'Fast', 'ayyash' ),
		'faster' => __( 'Faster', 'ayyash' ),
	],
	'preload_text_size'                                => [
		'min'  => 0,
		'max'  => 200,
		'step' => 1,
	],
	'preload_img_size'                                 => [
		'min'  => 20,
		'max'  => 400,
		'step' => 1,
	],

	'layout_blog_sidebar'                              => $ayyash_sidebar_pos,
	'layout_archive_sidebar'                           => $ayyash_sidebar_pos,
	'layout_search_sidebar'                            => $ayyash_sidebar_pos,
	'layout_post_sidebar'                              => $ayyash_sidebar_pos,
	'layout_page_sidebar'                              => $ayyash_sidebar_pos,
	'layout_blog_style'                                => $ayyash_blog_style,
	'layout_archive_style'                             => $ayyash_blog_style,
	'layout_search_style'                              => $ayyash_blog_style,
	'layout_blog_title-bar'                            => $ayyash_yes_no,
	'layout_archive_title-bar'                         => $ayyash_yes_no,
	'layout_search_title-bar'                          => $ayyash_yes_no,
	'layout_post_title-bar'                            => $ayyash_yes_no,
	'layout_post_title'                                => $ayyash_yes_no,
	'layout_page_title-bar'                            => $ayyash_yes_no,
	'layout_page_title'                                => $ayyash_yes_no,
	'layout_post_content_align'                        => $ayyash_content_align,
	'layout_page_content_align'                        => $ayyash_content_align,
	'layout_related_post_number'                       => [
		'min'  => 1,
		'max'  => 100,
		'step' => 1,
	],
	'layout_related_post_column'                       => [
		'min'  => 1,
		'max'  => 6,
		'step' => 1,
	],
	'layout_header_secondary_layout'                   => [
		'callout_icons'  => __( 'Callout + Social Icons', 'ayyash' ),
		'callout_search' => __( 'Callout + Search', 'ayyash' ),
		'icons_callout'  => __( 'Social Icons + Callout', 'ayyash' ),
		'search_callout' => __( 'Search + Callout', 'ayyash' ),
		'icons_search'   => __( 'Social Icons + Search', 'ayyash' ),
		'search_icons'   => __( 'Search + Social Icons', 'ayyash' ),
	],
	'layout_header_height'                             => [
		'min'  => 40,
		'max'  => 200,
		'step' => 1,
	],
	'layout_header_menu_height'                        => [
		'min'  => 20,
		'max'  => 200,
		'step' => 1,
	],
	'layout_header_button_top_padding'                 => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'layout_header_button_bottom_padding'              => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'layout_header_button_left_padding'                => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'layout_header_button_right_padding'               => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'layout_header_button_border_radius'               => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'layout_header_sticky_height'                      => [
		'min'  => 40,
		'max'  => 200,
		'step' => 1,
	],

	'layout_header_logo_right_space'                   => [
		'min'  => 5,
		'max'  => 200,
		'step' => 1,
	],
	'layout_header_menu_mobileshow'                    => [
		'sm' => __( 'Small Device', 'ayyash' ),
		'md' => __( 'Medium Device', 'ayyash' ),
		'lg' => __( 'Large Device', 'ayyash' ),
		'xl' => __( 'Extra Large Device', 'ayyash' ),
	],
	'layout_header_mobile_menu_style'                  => [
		'full-width-mobile-menu'       => __( 'Full Width', 'ayyash' ),
		'off-canvas-left-mobile-menu'  => __( 'Off-Canvas Left', 'ayyash' ),
		'off-canvas-right-mobile-menu' => __( 'Off-Canvas Right', 'ayyash' ),
	],
	'layout_header_menu_alignment'                     => [
		'right'  => __( 'Right', 'ayyash' ),
		'center' => __( 'Center', 'ayyash' ),
		'left'   => __( 'Left', 'ayyash' ),
	],
	'layout_header_menu_style'                         => [
		'menu-text'      => __( 'Text Color ', 'ayyash' ),
		'menu-heading'   => __( 'Heading Color ', 'ayyash' ),
		'menu-primary'   => __( 'Primary Color ', 'ayyash' ),
		'menu-secondary' => __( 'Secondary Color ', 'ayyash' ),
		'menu-white'     => __( 'White Color', 'ayyash' ),
		'menu-custom'    => __( 'Custom Color', 'ayyash' ),
	],
	'layout_header_menu_hover_style'                   => [
		'menu-hover-text'      => __( 'Text Color', 'ayyash' ),
		'menu-hover-heading'   => __( 'Heading Color', 'ayyash' ),
		'menu-hover-primary'   => __( 'Primary Color', 'ayyash' ),
		'menu-hover-secondary' => __( 'Secondary Color', 'ayyash' ),
		'menu-hover-white'     => __( 'White Color', 'ayyash' ),
		'menu-hover-custom'    => __( 'Custom Color', 'ayyash' ),
	],
	'layout_header_submenu_alignment'                  => $ayyash_content_align,
	'layout_header_submenu_width'                      => [
		'min'  => 200,
		'max'  => 400,
		'step' => 1,
	],
	'layout_header_submenu_top_padding'                => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_header_submenu_bottom_padding'             => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_header_submenu_left_padding'               => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_header_submenu_right_padding'              => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_header_menu_left_padding'                  => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_header_menu_right_padding'                 => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_header_mega_menu_bottom_spacing'           => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_transparent_header_top_margin'             => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_blog_home_date_format'                     => $dates_arr,
	'layout_blog_home_latest_posts_column'             => [
		4 => __( '4 Column', 'ayyash' ),
		3 => __( '3 Column', 'ayyash' ),
		2 => __( '2 Column', 'ayyash' ),
	],
	'layout_blog_home_sticky_posts_per_page'           => [
		'min'  => 0,
		'max'  => 12,
		'step' => 1,
	],
	'layout_blog_home_post_tab_posts_per_page'         => [
		'min'  => 0,
		'max'  => 12,
		'step' => 1,
	],
	'layout_blog_home_latest_posts_thumbnail_position' => [
		'default' => __( 'Default', 'ayyash' ),
		'left'    => __( 'Left', 'ayyash' ),
	],
	'layout_blog_home_latest_posts_per_page'           => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'layout_blog_home_latest_posts_excerpt_length'     => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],

	'layout_footer_widget_column'                      => [
		12 => __( '1 Column', 'ayyash' ),
		6  => __( '2 Column', 'ayyash' ),
		4  => __( '3 Column', 'ayyash' ),
		3  => __( '4 Column', 'ayyash' ),
	],

	'layout_footer_credits_top_margin'                 => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'layout_footer_credits_bottom_margin'              => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'typography_options_subsets'                       => [
		'latin'        => __( 'Latin', 'ayyash' ),
		'latin-ext'    => __( 'Latin Extended', 'ayyash' ),
		'greek'        => __( 'Greek', 'ayyash' ),
		'greek-ext'    => __( 'Greek Extended', 'ayyash' ),
		'cyrillic'     => __( 'Cyrillic', 'ayyash' ),
		'cyrillic-ext' => __( 'Cyrillic Extended', 'ayyash' ),
		'vietnamese'   => __( 'Vietnamese', 'ayyash' ),
		'arabic'       => __( 'Arabic', 'ayyash' ),
		'khmer'        => __( 'Khmer', 'ayyash' ),
		'devanagari'   => __( 'Devanagari', 'ayyash' ),
	],
	'woocommerce_general_menu_cart'                    => [
		'icon'       => __( 'Icon', 'ayyash' ),
		'icon-cart'  => __( 'Icon And Cart Total', 'ayyash' ),
		'icon-count' => __( 'Icon And Cart Count', 'ayyash' ),
		'disable'    => __( 'Disable', 'ayyash' ),
	],
	'woocommerce_shop_archive_title-bar'               => [
		1 => __( 'Yes', 'ayyash' ),
		0 => __( 'No', 'ayyash' ),
	],
	'woocommerce_shop_archive_layout'                  => [
		'left'  => __( 'Left', 'ayyash' ),
		'right' => __( 'Right', 'ayyash' ),
		'none'  => __( 'None', 'ayyash' ),
	],
	'woocommerce_shop_archive_sidebar'                 => $sidebar_list,
	'woocommerce_shop_archive_column'                  => $ayyash_grid_list,
	'woocommerce_product_catalog_title-bar'            => [
		1 => __( 'Yes', 'ayyash' ),
		0 => __( 'No', 'ayyash' ),
	],
	'woocommerce_taxonomy_archive_cat_sidebar'         => $sidebar_list,
	'woocommerce_taxonomy_archive_cat_layout'          => [
		'left'  => __( 'Left', 'ayyash' ),
		'right' => __( 'Right', 'ayyash' ),
		'none'  => __( 'None', 'ayyash' ),
	],
	'woocommerce_taxonomy_archive_tag_sidebar'         => $sidebar_list,
	'woocommerce_taxonomy_archive_tag_layout'          => [
		'left'  => __( 'Left', 'ayyash' ),
		'right' => __( 'Right', 'ayyash' ),
		'none'  => __( 'None', 'ayyash' ),
	],
	'woocommerce_single_layout'                        => [
		'left'  => __( 'Left', 'ayyash' ),
		'right' => __( 'Right', 'ayyash' ),
		'none'  => __( 'None', 'ayyash' ),
	],
	'woocommerce_single_attribute'                     => [
		'default'  => __( 'Default', 'ayyash' ),
		'checkbox' => __( 'Checkbox', 'ayyash' ),
	],
	'woocommerce_single_sidebar'                       => $sidebar_list,
	'woocommerce_single_product_gallery_lightbox'      => [
		'disable'              => __( 'Disable', 'ayyash' ),
		'theme-lightbox'       => __( 'Theme Lightbox', 'ayyash' ),
		'woocommerce-lightbox' => __( 'WooCommerce Lightbox', 'ayyash' ),
	],
	'woocommerce_single_related_product_column'        => $ayyash_grid_list,
	'woocommerce_cart_title-bar'                       => [
		1 => __( 'Yes', 'ayyash' ),
		0 => __( 'No', 'ayyash' ),
	],
	'woocommerce_general_enable_product_flying_cart'   => [
		1 => __( 'Yes', 'ayyash' ),
		0 => __( 'No', 'ayyash' ),
	],
	'woocommerce_cart_cross_sell_column'               => $ayyash_grid_list,
	'woocommerce_cart_sidebar_layout'                  => [
		'left'  => __( 'Left', 'ayyash' ),
		'right' => __( 'Right', 'ayyash' ),
		'none'  => __( 'None', 'ayyash' ),
	],
	'woocommerce_cart_sidebar'                         => $sidebar_list,
	'woocommerce_checkout_sidebar_layout'              => [
		'left'  => __( 'Left', 'ayyash' ),
		'right' => __( 'Right', 'ayyash' ),
		'none'  => __( 'None', 'ayyash' ),
	],
	'woocommerce_checkout_title-bar'                   => [
		1 => __( 'Yes', 'ayyash' ),
		0 => __( 'No', 'ayyash' ),
	],
	'woocommerce_myaccount_title-bar'                  => [
		1 => __( 'Yes', 'ayyash' ),
		0 => __( 'No', 'ayyash' ),
	],
	'woocommerce_myaccount_sidebar_layout'             => [
		'left'  => __( 'Left', 'ayyash' ),
		'right' => __( 'Right', 'ayyash' ),
		'none'  => __( 'None', 'ayyash' ),
	],
	'woocommerce_myaccount_sidebar'                    => $sidebar_list,
	'woocommerce_checkout_sidebar'                     => $sidebar_list,
	'layout_wpcf7_columns'                             => [
		'two-column'    => __( 'Two Column', 'ayyash' ),
		'single-column' => __( 'Single Column', 'ayyash' ),
	],

	// Dokan Template Option
	'dokan_template_style'                             => [
		1 => __( 'Style One', 'ayyash' ),
		2 => __( 'Style Two', 'ayyash' ),
		3 => __( 'Style Three', 'ayyash' ),
	],

	'dokan_template_store_per_page'                    => [
		'min'  => 0,
		'max'  => 60,
		'step' => 1,
	],

	'dokan_template_store_columns'                     => [
		2 => __( '2 Column', 'ayyash' ),
		3 => __( '3 Column', 'ayyash' ),
		4 => __( '4 Column', 'ayyash' ),
	],

	'layout_wpcf7_top_padding'                         => [
		'min'  => 0,
		'max'  => 200,
		'step' => 1,
	],
	'layout_wpcf7_bottom_padding'                      => [
		'min'  => 0,
		'max'  => 200,
		'step' => 1,
	],
	'layout_wpcf7_left_padding'                        => [
		'min'  => 0,
		'max'  => 200,
		'step' => 1,
	],
	'layout_wpcf7_right_padding'                       => [
		'min'  => 0,
		'max'  => 200,
		'step' => 1,
	],
	'layout_wpcf7_border_radius'                       => [
		'min'  => 0,
		'max'  => 200,
		'step' => 1,
	],
	'layout_wpcf7_textarea_height'                     => [
		'min'  => 40,
		'max'  => 400,
		'step' => 1,
	],
	'layout_wpcf7_gap'                                 => [
		'min'  => 0,
		'max'  => 400,
		'step' => 1,
	],
	'layout_wpcf7_btn_position'                        => [
		'left'  => __( 'Left', 'ayyash' ),
		'right' => __( 'Right', 'ayyash' ),
	],
];

// Blog Home pages Categories Default Options
$selected_categories = get_theme_mod( 'layout_blog_home_categories_control' );

if ( ! empty( $selected_categories ) ) {
	$ayyash_home_categories        = [];
	$ayyash_home_categories_choice = [];

	$sidebars = $GLOBALS['wp_registered_sidebars'];

	$sidebars_list = [];
	foreach ( $sidebars as $sidebar ) {
		$sidebar_list[ $sidebar['id'] ] = $sidebar['name'];
	}

	foreach ( $selected_categories as $category ) {

		$ayyash_defaults[ 'layout_blog_home_' . $category . '_title' ]              = '';
		$ayyash_defaults[ 'layout_blog_home_' . $category . '_column' ]             = 3;
		$ayyash_defaults[ 'layout_blog_home_' . $category . '_thumbnail_position' ] = 'default';
		$ayyash_defaults[ 'layout_blog_home_' . $category . '_view_btn' ]           = 1;
		$ayyash_defaults[ 'layout_blog_home_' . $category . '_excerpt_length' ]     = 10;
		$ayyash_defaults[ 'layout_blog_home_' . $category . '_post_per_page' ]      = 6;
		$ayyash_defaults[ 'layout_blog_home_' . $category . '_sidebar' ]            = 'main-sidebar';
		$ayyash_defaults[ 'layout_blog_home_' . $category . '_sidebar_position' ]   = 'none';

		$ayyash_defaults['choices'][ 'layout_blog_home_' . $category . '_column' ] = [
			4 => __( '4 Column', 'ayyash' ),
			3 => __( '3 Column', 'ayyash' ),
			2 => __( '2 Column', 'ayyash' ),
		];

		$ayyash_defaults['choices'][ 'layout_blog_home_' . $category . '_thumbnail_position' ] = [
			'default' => __( 'Default', 'ayyash' ),
			'left'    => __( 'Left', 'ayyash' ),
		];

		$ayyash_defaults['choices'][ 'layout_blog_home_' . $category . '_excerpt_length' ] = [
			'min'  => 0,
			'max'  => 50,
			'step' => 1,
		];

		$ayyash_defaults['choices'][ 'layout_blog_home_' . $category . '_post_per_page' ] = [
			'min'  => 0,
			'max'  => 50,
			'step' => 1,
		];

		$ayyash_defaults['choices'][ 'layout_blog_home_' . $category . '_sidebar' ]          = $sidebar_list;
		$ayyash_defaults['choices'][ 'layout_blog_home_' . $category . '_sidebar_position' ] = $ayyash_sidebar_pos;
	}
}
// phpcs:enable
