<?php
/**
 * CSS Variable Mapping.
 *
 * @package Ayyash
 * @version 1.0.0
 * @since 1.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

return [
	'colors_global_accent'                    => '--ayyash-color-primary',
	'colors_global_accent_shade'              => '--ayyash-color-secondary',
	'colors_global_heading'                   => '--ayyash-color-heading',
	'colors_global_text'                      => '--ayyash-color-global',
	'colors_global_content_bg'                => '--ayyash-color-content-bg',
	'colors_global_site_bg'                   => '--ayyash-color-site-bg',
	'colors_global_border'                    => '--ayyash-color-border',
	'colors_footer_sc_text'                   => '--ayyash-color-credit',
	'colors_footer_sc_bg'                     => '--ayyash-color-credit-bg',
	'colors_global_gradient'                  => '--ayyash-color-gradient',

	'colors_global_alt'                       => '--ayyash-color-form-bg',
	'colors_global_alt_text'                  => '--ayyash-color-form-text',

	//'colors_global_text_alt'                  => '--ayyash-tac', @TODO to be deleted in future

	'colors_global_sticky_bg'                 => '--ayyash-color-sticky-bg',
	'colors_header_bg'                        => '--ayyash-color-header-bg',
	'colors_header_button_color'              => '--ayyash-color-header-button',
	'colors_header_button_hover_color'        => '--ayyash-color-header-button-hover',
	'colors_header_button_border_color'       => '--ayyash-color-header-button-border',
	'colors_header_button_border_hover_color' => '--ayyash-color-header-button-border-hover',
	'colors_header_button_bgcolor'            => '--ayyash-color-header-button-bg',
	'colors_header_button_bgcolor_hover'      => '--ayyash-color-header-button-hover-bg',

	'colors_header2_bg'                       => '--ayyash-color-secondary-header-bg',
	'colors_header2_text'                     => '--ayyash-color-secondary-header',

	'colors_header2_sc_si'                    => '--ayyash-color-secondary-header-social-icon',
	'colors_header2_sc_si_hover'              => '--ayyash-color-secondary-header-social-icon-hover',
	'colors_header2_sc_si_hover_bg'           => '--ayyash-color-secondary-header-social-icon-hover-bg',
	'colors_menu_text'                        => '--ayyash-color-main-menu',
	'colors_menu_hover'                       => '--ayyash-color-main-menu-hover',

	'colors_menu_sub_bg'                      => '--ayyash-color-sub-menu-bg',
	'colors_menu_sub_border'                  => '--ayyash-color-sub-menu-border',
	'colors_menu_sub_text'                    => '--ayyash-color-sub-menu',
	'colors_menu_sub_hover'                   => '--ayyash-color-sub-menu-hover',
	'colors_menu_sub_hover_bg'                => '--ayyash-color-sub-menu-bg-hover',
	'colors_menu_mob_bg'                      => '--ayyash-color-mobile-menu-bg',
	'colors_menu_color'                       => '--ayyash-color-mobile-menu',
	'colors_menu_mob_hover'                   => '--ayyash-color-mobile-menu-hover',
	'colors_menu_mob_hover_bg'                => '--ayyash-color-mobile-menu-bg-hover',
	'colors_menu_mob_border'                  => '--ayyash-color-mobile-menu-border',

	'colors_mega_menu_bg'                     => '--ayyash-color-mega-menu-bg',
	'colors_mega_menu_title'                  => '--ayyash-color-mega-menu-column-title',
	'colors_mega_menu_title_hover'            => '--ayyash-color-mega-menu-column-title-hover',
	'colors_mega_menu_item'                   => '--ayyash-color-mega-menu-item',
	'colors_mega_menu_item_hover'             => '--ayyash-color-mega-menu-item-hover',

	'colors_title_bg'                         => '--ayyash-color-breadcrumb-bg',
	'colors_title_text'                       => '--ayyash-color-breadcrumb',

	// Footer Main
	'colors_footer_main_bg'                   => '--ayyash-color-footer-bg',
	'colors_footer_main_heading'              => '--ayyash-color-footer-heading',
	'colors_footer_main_text'                 => '--ayyash-color-footer',
	'colors_footer_main_link'                 => '--ayyash-color-footer-link',
	'colors_footer_main_link_hover'           => '--ayyash-color-footer-link-hover',

	// Footer Secondary
	'colors_footer_sc_set_bg'                 => '--ayyash-color-secondary-footer-set-bg',
	'colors_footer_sc_link'                   => '--ayyash-color-secondary-footer-link',
	'colors_footer_sc_link_hover'             => '--ayyash-color-secondary-footer-link-hover',
	'colors_footer_sc_si_bg'                  => '--ayyash-color-footer-social-icon-bg',
	'colors_footer_sc_si'                     => '--ayyash-color-footer-social-icon',
	'colors_footer_sc_si_hover'               => '--ayyash-color-footer-social-icon-hover',
	'colors_footer_sc_si_hover_bg'            => '--ayyash-color-footer-social-icon-bg-hover',

	// Layout
	'layout_header_height'                    => '--ayyash-header-height',
	'layout_header_menu_height'               => '--ayyash-menu-height',

	'layout_header_button_top_padding'        => '--ayyash-header-button-padding-top',
	'layout_header_button_bottom_padding'     => '--ayyash-header-button-padding-bottom',
	'layout_header_button_left_padding'       => '--ayyash-header-button-padding-left',
	'layout_header_button_right_padding'      => '--ayyash-header-button-padding-right',
	'layout_header_button_border_radius'      => '--ayyash-header-button-border-radius',
	'layout_header_button_line_height'        => '--ayyash-header-button-line-height',

	'layout_header_sticky_height'             => '--ayyash-header-sticky-height',
	'layout_header_sticky_menu_height'        => '--ayyash-header-sticky-menu-height',
	'layout_header_submenu_width'             => '--ayyash-header-submenu-width',
	'layout_header_submenu_top_padding'       => '--ayyash-header-submenu-padding-top',
	'layout_header_submenu_bottom_padding'    => '--ayyash-header-submenu-padding-bottom',
	'layout_header_submenu_left_padding'      => '--ayyash-header-submenu-padding-left',
	'layout_header_submenu_right_padding'     => '--ayyash-header-submenu-padding-right',
	'layout_header_menu_left_padding'         => '--ayyash-header-menu-padding-left',
	'layout_header_menu_right_padding'        => '--ayyash-header-menu-padding-right',
	'layout_header_mega_menu_bottom_spacing'  => '--ayyash-header-mega-menu-spacing-bottom',
	'layout_transparent_header_top_margin'    => '--ayyash-header-transparent-margin-top',
	'layout_footer_credits_top_margin'        => '--ayyash-footer-credits-margin-top',
	'layout_footer_credits_bottom_margin'     => '--ayyash-footer-credits-margin-bottom',

	// Layout align
	'layout_header_menu_alignment'            => '--ayyash-header-menu-alignment',
	'layout_header_submenu_alignment'         => '--ayyash-header-submenu-alignment',
	'layout_post_content_align'               => '--ayyash-post-content-alignment',
	'layout_page_content_align'               => '--ayyash-page-content-alignment',

	// Typo Global.
	'typography_global_font_family'           => '--ayyash-global-font-family',
	'typography_global_font_variant'          => '--ayyash-global-font-weight',
	'typography_global_font_size'             => '--ayyash-global-font-size', // TODO old variable --ayyash-font-size-global
	'typography_global_line_height'           => '--ayyash-global-line-height',
	'typography_global_text_transform'        => '--ayyash-global-text-transform',
	'typography_global_letter_spacing'        => '--ayyash-global-letter-spacing',
	'typography_global_word_spacing'          => '--ayyash-global-word-spacing',

	// Typo Headings.
	'typography_heading_font_family'          => '--ayyash-heading-font-family',
	'typography_heading_font_variant'         => '--ayyash-heading-font-weight',
	'typography_heading_font_size'            => '--ayyash-heading-font-size',
	'typography_heading_line_height'          => '--ayyash-heading-line-height',
	'typography_heading_text_transform'       => '--ayyash-heading-text-transform',
	'typography_heading_letter_spacing'       => '--ayyash-heading-letter-spacing',
	'typography_heading_word_spacing'         => '--ayyash-heading-word-spacing',

	'typography_heading_h1_font_family'       => '--ayyash-h1-font-family',
	'typography_heading_h1_font_variant'      => '--ayyash-h1-font-weight',
	'typography_heading_h1_font_size'         => '--ayyash-h1-font-size',
	'typography_heading_h1_line_height'       => '--ayyash-h1-line-height',
	'typography_heading_h1_text_transform'    => '--ayyash-h1-text-decoration',
	'typography_heading_h1_letter_spacing'    => '--ayyash-h1-letter-spacing',
	'typography_heading_h1_word_spacing'      => '--ayyash-h1-word-spacing',

	'typography_heading_h2_font_family'       => '--ayyash-h2-font-family',
	'typography_heading_h2_font_variant'      => '--ayyash-h2-font-weight',
	'typography_heading_h2_font_size'         => '--ayyash-h2-font-size',
	'typography_heading_h2_line_height'       => '--ayyash-h2-line-height',
	'typography_heading_h2_text_transform'    => '--ayyash-h2-text-decoration',
	'typography_heading_h2_letter_spacing'    => '--ayyash-h2-letter-spacing',
	'typography_heading_h2_word_spacing'      => '--ayyash-h2-word-spacing',

	'typography_heading_h3_font_family'       => '--ayyash-h3-font-family',
	'typography_heading_h3_font_variant'      => '--ayyash-h3-font-weight',
	'typography_heading_h3_font_size'         => '--ayyash-h3-font-size',
	'typography_heading_h3_line_height'       => '--ayyash-h3-line-height',
	'typography_heading_h3_text_transform'    => '--ayyash-h3-text-decoration',
	'typography_heading_h3_letter_spacing'    => '--ayyash-h3-letter-spacing',
	'typography_heading_h3_word_spacing'      => '--ayyash-h3-word-spacing',

	'typography_heading_h4_font_family'       => '--ayyash-h4-font-family',
	'typography_heading_h4_font_variant'      => '--ayyash-h4-font-weight',
	'typography_heading_h4_font_size'         => '--ayyash-h4-font-size',
	'typography_heading_h4_line_height'       => '--ayyash-h4-line-height',
	'typography_heading_h4_text_transform'    => '--ayyash-h4-text-decoration',
	'typography_heading_h4_letter_spacing'    => '--ayyash-h4-letter-spacing',
	'typography_heading_h4_word_spacing'      => '--ayyash-h4-word-spacing',

	'typography_heading_h5_font_family'       => '--ayyash-h5-font-family',
	'typography_heading_h5_font_variant'      => '--ayyash-h5-font-weight',
	'typography_heading_h5_font_size'         => '--ayyash-h5-font-size',
	'typography_heading_h5_line_height'       => '--ayyash-h5-line-height',
	'typography_heading_h5_text_transform'    => '--ayyash-h5-text-decoration',
	'typography_heading_h5_letter_spacing'    => '--ayyash-h5-letter-spacing',
	'typography_heading_h5_word_spacing'      => '--ayyash-h5-word-spacing',

	'typography_heading_h6_font_family'       => '--ayyash-h6-font-family',
	'typography_heading_h6_font_variant'      => '--ayyash-h6-font-weight',
	'typography_heading_h6_font_size'         => '--ayyash-h6-font-size',
	'typography_heading_h6_line_height'       => '--ayyash-h6-line-height',
	'typography_heading_h6_text_transform'    => '--ayyash-h6-text-decoration',
	'typography_heading_h6_letter_spacing'    => '--ayyash-h6-letter-spacing',
	'typography_heading_h6_word_spacing'      => '--ayyash-h6-word-spacing',

	'typography_menu_font_family'             => '--ayyash-menu-font-family',
	'typography_menu_font_variant'            => '--ayyash-menu-font-weight',
	'typography_menu_font_size'               => '--ayyash-menu-font-size',
	'typography_menu_text_transform'          => '--ayyash-menu-text-transform',
	'typography_menu_letter_spacing'          => '--ayyash-menu-letter-spacing',
	'typography_menu_word_spacing'            => '--ayyash-menu-word-spacing',

	'typography_menu_sub_font_family'         => '--ayyash-sub-menu-font-family',
	'typography_menu_sub_font_variant'        => '--ayyash-sub-menu-font-weight',
	'typography_menu_sub_font_size'           => '--ayyash-sub-menu-font-size',
	'typography_menu_sub_line_height'         => '--ayyash-sub-menu-line-height',
	'typography_menu_sub_text_transform'      => '--ayyash-sub-menu-text-transform',
	'typography_menu_sub_letter_spacing'      => '--ayyash-sub-menu-letter-spacing',
	'typography_menu_sub_word_spacing'        => '--ayyash-sub-menu-word-spacing',

	'typography_menu_mobile_font_family'      => '--ayyash-mobile-menu-font-family',
	'typography_menu_mobile_font_variant'     => '--ayyash-mobile-menu-font-weight',
	'typography_menu_mobile_font_size'        => '--ayyash-mobile-menu-font-size',
	'typography_menu_mobile_line_height'      => '--ayyash-mobile-menu-line-height',
	'typography_menu_mobile_text_transform'   => '--ayyash-mobile-menu-text-transform',
	'typography_menu_mobile_letter_spacing'   => '--ayyash-mobile-menu-letter-spacing',
	'typography_menu_mobile_word_spacing'     => '--ayyash-mobile-menu-word-spacing',

	'typography_site_title_font_family'       => '--ayyash-site-title-font-family',
	'typography_site_title_font_variant'      => '--ayyash-site-title-font-weight',
	'typography_site_title_font_size'         => '--ayyash-site-title-font-size',
	'typography_site_title_line_height'       => '--ayyash-site-title-line-height',
	'typography_site_title_text_transform'    => '--ayyash-site-title-text-transform',
	'typography_site_title_letter_spacing'    => '--ayyash-site-title-letter-spacing',
	'typography_site_title_word_spacing'      => '--ayyash-site-title-word-spacing',

	'typography_site_tagline_font_family'     => '--ayyash-site-tag-font-family',
	'typography_site_tagline_font_variant'    => '--ayyash-site-tag-font-weight',
	'typography_site_tagline_font_size'       => '--ayyash-site-tag-font-size',
	'typography_site_tagline_line_height'     => '--ayyash-site-tag-line-height',
	'typography_site_tagline_text_transform'  => '--ayyash-site-tag-text-transform',
	'typography_site_tagline_letter_spacing'  => '--ayyash-site-tag-letter-spacing',
	'typography_site_tagline_word_spacing'    => '--ayyash-site-tag-word-spacing',

	'typography_sidebar_title_font_family'    => '--ayyash-sidebar-widget-title-font-family',
	'typography_sidebar_title_font_variant'   => '--ayyash-sidebar-widget-title-font-weight',
	'typography_sidebar_title_font_size'      => '--ayyash-sidebar-widget-title-font-size',
	'typography_sidebar_title_line_height'    => '--ayyash-sidebar-widget-title-line-height',
	'typography_sidebar_title_text_transform' => '--ayyash-sidebar-widget-title-text-transform',
	'typography_sidebar_title_letter_spacing' => '--ayyash-sidebar-widget-title-letter-spacing',
	'typography_sidebar_title_word_spacing'   => '--ayyash-sidebar-widget-title-word-spacing',

	'typography_sidebar_body_font_family'     => '--ayyash-sidebar-widget-body-font-family',
	'typography_sidebar_body_font_variant'    => '--ayyash-sidebar-widget-body-font-weight',
	'typography_sidebar_body_font_size'       => '--ayyash-sidebar-widget-body-font-size',
	'typography_sidebar_body_line_height'     => '--ayyash-sidebar-widget-body-line-height',
	'typography_sidebar_body_text_transform'  => '--ayyash-sidebar-widget-body-text-transform',
	'typography_sidebar_body_letter_spacing'  => '--ayyash-sidebar-widget-body-letter-spacing',
	'typography_sidebar_body_word_spacing'    => '--ayyash-sidebar-widget-body-word-spacing',

	'typography_footer_title_font_family'     => '--ayyash-footer-widget-title-font-family',
	'typography_footer_title_font_variant'    => '--ayyash-footer-widget-title-font-weight',
	'typography_footer_title_font_size'       => '--ayyash-footer-widget-title-font-size',
	'typography_footer_title_line_height'     => '--ayyash-footer-widget-title-line-height',
	'typography_footer_title_text_transform'  => '--ayyash-footer-widget-title-text-transform',
	'typography_footer_title_letter_spacing'  => '--ayyash-footer-widget-title-letter-spacing',
	'typography_footer_title_word_spacing'    => '--ayyash-footer-widget-title-word-spacing',

	'typography_footer_body_font_family'      => '--ayyash-footer-widget-body-font-family',
	'typography_footer_body_font_variant'     => '--ayyash-footer-widget-body-font-weight',
	'typography_footer_body_font_size'        => '--ayyash-footer-widget-body-font-size',
	'typography_footer_body_line_height'      => '--ayyash-footer-widget-body-line-height',
	'typography_footer_body_text_transform'   => '--ayyash-footer-widget-body-text-transform',
	'typography_footer_body_letter_spacing'   => '--ayyash-footer-widget-body-letter-spacing',
	'typography_footer_body_word_spacing'     => '--ayyash-footer-widget-body-word-spacing',

	'typography_footer_text_font_family'      => '--ayyash-secondary-footer-font-family',
	'typography_footer_text_font_variant'     => '--ayyash-secondary-footer-font-weight',
	'typography_footer_text_font_size'        => '--ayyash-secondary-footer-font-size',
	'typography_footer_text_line_height'      => '--ayyash-secondary-footer-line-height',
	'typography_footer_text_text_transform'   => '--ayyash-secondary-footer-text-transform',
	'typography_footer_text_letter_spacing'   => '--ayyash-secondary-footer-letter-spacing',
	'typography_footer_text_word_spacing'     => '--ayyash-secondary-footer-word-spacing',

	'layout_wpcf7_top_padding'                => '--ayyash-wpcf7-padding-top',
	'layout_wpcf7_bottom_padding'             => '--ayyash-wpcf7-padding-bottom',
	'layout_wpcf7_left_padding'               => '--ayyash-wpcf7-padding-left',
	'layout_wpcf7_right_padding'              => '--ayyash-wpcf7-padding-right',
	'layout_wpcf7_border_radius'              => '--ayyash-wpcf7-border-radius',
	'layout_wpcf7_gap'                        => '--ayyash-wpcf7-gap',
	'layout_wpcf7_textarea_height'            => '--ayyash-wpcf7-textarea-height',
];

// End of file css-variable-mapping.php.
