<?php
/**
 * To remove core action with hook after_setup_theme
 *
 * @since 1.0.0
 * @version 1.0.0
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

add_action( 'after_setup_theme', 'ayyash_woocommerce_init' );
add_filter( 'init', 'ayyash_remove_wc_breadcrumbs' );
add_filter( 'loop_shop_columns', 'ayyash_loop_columns', 999 );
add_filter( 'loop_shop_per_page', 'ayyash_loop_shop_per_page', 20 );
add_filter( 'woocommerce_show_page_title', 'ayyash_wc_hide_page_title' );

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

add_action( 'woocommerce_archive_description', 'ayyash_wc_remove_result_count', 20 );
add_action( 'woocommerce_archive_description', 'ayyash_wc_remove_archive_short', 30 );
add_action( 'woocommerce_archive_description', 'ayyash_sidebar_archive_filter', 40 );

add_filter( 'woocommerce_add_to_cart_fragments', 'ayyash_iconic_cart_count_fragments' );
add_filter( 'woocommerce_add_to_cart_fragments', 'ayyash_mini_cart_fragments' );
add_filter( 'woocommerce_upsell_display_args', 'ayyash_wc_upsell_display_args' );
add_filter( 'woocommerce_output_related_products_args', 'ayyash_wc_related_products_limit' );
add_filter( 'woocommerce_cross_sells_total', 'ayyash_cart_cross_sell_total' );
add_filter( 'woocommerce_output_related_products_args', 'ayyash_change_number_related_products', 9999 );
add_filter( 'woocommerce_get_image_size_gallery_thumbnail', 'ayyash_wc_gallery_thumb_size' );
add_action( 'init', 'ayyash_cart_cross_sell_display' );
add_action( 'wp_body_open', 'ayyash_filter_backdrop_overlay' );
add_action( 'ayyash_header_mobile_menu', 'ayyash_filter_shop' );


/**
 * ----------------------------------------------------------------------
 * Theme Hook for the layout
 *----------------------------------------------------------------------*/
// before after markup for theme.
add_action( 'woocommerce_before_main_content', 'ayyash_woocommerce_before_main_content' );
add_action( 'woocommerce_after_main_content', 'ayyash_woocommerce_after_main_content' );
add_action( 'ayyash_woocommerce_show_product_loop_before_product_body', 'woocommerce_show_product_loop_sale_flash', 11 );
add_filter( 'ayyash_woocommerce_show_stock_product_loop_before_product_body', 'ayyash_woocommerce_new_badge', 100 );
add_action( 'woocommerce_before_sale_coundown', 'ayyash_sale_countdown_timer', 13 );
add_filter( 'woocommerce_product_get_rating_html', 'ayyash_filter_product_rating_html', 10, 1 );
add_filter( 'woocommerce_dropdown_variation_attribute_options_html', 'ayyash_variation_radio_buttons', 20, 2 );
add_filter( 'woocommerce_variation_is_active', 'ayyash_variation_check', 10, 2 );
add_filter( 'product_cat_class', 'product_cat_item_class' );
add_filter( 'woocommerce_product_loop_start', 'ayyash_product_loop_start' );

//Single product.
add_filter( 'woocommerce_sale_flash', '__return_null' );
add_action('woocommerce_before_single_product_summary', 'ayyash_get_product_discount', 11);
add_action('woocommerce_before_single_product_summary', 'ayyash_get_featured_badge', 12);
add_action( 'woocommerce_single_product_summary', 'ayyash_single_product_actions', 31 );
add_filter( 'woocommerce_account_menu_items', 'ayyash_remove_my_account_menu_items', 100, 1 );
add_action( 'woocommerce_share', 'ayyash_single_product_share' );

// Single Product Bootstrap.
add_action( 'woocommerce_before_single_product_summary', 'ayyash_before_single_product', 5 );
add_action( 'woocommerce_before_single_product_summary', 'ayyash_single_product_thumbnail_after', 999 );
add_action( 'woocommerce_after_single_product_summary', 'ayyash_single_product_content_after', 5 );
add_action( 'woocommerce_after_single_product_summary', 'ayyash_after_single_product', 999 );
add_filter( 'woocommerce_loop_add_to_cart_link', 'ayyash_add_cart_link' );


/**
 * ----------------------------------------------------------------------
 * My Account Content Title hook
 * ----------------------------------------------------------------------*/
add_action( 'woocommerce_before_my_account', 'ayyash_my_account_content_title' );
add_action( 'woocommerce_before_account_orders', 'ayyash_my_account_content_title' );
add_action( 'woocommerce_before_account_downloads', 'ayyash_my_account_content_title' );
add_action( 'woocommerce_before_edit_account_form', 'ayyash_my_account_content_title' );
add_action( 'woocommerce_before_edit_my_address', 'ayyash_my_account_content_title' );
add_filter( 'woocommerce_customer_get_downloadable_products', 'woocommerce_download_button_label' );
add_filter( 'woocommerce_order_get_downloadable_items', 'woocommerce_download_button_label' );

/** ----------------------------------------------------------------------
 * Ayyash Pro for WooCommerce
 * ----------------------------------------------------------------------*/
if ( ! class_exists( 'Ayyash_Pro' ) ) {
	add_filter( 'ayyash_product_loop_classes', 'ayyash_product_grid_class' );
	add_filter( 'ayyash_product_btn_classes', 'ayyash_product_add_to_cart_btn_styles' );
	add_filter( 'ayyash_product_btn_classes', 'ayyash_product_show_button_text_icon' );
}

/** ----------------------------------------------------------------------
 * Product labels hook
 * ----------------------------------------------------------------------*/
add_action( 'ayyash_shop_labels', 'ayyash_get_product_discount', 5 );
add_action( 'ayyash_shop_labels', 'ayyash_get_featured_badge', 10 );
add_action( 'ayyash_shop_labels', 'ayyash_get_product_badge', 15 );
add_action( 'ayyash_shop_labels', 'ayyash_display_sold_out_loop_woocommerce', 15 );

/** ----------------------------------------------------------------------
 * Product before title, title, after title hooks
 * ----------------------------------------------------------------------*/
add_action( 'ayyash_before_shop_title', 'ayyash_shop_header_open', 5 );
add_action( 'ayyash_before_shop_title', 'ayyash_shop_labels', 10 );
add_action( 'ayyash_before_shop_title', 'ayyash_shop_actions', 15 );
add_action( 'ayyash_before_shop_title', 'ayyash_shop_thumbnails', 20 );
add_action( 'ayyash_before_shop_title', 'ayyash_shop_header_close', 25 );
add_action( 'ayyash_before_shop_title', 'ayyash_shop_content_open', 30 );
add_action( 'ayyash_before_shop_title', 'ayyash_shop_category', 35 );

add_action( 'ayyash_shop_title', 'ayyash_shop_title', 10 );

add_action( 'ayyash_after_shop_title', 'ayyash_shop_price', 5 );
add_action( 'ayyash_after_shop_title', 'ayyash_shop_rating', 10 );
add_action( 'ayyash_after_shop_title', 'ayyash_shop_content_close', 15 );
add_action( 'ayyash_after_shop_title', 'ayyash_shop_footer_open', 20 );
add_action( 'ayyash_after_shop_title', 'ayyash_shop_cart_btn', 25 );
add_action( 'ayyash_after_shop_title', 'ayyash_shop_footer_close', 30 );

add_filter( 'ayyash_product_classes', 'ayyash_shop_footer_cart_wishlist_btn' );



// End of file ayyash-woocommerce-hook.php
