<?php
/**
 * WooCommerce Integrations.
 *
 * @package Ayyash
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

if ( ! function_exists( 'ayyash_wc_color_variation_attribute_options' ) ) :
	/**
	 * Color Variation Attribute Options
	 *
	 * @param array $args
	 * @return void
	 */
	function ayyash_wc_color_variation_attribute_options( $args = array() ) {
		$args = wp_parse_args(
			$args,
			array(
				'options'          => false,
				'attribute'        => false,
				'product'          => false,
				'selected'         => false,
				'name'             => '',
				'id'               => '',
				'class'            => '',
				'show_option_none' => esc_html__( 'Choose an option', 'ayyash' ),
			)
		);

		$options   = $args['options'];
		$product   = $args['product'];
		$attribute = $args['attribute'];
		$name      = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title( $attribute );
		$id        = $args['id'] ? $args['id'] : sanitize_title( $attribute ) . $product->get_id();
		$class     = $args['class'];

		if ( empty( $options ) && ! empty( $product ) && ! empty( $attribute ) ) {
			$attributes = $product->get_variation_attributes();
			$options    = $attributes[ $attribute ];
		}

		echo '<select id="' . esc_attr( $id ) . '" class="' . esc_attr( $class ) . ' hide" name="' . esc_attr( $name ) . '" data-attribute_name="attribute_' . esc_attr( sanitize_title( $attribute ) ) . '">';

		if ( $args['show_option_none'] ) {
			echo '<option value="">' . esc_html( $args['show_option_none'] ) . '</option>';
		}

		if ( ! empty( $options ) ) {
			if ( $product && taxonomy_exists( $attribute ) ) {
				// Get terms if this is a taxonomy - ordered. We need the names too.
				$terms = wc_get_product_terms( $product->get_id(), $attribute, array( 'fields' => 'all' ) );

				foreach ( $terms as $term ) {
					if ( in_array( $term->slug, $options ) ) {
						?>
						<option value="<?php esc_attr( $term->slug ); ?>"<?php selected( sanitize_title( $args['selected'] ), $term->slug ); ?>><?php echo apply_filters( 'woocommerce_variation_option_name', $term->name ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></option>
						<?php
					}
				}
			}
		}

		echo '</select>';

		echo '<ul class="list-inline variable-items-wrapper color-variable-wrapper color-variation">';
		if ( ! empty( $options ) ) {
			if ( $product && taxonomy_exists( $attribute ) ) {
				$terms = wc_get_product_terms( $product->get_id(), $attribute, array( 'fields' => 'all' ) );

				foreach ( $terms as $term ) {
					if ( in_array( $term->slug, $options ) ) {
						$get_term_meta  = get_term_meta( $term->term_id, 'color', true );
						$selected_class = ( sanitize_title( $args['selected'] ) == $term->slug ) ? 'selected' : '';
						if ( ! empty( $get_term_meta ) ) {
							?>
							<li  data-placement="top" class="variable-item color-variable-item color-variable-item-<?php echo esc_attr( $term->slug ); ?> <?php echo esc_attr( $selected_class ); ?>" data-value="<?php echo esc_attr( $term->slug ); ?>">
								<span class="v-color <?php echo esc_attr( $term->slug ); ?> " data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php /* translators: %s: Size Attribute Name for tooltip. */printf( esc_html__( 'Color: %s', 'ayyash' ), esc_html( $term->name ) ); ?>" style="background-color:<?php echo esc_attr( $get_term_meta ); ?>;"></span>
							</li>
						<?php } else { ?>
							<li data-placement="top" class="variable-item color-variable-item color-variable-item-<?php echo esc_attr( $term->slug ); ?> <?php echo esc_attr( $selected_class ); ?>" data-value="<?php echo esc_attr( $term->slug ); ?>" >
								<span class="v-color <?php echo esc_attr( $term->slug ); ?> " data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php /* translators: %s: Size Attribute Name for tooltip. */ printf( esc_html__( 'Color: %s', 'ayyash' ), esc_html( $term->name ) ); ?>" style="background-color:<?php echo esc_attr( $term->slug ); ?>;"></span>
							</li>
							<?php
						}
					}
				}
			}
		}
		echo '</ul>';
	}

endif;

if ( ! function_exists( 'ayyash_wc_size_variation_attribute_options' ) ) :
	/**
	 * Image Variation Attribute Options
	 *
	 * @param array $args
	 * @return void
	 */
	function ayyash_wc_size_variation_attribute_options( $args = array() ) {

		$args = wp_parse_args(
			$args,
			array(
				'options'          => false,
				'attribute'        => false,
				'product'          => false,
				'selected'         => false,
				'name'             => '',
				'id'               => '',
				'class'            => '',
				'show_option_none' => esc_html__( 'Choose an option', 'ayyash' ),
			)
		);

		$options   = $args['options'];
		$product   = $args['product'];
		$attribute = $args['attribute'];
		$name      = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title( $attribute );
		$id        = $args['id'] ? $args['id'] : sanitize_title( $attribute ) . $product->get_id();
		$class     = $args['class'];

		if ( empty( $options ) && ! empty( $product ) && ! empty( $attribute ) ) {
			$attributes = $product->get_variation_attributes();
			$options    = $attributes[ $attribute ];
		}

		echo '<select id="' . esc_attr( $id ) . '" class="' . esc_attr( $class ) . ' hide" name="' . esc_attr( $name ) . '" data-attribute_name="attribute_' . esc_attr( sanitize_title( $attribute ) ) . '">';

		if ( $args['show_option_none'] ) {
			echo '<option value="">' . esc_html( $args['show_option_none'] ) . '</option>';
		}

		if ( ! empty( $options ) ) {
			if ( $product && taxonomy_exists( $attribute ) ) {
				// Get terms if this is a taxonomy - ordered. We need the names too.
				$terms = wc_get_product_terms( $product->get_id(), $attribute, array( 'fields' => 'all' ) );

				foreach ( $terms as $term ) {
					if ( in_array( $term->slug, $options ) ) {
						?>
						<option value="<?php esc_attr( $term->slug ); ?>"<?php selected( sanitize_title( $args['selected'] ), $term->slug ); ?>><?php echo apply_filters( 'woocommerce_variation_option_name', $term->name ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></option>
						<?php
					}
				}
			}
		}

		echo '</select>';

		echo '<ul class="list-inline variable-items-wrapper image-variable-wrapper size-variation">';
		if ( ! empty( $options ) ) {
			if ( $product && taxonomy_exists( $attribute ) ) {
				$terms = wc_get_product_terms( $product->get_id(), $attribute, array( 'fields' => 'all' ) );

				foreach ( $terms as $term ) {
					if ( in_array( $term->slug, $options ) ) {
						$term_meta      = get_term_meta( $term->term_id, 'size', true );
						$selected_class = ( sanitize_title( $args['selected'] ) == $term->slug ) ? 'selected' : '';
						if ( ! empty( $term_meta ) ) {
							?>
								<li>
									<span class="v-size" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Size: S">S</span>
								</li>
							<li class="variable-item image-variable-item image-variable-item-<?php echo esc_attr( $term->slug ); ?> <?php echo esc_attr( $selected_class ); ?>" data-value="<?php echo esc_attr( $term->slug ); ?>">
								<span class="v-size" data-bs-toggle="tooltip" data-bs-placement="bottom" title="
								<?php
								/* translators: %s: Size Attribute Name for tooltip. */
								printf( esc_html__( 'Size: %s', 'ayyash' ), esc_html( $term->name ) );
								?>
								">
									<img alt="<?php echo esc_attr( $term->name ); ?>" src="<?php echo esc_url( $term_meta['url'] ); ?>">
								</span>
							</li>
						<?php } else { ?>
							<li class="variable-item image-variable-item image-variable-item-<?php echo esc_attr( $term->slug ); ?> <?php echo esc_attr( $selected_class ); ?>" data-value="<?php echo esc_attr( $term->slug ); ?>">
								<span class="v-size" data-bs-toggle="tooltip" data-bs-placement="bottom" title="
								<?php
								/* translators: %s: Size Attribute Name for tooltip. */
								printf( esc_html__( 'Size: %s', 'ayyash' ), esc_html( $term->name ) );
								?>
								"><?php echo esc_html( $term->name ); ?></span>
							</li>
							<?php
						}
					}
				}
			}
		}
		echo '</ul>';
	}
endif;

