<?php
/**
 * Sidebar Config.
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

if ( ! function_exists( 'ayyash_widgets_init' ) ) :

	/**
	 * Registering widget / sidebar for the theme
	 *
	 * @return void
	 */
	function ayyash_widgets_init() {

		// register Main sidebar widgets.
		register_sidebar(
			array(
				'name'          => __( 'Main Sidebar', 'ayyash' ),
				'id'            => 'main-sidebar',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => __( 'Shop Sidebar', 'ayyash' ),
				'id'            => 'shop-sidebar',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => __( 'Single Product Sidebar', 'ayyash' ),
				'id'            => 'single-product-sidebar',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => __( 'Cart Sidebar', 'ayyash' ),
				'id'            => 'cart-sidebar',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => __( 'Forum Sidebar', 'ayyash' ),
				'id'            => 'forum-sidebar',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => __( 'Sidebar 7', 'ayyash' ),
				'id'            => 'sidebar-7',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => __( 'Sidebar 8', 'ayyash' ),
				'id'            => 'sidebar-8',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => __( 'Sidebar 9', 'ayyash' ),
				'id'            => 'sidebar-9',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => __( 'Sidebar 10', 'ayyash' ),
				'id'            => 'sidebar-10',
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s sidebar-widget clearfix">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);


		// Register Footer Widgets.
		register_sidebar(
			array(
				'name'          => __( 'Footer Widget', 'ayyash' ),
				'id'            => 'footer-widget',
				'before_widget' => '<article class="footer-widget %2$s col-md-6 col-xm-12" id="%1$s">',
				'after_widget'  => "</article>\n",
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => "</h3>\n",
			)
		);

	}

endif;

add_action( 'widgets_init', 'ayyash_widgets_init' );
