<?php
/**
 * Theme info page
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/**
 * Add the theme page.
 *
 * @return void
 */
function ayyash_add_theme_info() {
	add_theme_page(
		__( 'Ayyash Theme Info', 'ayyash' ),
		__( 'Ayyash Info', 'ayyash' ),
		'manage_options',
		'ayyash-theme-info',
		'ayyash_info_page'
	);
}

add_action( 'admin_menu', 'ayyash_add_theme_info' );

/**
 * Ayyash Info page
 *
 * @return void
 */
function ayyash_info_page() {
	?>
	<div class="info-container">
		<h2 class="info-title"><?php esc_html_e( 'Ayyash Theme Information', 'ayyash' ); ?></h2>
		<div class="info-block">
			<a href="https://demo.ayyash.com/ayyash/" target="_blank">
				<div class="dashicons dashicons-desktop info-icon"></div>
				<p class="info-text"><?php esc_html_e( 'Theme Demo', 'ayyash' ); ?></p>
			</a>
		</div>
		<div class="info-block">
			<a href="https://docs.ayyash.com/themes/ayyash/" target="_blank">
				<div class="dashicons dashicons-book-alt info-icon"></div>
				<p class="info-text"><?php esc_html_e( 'Theme Documentation', 'ayyash' ); ?></p>
			</a>
		</div>
	</div>
	<?php
}
