<?php
/**
 * Load Core Files.
 *
 * @package Ayyash
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/** @define "AYYASH_THEME_DIR" "./../" */ // phpcs:ignore Generic.Commenting.DocComment.MissingShort

// phpcs:disable WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound

// Load customizer.
require AYYASH_THEME_DIR . 'inc/customizer/class-ayyash-customize.php';

// Load core theme files.
require AYYASH_THEME_DIR . 'inc/ayyash-tags.php';
//require AYYASH_THEME_DIR . 'inc/ayyash-info.php';
require AYYASH_THEME_DIR . 'inc/settings/class-ayyash-admin-options.php';
require AYYASH_THEME_DIR . 'inc/ayyash-helper-functions.php';
require AYYASH_THEME_DIR . 'inc/ayyash-hooks.php';
require AYYASH_THEME_DIR . 'inc/ayyash-hook-helper.php';
require AYYASH_THEME_DIR . 'inc/ayyash-register-widget.php';
require AYYASH_THEME_DIR . 'inc/class-ayyash-breadcrumb.php';

// Ayyash Social Share //TODO needs some work
//require AYYASH_THEME_DIR . 'inc/class-ayyash-social-share.php';

if ( ! class_exists( 'Ayyash_Pro' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/woocommerce/ayyash-wc-hook-helper-pro.php';
}
// Jetpack Compatibility
if ( class_exists( 'Jetpack' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/jetpack/jetpack.php';
}

// Elementor Related Options
if ( class_exists( 'Elementor\Plugin' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/elementor/class-ayyash-global-color.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/elementor/class-ayyash-global-typography.php';
}

// Dokan
if ( class_exists( 'WeDevs_Dokan' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/dokan/ayyash-dokan-hook-helper.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/dokan/ayyash-dokan-hook.php';
}

// Contact Form 7
if ( defined( 'WPCF7_PLUGIN' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/contact-form-7/ayyash-cf7-hook-helper.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/contact-form-7/ayyash-cf7-hook.php';
}

// WooCommerce & Related Addons.
if ( class_exists( 'WooCommerce' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/woocommerce/class-ayyash-woocommerce-shop.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/woocommerce/ayyash-wc-helper.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/woocommerce/ayyash-wc-hook-helper.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/woocommerce/ayyash-wc-hook.php';
}

// YITH WooCommerce Wishlist
if ( class_exists( 'WooCommerce' ) && defined( 'YITH_WCWL' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/yith-woocommerce-wishlist/ayyash-yith-wcwl-hook-helper.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/yith-woocommerce-wishlist/ayyash-yith-wcwl-hook.php';
}

// YITH WooCommerce Compare
if ( class_exists( 'WooCommerce' ) && defined( 'YITH_WOOCOMPARE' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/yith-woocommerce-compare/ayyash-yith-compare-hook-helper.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/yith-woocommerce-compare/ayyash-yith-compare-hook.php';
}

// YITH WooCommerce Quick View
if ( class_exists( 'WooCommerce' ) && defined( 'YITH_WCQV' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/yith-woocommerce-quick-view/ayyash-yith-wcqv-hook-helper.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/yith-woocommerce-quick-view/ayyash-yith-wcqv-hook.php';
}

// Size Chart Pro
if ( class_exists( 'WooCommerce' ) && class_exists( 'Size_Chart_Pro' ) ) {
	require AYYASH_THEME_DIR . 'inc/compatibility/size-chart-pro/ayyash-size-chart-pro-hook-helper.php';
	require AYYASH_THEME_DIR . 'inc/compatibility/size-chart-pro/ayyash-size-chart-pro-hook.php';
}


// Mega Menu Extension.
require AYYASH_THEME_DIR . 'inc/menu/menu.php';

// Header Button
require AYYASH_THEME_DIR . 'inc/ayyash-header-button.php';

function ayyash_asset_path( $path = '' ) {
	return AYYASH_THEME_DIR . 'assets/' . ltrim( rtrim( $path, '/\\' ), '/\\' );
}

function ayyash_asset_url( $path = '' ) {
	return AYYASH_THEME_URI . 'assets/' . ltrim( rtrim( $path, '/\\' ), '/\\' );
}

function ayyash_asset_version( $path ) {
	if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
		$asset = ayyash_asset_path( $path );

		if ( file_exists( $asset ) ) {
			return filemtime( $asset );
		}
	}

	return AYYASH_THEME_VERSION;
}

if ( ! function_exists( 'ayyash_scripts' ) ) {
	/**
	 * Enqueue scripts and styles.
	 *
	 * @return void
	 */
	function ayyash_scripts() {

		// Enqueue required styles.
		wp_enqueue_style( 'ayyash-bootstrap', ayyash_asset_url( 'plugins/bootstrap/css/bootstrap.min.css' ), [], ayyash_asset_version( 'plugins/bootstrap/css/bootstrap.min.css' ) );

		wp_enqueue_style( 'ayyash-themify-icons', ayyash_asset_url( 'plugins/themify-icons/themify-icons.css' ), [], ayyash_asset_version( 'plugins/themify-icons/themify-icons.css' ) );
		wp_enqueue_style( 'ayyash-fontawesome-icons', ayyash_asset_url( 'plugins/fontawesome/css/fontawesome.min.css' ), [], ayyash_asset_version( 'plugins/fontawesome/css/fontawesome.min.css' ) );
		wp_enqueue_style( 'ayyash-plyr', ayyash_asset_url( 'plugins/plyr/plyr.min.css' ), [], ayyash_asset_version( 'plugins/plyr/plyr.min.css' ) );
		wp_enqueue_style( 'ayyash-slick-slider', ayyash_asset_url( 'plugins/slick/slick.css' ), [], ayyash_asset_version( 'plugins/slick/slick.css' ) );
		wp_enqueue_style( 'ayyash-main', ayyash_asset_url( 'dist/css/ayyash_main.css' ), [], ayyash_asset_version( 'dist/css/ayyash_main.css' ) );
		wp_enqueue_style( 'ayyash-absolute-addons', ayyash_asset_url( 'dist/css/absolute-addons.css' ), [], ayyash_asset_version( 'dist/css/absolute-addons.css' ) );

		if ( class_exists( 'WeDevs_Dokan' ) ) {
			wp_enqueue_style( 'ayyash-dokan', ayyash_asset_url( 'dist/css/dokan.css' ), [], ayyash_asset_version( 'dist/css/dokan.css' ) );
		}

		if ( 1 === (int) ayyash_get_mod( 'preload_enable' ) ) {
			wp_enqueue_style( 'ayyash-animate-css', ayyash_asset_url( 'dist/css/animate.css' ), [], ayyash_asset_version( 'dist/css/animate.css' ) );
		}

		if ( is_page_template('ayyash-home.php') ) {
			wp_enqueue_style( 'ayyash-home-page', ayyash_asset_url( 'dist/css/ayyash-home.css' ), [], ayyash_asset_version( 'dist/css/ayyash-home.css' ) );
		}

		if ( is_page_template( 'template-starter.php' ) ) {
			wp_enqueue_style( 'ayyash-starter-content', ayyash_asset_url( 'dist/css/ayyash-starter.css' ), [], ayyash_asset_version( 'dist/css/ayyash-starter.css' ) );
		}

		if ( class_exists( 'WooCommerce' ) ) {
			wp_enqueue_style( 'ayyash-woocommerce', ayyash_asset_url( 'dist/css/woocommerce.css' ), [], ayyash_asset_version( 'dist/css/woocommerce.css' ) );
		}

		if ( class_exists( 'WPCF7_ContactForm' ) ) {
			wp_enqueue_style( 'ayyash-wpcf7', ayyash_asset_url( 'dist/css/wpcf7.css' ), [], ayyash_asset_version( 'dist/css/wpcf7.css' ) );
		}

		// Enqueue Base jQuery From WordPress Core
		wp_enqueue_script( 'jquery' );

		// Enqueue required scripts.
		wp_enqueue_script( 'ayyash-jquery-easing', ayyash_asset_url( 'plugins/jquery-easing/jquery.easing.min.js' ), [ 'jquery' ], ayyash_asset_version( 'plugins/jquery-easing/jquery.easing.min.js' ), true );

		if ( ayyash_get_mod( 'smoothscroll' ) ) {
			wp_enqueue_script( 'ayyash-smoothscroll', ayyash_asset_url( 'plugins/smoothscroll/SmoothScroll.min.js' ), [], ayyash_asset_version( 'plugins/smoothscroll/SmoothScroll.min.js' ), true );
		}

		wp_enqueue_script( 'jquery-masonry' );

		wp_enqueue_script( 'ayyash-lazyLoad', ayyash_asset_url( 'plugins/lazyLoad/jquery.lazy.min.js' ), [ 'jquery' ], ayyash_asset_version( 'plugins/lazyLoad/jquery.lazy.min.js' ), true );

		wp_enqueue_script( 'ayyash-bootstrap', ayyash_asset_url( 'plugins/bootstrap/js/bootstrap.bundle.min.js' ), [ 'jquery' ], ayyash_asset_version( 'plugins/bootstrap/js/bootstrap.bundle.min.js' ), true );

		wp_enqueue_script( 'ayyash-plyr', ayyash_asset_url( 'plugins/plyr/plyr.min.js' ), [], ayyash_asset_version( 'plugins/plyr/plyr.min.js' ), true );

		wp_enqueue_script( 'ayyash-waypoints', ayyash_asset_url( 'plugins/waypoints/waypoints.min.js' ), [ 'jquery' ], ayyash_asset_version( 'plugins/waypoints/waypoints.min.js' ), true );
		wp_enqueue_script( 'ayyash-counterup', ayyash_asset_url( 'plugins/counterup/counterup.min.js' ), [ 'jquery' ], ayyash_asset_version( 'plugins/counterup/counterup.min.js' ), true );

		// Slick Slider
		wp_enqueue_script( 'ayyash-slick-slider', ayyash_asset_url( 'plugins/slick/slick.min.js' ), [ 'jquery' ], ayyash_asset_version( 'plugins/slick/slick.min.js' ), true );

		wp_enqueue_script( 'superfish', ayyash_asset_url( 'dist/js/superfish.js' ), [ 'jquery', 'hoverIntent' ], ayyash_asset_version( 'dist/js/superfish.js' ), true );

		wp_enqueue_script( 'ayyash-main', ayyash_asset_url( 'dist/js/ayyash.js' ), [ 'superfish', 'jquery', 'wp-util' ], ayyash_asset_version( 'dist/js/ayyash.js' ), true );

		wp_enqueue_script( 'site-script', ayyash_asset_url( 'dist/js/scripts.js' ), [ 'ayyash-main', 'jquery-masonry' ], ayyash_asset_version( 'dist/js/scripts.js' ), true );

		// YITH  helper.
		if ( class_exists( 'YITH_WCQV' ) || class_exists( 'YITH_Woocompare' ) || defined( 'YITH_WCWL' ) ) {
			wp_enqueue_script( 'ayyash-yith-frontend-helper', ayyash_asset_url('dist/js/yith-frontend-helper.js' ), [ 'jquery' ], ayyash_asset_version('dist/js/yith-frontend-helper.js'), true );
		}

		$sticky_viewport = ayyash_get_mod( 'layout_header_menu_mobileshow' );

		switch ( $sticky_viewport ) {
			case 'sm':
				$sticky_viewport_size = '576';
				break;
			case 'md':
				$sticky_viewport_size = '991';
				break;
			case 'lg':
			case 'xl':
				$sticky_viewport_size = '1201';
				break;
			default:
				$sticky_viewport_size = '768';
				break;
		}

		wp_localize_script(
			'ayyash-main',
			'ayyash_ajax',
			[
				'ajaxurl'             => admin_url( 'admin-ajax.php' ),
				'siteurl'             => home_url(),
				'error'               => __( 'Error!', 'ayyash' ),
				'nonce'               => wp_create_nonce( 'ayyash-nonce' ),
				'viewport'            => $sticky_viewport_size,
				'sticky'              => ayyash_get_mod( 'layout_header_sticky' ),
				'header'              => ayyash_get_mod( 'layout_header_sticky_height' ),
				'accent'              => ( ayyash_get_mod( 'skin' ) !== 'default' ) ? ayyash_get_mod( 'accent_color' ) : '#428bca',
				'no_smoothscroll'     => ( ayyash_get_mod( 'smoothscroll' ) ) ? '1' : '0',
				'post_id'             => get_the_ID(),
				'related_post_slider' => [
					'slidesToShow' => ayyash_get_mod('layout_related_post_column'),
					'arrows'       => (bool) ayyash_get_mod('layout_related_post_slider_enable_arrow'),
					'dots'         => (bool) ayyash_get_mod('layout_related_post_slider_enable_dots'),
					'autoplay'     => (bool) ayyash_get_mod('layout_related_post_slider_enable_autoplay'),
					'prevArrow'    => '<button class="slick-prev slick-arrow" aria-label="Previous" type="button"><i class="ai ai-arrow-long-left"></button>',
					'nextArrow'    => '<button class="slick-next slick-arrow" aria-label="Next" type="button"><i class="ai ai-arrow-long-right"></button>',
					'responsive'   => [
						(object) [
							'breakpoint' => 768,
							'settings'   => [
								'slidesToShow' => 1,
							],
						],
					],
				],
			]
		);
	}
}

add_action( 'wp_enqueue_scripts', 'ayyash_scripts' );


/**
 * Enqueue Block Editor Styles
 *
 * @return void
 */
function ayyash_action_enqueue_block_editor_assets() {
	wp_enqueue_style( 'ayyash-icons', ayyash_asset_url( 'dist/css/ayyash-icons.css' ), [], ayyash_asset_version( 'dist/css/ayyash-icons.css' ) );
	wp_enqueue_style( 'ayyash-themify-icons', ayyash_asset_url( 'plugins/themify-icons/themify-icons.css' ), [], ayyash_asset_version( 'plugins/themify-icons/themify-icons.css' ) );
	wp_enqueue_style( 'ayyash-fontawesome-icons', ayyash_asset_url( 'plugins/fontawesome/css/fontawesome.min.css' ), [], ayyash_asset_version( 'plugins/fontawesome/css/fontawesome.min.css' ) );
	wp_enqueue_style( 'ayyash-gutenberg-editor', ayyash_asset_url( 'dist/css/gutenberg-editor-custom.css' ), [], ayyash_asset_version( 'dist/css/gutenberg-editor-custom.css' ) );
}

add_action( 'enqueue_block_editor_assets', 'ayyash_action_enqueue_block_editor_assets' );

// Enqueue editor blocks styles.
//add_editor_style( AYYASH_THEME_URI . 'assets/dist/css/gutenberg-editor-custom.css' );//@todo editor block styles

// Enqueue editor styles.
add_editor_style( AYYASH_THEME_URI . 'assets/dist/css/style-editor.css');//@todo editor global style


if ( ! function_exists( 'ayyash_admin_scripts' ) ) {
	/**
	 * Enqueue Admin scripts and styles.
	 *
	 * @param string $hook admin page hook.
	 *
	 * @return void
	 */
	function ayyash_admin_scripts( $hook ) {
		wp_enqueue_style( 'ayyash-icons', ayyash_asset_url( 'dist/css/ayyash-icons.css' ), [], ayyash_asset_version( 'dist/css/ayyash-icons.css' ) );

		wp_enqueue_style( 'ayyash-themify-icons', ayyash_asset_url( 'plugins/themify-icons/themify-icons.css' ), [], ayyash_asset_version( 'plugins/themify-icons/themify-icons.css' ) );
		wp_enqueue_style( 'ayyash-fontawesome-icons', ayyash_asset_url( 'plugins/fontawesome/css/fontawesome.min.css' ), [], ayyash_asset_version( 'plugins/fontawesome/css/fontawesome.min.css' ) );

		// Admin & Customizer.
		wp_enqueue_style( 'ayyash-admin', ayyash_asset_url( 'dist/css/admin.css' ), [], ayyash_asset_version( 'dist/css/admin.css' ) );

		// Mega Menu Editor.
		wp_enqueue_style( 'ayyash-mega-menu', ayyash_asset_url( 'dist/css/edit-mega-menu.css' ), [], ayyash_asset_version( 'dist/css/edit-mega-menu.css' ) );
		wp_enqueue_script( 'ayyash-mega-menu', ayyash_asset_url( 'dist/js/edit-mega-menu.js' ), [ 'jquery', 'jquery-ui-dialog' ], ayyash_asset_version( 'dist/js/edit-mega-menu.js' ), true );
		wp_enqueue_script( 'wp-codemirror' );

		// YITH  helper.
		wp_enqueue_script( 'ayyash-yith-admin-helper', AYYASH_THEME_URI . 'assets/dist/js/yith-admin-helper.js', [ 'jquery', 'yith-wcwl-admin' ], AYYASH_THEME_VERSION, true );

		if ( in_array( $hook, [ 'post-new.php', 'post.php' ], true ) ) {
			// Enqueue required scripts.
			wp_enqueue_script( 'ayyash-admin', ayyash_asset_url( 'dist/js/admin.js' ), [], ayyash_asset_version( 'dist/js/admin.js' ), true );
		}
	}
}

add_action( 'admin_enqueue_scripts', 'ayyash_admin_scripts' );

// End of file ayyash-include.php
