<?php
/**
 * Default Hooks.
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

add_action( 'wp_head', 'ayyash_pingback_header', 3 );
add_action( 'wp_footer', 'ayyash_supports_js', - 1 );
add_action( 'wp_head', 'ayyash_preloader' );
add_filter( 'body_class', 'ayyash_body_classes' );
add_filter( 'post_class', 'ayyash_post_classes' );
add_filter( 'wp_kses_allowed_html', 'ayyash_allow_tags' );
add_action( 'ayyash_before_content_loop_layout', 'ayyash_grid_loop_layout_start' );
add_action( 'ayyash_after_content_loop_layout', 'ayyash_grid_loop_layout_end' );
add_filter( 'excerpt_length', 'ayyash_custom_excerpt_length', 999 );
add_action( 'comment_form_before_fields', 'ayyash_commentfields_rowtag' );
add_action( 'comment_form_after_fields', 'ayyash_commentfields_rowtag_end' );
add_action( 'cancel_comment_reply_link', 'ayyash_cancel_comment_reply_link' );
add_action( 'edit_category', 'ayyash_category_transient_flusher' );
add_action( 'save_post', 'ayyash_category_transient_flusher' );
add_action( 'wp_body_open', 'ayyash_mobile_backdrop_overlay' );

/**
 * ----------------------------------------------------------------------
 * Declaration of all header hook
 * ----------------------------------------------------------------------*/
add_action( 'wp_body_open', 'ayyash_skip_links', - 1 );
add_action( 'ayyash_header_secondary_header', 'ayyash_secondary_head' );
add_action( 'ayyash_header_master_header', 'ayyash_master_head' );
add_action( 'ayyash_header_mobile_menu_icon', 'ayyash_mobile_icon' );
add_action( 'ayyash_header_mobile_menu', 'ayyash_mobile_menu' );

/**
 * ----------------------------------------------------------------------
 * Single Page/Post Option hook
 * ----------------------------------------------------------------------*/
add_action( 'ayyash_single_option', 'ayyash_single_secondary_header' );
add_action( 'ayyash_single_option', 'ayyash_single_master_header' );

/**
 * ----------------------------------------------------------------------
 * Blog Homepage hook
 * ----------------------------------------------------------------------*/
add_action( 'ayyash_home_page_sections', 'ayyash_home_section_category_and_date', 1 );
add_action( 'ayyash_home_page_sections', 'ayyash_home_section_sticky_posts', 2 );
add_action( 'ayyash_home_page_sections', 'ayyash_home_section_blog_popular_and_latest_post_tab', 3 );
add_action( 'ayyash_home_page_sections', 'ayyash_home_section_blog_important_posts', 4 );
add_action( 'ayyash_home_page_sections', 'ayyash_home_section_blog_post_by_category', 5 );

/**
 * ----------------------------------------------------------------------
 * Declaration of all footer hook
 * ----------------------------------------------------------------------*/

add_action( 'ayyash_footer_contents', 'ayyash_render_footer_main', 50 );

// Secondary footer.
add_action( 'ayyash_footer_secondary_contents', 'ayyash_render_footer_social_icons' );
add_action( 'ayyash_footer_secondary_contents', 'ayyash_render_footer_menu', 20 );

// Credit Section
add_action( 'ayyash_footer_credit_contents', 'ayyash_render_footer_credits', 10 );
add_action( 'wp_footer', 'ayyash_render_go_to_top', - 1 );

// Disable mediaelement and use Plyr for audio & video shortcode.
add_filter( 'wp_audio_shortcode_library', 'ayyash_disable_mediaelement' );
add_filter( 'wp_video_shortcode_library', 'ayyash_disable_mediaelement' );
add_filter( 'shortcode_atts_gallery', 'ayyash_set_gallery_thumb_size' );

// Add Social icon link hook
add_action( 'show_user_profile', 'ayyash_extra_user_profile_fields' );
add_action( 'edit_user_profile', 'ayyash_extra_user_profile_fields' );
add_action( 'personal_options_update', 'ayyash_save_extra_user_profile_fields' );
add_action( 'edit_user_profile_update', 'ayyash_save_extra_user_profile_fields' );
