<?php
if ( ! function_exists( 'ayyash_header_button_layout' ) ) {

	function ayyash_header_button_layout() {
		$mobile_grid = ayyash_get_mod('layout_header_menu_mobileshow');
		switch ( $mobile_grid ) {
			case 'sm':
				$mobile_grid = 'd-none d-md-block';
				break;
			case 'md':
				$mobile_grid = ' d-none d-lg-block ';
				break;
			case 'lg':
				$mobile_grid = ' d-none d-xl-block';
				break;
			case 'xl':
				$mobile_grid = ' d-none';
				break;
			default:
				$mobile_grid = ' d-none d-md-block';
		}
		return $mobile_grid;
	}
}

if ( ! function_exists( 'ayyash_header_button' ) ) {
	/**
	 * Ayyash Header Button
	 *
	 * @return void
	 */
	function ayyash_header_button() {
		if ( ayyash_get_mod( 'layout_header_button' ) ) {
			?>
			<div class="ayyash-header-button <?php echo esc_attr( ayyash_header_button_layout() ); ?>">
				<a href="<?php echo esc_url( ayyash_get_mod('layout_header_button_url')); ?>">
					<?php echo wp_kses_post( ayyash_get_mod( 'layout_header_button_text' ) ); ?>
				</a>
			</div><!-- end .ayyash-header-menu-wrap -->
			<?php
		}
	}
}

if ( ! function_exists( 'ayyash_starter_header_button' ) ) {

	/**
	 * Ayyash Starter Header Button
	 *
	 * @return void
	 */
	function ayyash_starter_header_button() {
		?>
		<div class="ayyash-starter-header-button <?php echo esc_attr( ayyash_header_button_layout() ); ?>">
			<a href="<?php echo esc_url('https://wpayyash.com/starter-templates/' ); ?>">
				<?php esc_html_e('Make a Website', 'ayyash' ); ?>
			</a>
		</div><!-- end .ayyash-header-menu-wrap -->
		<?php
	}
}

