<?php
/**
 * The header.
 *
 * Displays all of the <head> section and everything up till end of </header>
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

?><!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>
<body <?php body_class( 'default-header' ); ?>>
<?php
wp_body_open();
/**
 * Custom action before page
 */
do_action( 'ayyash_before_page' );
?>
<div id="page" class="hfeed site">
<?php

/**
 * Custom section before main header
 */
do_action( 'ayyash_before_header' );

/**
 * Hooked ayyash_secondary_head
 */
do_action( 'ayyash_header_secondary_header' );

/**
 * Hooked ayyash_master_head
 */
do_action( 'ayyash_header_master_header' );

/**
 * Mobile Menu
 */

do_action( 'ayyash_header_mobile_menu' );

/**
 * Custom action after main header
 */

do_action( 'ayyash_after_header' );
