<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

$ayyash_view = ayyash_get_current_screen();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'ayyash-post' ); ?>>
	<div class="post-body-wrap">
		<header class="entry-header">
			<?php get_template_part( 'partials/content', 'sticky' ); ?>
			<?php ayyash_the_post_thumbnail( 'blog-normal', [ 'link' => false ] ); ?>
			<?php ayyash_post_tags( $ayyash_view ); ?>
			<?php ayyash_post_categories( $ayyash_view ); ?>
			<?php ayyash_the_title(); ?>
			<?php if ( 'post' === get_post_type() ) : ?>
				<div class="entry-meta">
					<?php ayyash_post_meta(); ?>
					<?php ayyash_post_reading_duration(); ?>
				</div><!-- .entry-meta -->
			<?php endif; ?>
		</header><!-- .entry-header -->
		<div class="entry-content">
			<?php the_content(); ?>
			<?php ayyash_link_pages(); ?>
		</div><!-- .entry-content -->
	</div><!-- .post-body-wrap -->
	<footer class="entry-footer">
		<?php do_action('ayyash_content_single_before_entry_footer_content'); ?>
		<?php ayyash_post_single_navigation(); ?>
		<?php ayyash_post_author_info(); ?>
		<?php ayyash_related_post(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
