<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

$ayyash_view = ayyash_get_current_screen();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'ayyash-post' ); ?>>
	<div class="page-body-wrap">
		<header class="entry-header">
			<?php if ( ! ayyash_get_mod( 'layout_' . $ayyash_view . '_ft-img-hide' ) && has_post_thumbnail() ) : ?>
				<div class="post-image effect slide-top" style="<?php echo esc_attr( ayyash_featured_image_width( $ayyash_view ) ); ?>">
					<?php ayyash_the_post_thumbnail( 'blog-normal', [ 'wrapper' => false ] ); ?>
					<div class="overlay">
						<div class="caption">
							<a href="<?php the_permalink(); ?>"><?php esc_html_e( 'View more', 'ayyash' ); ?></a>
						</div>
						<a href="<?php the_permalink(); ?>" class="expand"><i class="fa fa-plus"></i></a>
					</div>
				</div>
			<?php endif; ?>
			<?php ayyash_the_title(); ?>
		</header><!-- .entry-header -->
		<div class="entry-content">
			<?php the_content(); ?>
			<?php ayyash_link_pages(); ?>
		</div><!-- .entry-content -->
	</div><!-- .page-body-wrap -->
	<footer class="entry-footer single-edit clearfix">
		<?php ayyash_edit_post_link(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
