<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div id="comments" class="clearfix">
	<?php if ( have_comments() ) : ?>
		<div class="ayyash-section-heading post-comments-heading">
			<h2>
			<?php
			comments_number(
				__( 'No Comments', 'ayyash' ),
				__( 'One Comment', 'ayyash' ),
				__( '% Comments', 'ayyash' )
			);
			?>
			</h2>
		</div>
		<div class="comments-container">
			<ul class="comment-list">
				<?php wp_list_comments( array( 'callback' => 'ayyash_comments' ) ); ?>
			</ul>
		</div>
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
			<div class="pagination post-pagination clearfix">
				<?php previous_comments_link( __( 'Older Comments', 'ayyash' ) ); ?>
				<?php next_comments_link( __( 'Newer Comments', 'ayyash' ) ); ?>
			</div>
		<?php endif; ?>
	<?php elseif ( ! comments_open() && ! is_page() && get_post_type() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
		<p><?php esc_html_e( 'Comments are closed.', 'ayyash' ); ?></p>
	<?php endif; ?>

	<?php if ( comments_open() ) : ?>
		<?php
		$ayyash_commenter     = wp_get_current_commenter();
		$ayyash_req           = get_option( 'require_name_email' );
		$ayyash_aria_req      = ( $ayyash_req ? " aria-required='true'" : '' );
		$ayyash_fields        = array(
			'author'  => '<div class="col-md-6"><input type="text" placeholder="' . __( 'Name *', 'ayyash' ) . '" name="author" id="author" ' . $ayyash_aria_req . '></div>',
			'email'   => '<div class="col-md-6"><input type="email" placeholder="' . __( 'Email *', 'ayyash' ) . '" name="email" id="email" ' . $ayyash_aria_req . '></div>',
			'website' => '<div class="col-md-6"><input type="url" placeholder="' . __( 'Website *', 'ayyash' ) . '" name="url" id="url" ' . $ayyash_aria_req . '></div>',
			'subject' => '<div class="col-md-6"><input type="text" placeholder="' . __( 'Subject *', 'ayyash' ) . '" name="subject" id="subject" ' . $ayyash_aria_req . '></div>',
		);
		$ayyash_comments_args = array(
			'fields'              => $ayyash_fields,
			'comment_field'       => '<div class="col-md-12"><textarea name="comment" id="comment" placeholder="' . __( 'Enter your comments...', 'ayyash' ) . '"></textarea></div>',
			'id_form'             => 'post-comments-form',
			/* translators: %s: Author of the comment being replied to. */
			'title_reply_to'      => esc_html__( 'Reply to %s', 'ayyash' ),
			'title_reply_before'  => '<div id="reply-title" class="ayyash-section-heading comment-reply-title"><h2>',
			'title_reply_after'   => '</h2></div>',
			'cancel_reply_before' => ' <span class="cancel-reply">',
			'cancel_reply_link'   => '<i class="ai ai-close" aria-hidden="true"></i><span class="sr-only">' . esc_html__( 'Cancel reply', 'ayyash' ) . '</span>',
			'cancel_reply_after'  => '</span>',
		);
		comment_form( $ayyash_comments_args );
		?>
	<?php endif; ?>
</div>
