<?php
/**
 * Template Name: Ayyash Home Page
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}
$ayyash_view = ayyash_get_current_screen();

get_header();
?>
	<div id="content">
		<?php ayyash_title_bar( $ayyash_view ); ?>
		<div <?php ayyash_get_content_class(); ?>>
			<?php
			/**
			 * Custom action for Ayyash Home page
			 *
			 * @hooked ayyash_home_section_category_and_date - 1
			 * @hooked ayyash_home_section_sticky_posts - 2
			 * @hooked ayyash_home_section_blog_popular_and_latest_post_tab - 3
			 * @hooked ayyash_home_section_blog_must_read - 4
			 * @hooked ayyash_home_section_blog_post_by_category - 5
			 */
			do_action( 'ayyash_home_page_sections' );
			?>
		</div>
	</div>
<?php
get_footer();
