<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

get_header(); ?>
	<div id="content">
		<div class="ayyash-row site-content">
			<div class="<?php echo esc_attr( apply_filters( 'ayyash_content_container_class', ayyash_get_mod( 'layout_global_content_layout' ) ) ); ?>">
				<div class="row">
					<div id="primary" class="content-area col-md-12">
						<main id="main" class="site-main" role="main">
							<section class="error-404 not-found">
								<div class="error-page-img">
									<svg width="337" height="273" viewBox="0 0 337 273" fill="none" xmlns="http://www.w3.org/2000/svg">
										<g clip-path="url(#clip0_1000_1981)">
										<path d="M265.144 213.195L263.353 214.269L264.405 216.038C264.562 216.307 264.472 216.62 264.226 216.777C264.166 216.807 264.107 216.829 264.047 216.844C263.823 216.889 263.599 216.8 263.487 216.598L262.435 214.807L260.643 215.859C260.531 215.926 260.375 215.949 260.24 215.926C260.106 215.882 259.972 215.792 259.905 215.68C259.837 215.546 259.815 215.411 259.86 215.255C259.882 215.12 259.972 215.008 260.106 214.941L261.875 213.889L260.823 212.097C260.755 211.963 260.733 211.829 260.778 211.694C260.8 211.56 260.89 211.426 261.024 211.358C261.136 211.291 261.293 211.269 261.427 211.314C261.562 211.336 261.673 211.426 261.763 211.56L262.815 213.329L264.584 212.276C264.719 212.209 264.853 212.187 265.01 212.232C265.144 212.254 265.256 212.344 265.323 212.478C265.48 212.724 265.391 213.06 265.144 213.195Z" fill="#DEDEDE"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M269.846 224.279C268.548 224.279 267.518 223.226 267.518 221.927C267.518 220.651 268.548 219.599 269.846 219.599C271.145 219.599 272.198 220.651 272.198 221.927C272.198 223.226 271.145 224.279 269.846 224.279ZM269.846 220.853C269.242 220.853 268.749 221.323 268.749 221.927C268.749 222.532 269.242 223.025 269.846 223.025C270.451 223.025 270.944 222.532 270.944 221.927C270.944 221.323 270.451 220.853 269.846 220.853Z" fill="#DEDEDE"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M33.3419 258.65C32.0431 258.65 30.9907 257.598 30.9907 256.299C30.9907 255 32.0431 253.97 33.3419 253.97C34.6182 253.97 35.6707 255 35.6707 256.299C35.6707 257.598 34.6182 258.65 33.3419 258.65ZM33.3419 255.202C32.7373 255.202 32.2447 255.695 32.2447 256.299C32.2447 256.904 32.7373 257.396 33.3419 257.396C33.9465 257.396 34.4167 256.904 34.4167 256.299C34.4167 255.695 33.9465 255.202 33.3419 255.202Z" fill="#DEDEDE"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M292.641 6.82959C291.365 6.82959 290.312 5.77717 290.312 4.50082C290.312 3.20208 291.365 2.14966 292.641 2.14966C293.94 2.14966 294.992 3.20208 294.992 4.50082C294.992 5.77717 293.94 6.82959 292.641 6.82959ZM292.641 3.40361C292.037 3.40361 291.566 3.89624 291.566 4.50082C291.566 5.10541 292.037 5.57564 292.641 5.57564C293.246 5.57564 293.738 5.10541 293.738 4.50082C293.738 3.89624 293.246 3.40361 292.641 3.40361Z" fill="#DEDEDE"/>
										<path d="M333.439 66.3924L334.357 68.2509L336.216 67.3552C336.485 67.2209 336.798 67.3328 336.933 67.6015C336.962 67.6463 336.977 67.6986 336.977 67.7583C337.022 67.9822 336.91 68.2061 336.686 68.3181L334.828 69.2138L335.723 71.0723C335.791 71.2066 335.813 71.3634 335.768 71.4977C335.723 71.6321 335.611 71.7441 335.477 71.7888C335.365 71.856 335.208 71.8784 335.074 71.8336C334.94 71.7664 334.828 71.6769 334.761 71.5425L333.865 69.684L332.006 70.6021C331.872 70.6692 331.715 70.6692 331.581 70.6244C331.447 70.5797 331.335 70.4677 331.29 70.3557C331.223 70.2214 331.2 70.0646 331.245 69.9303C331.312 69.7959 331.402 69.684 331.536 69.6392L333.395 68.7211L332.477 66.8626C332.409 66.7282 332.409 66.5939 332.454 66.4595C332.499 66.3028 332.611 66.2132 332.723 66.146C332.992 66.0117 333.327 66.1236 333.439 66.3924Z" fill="#DEDEDE"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M298.889 110.706C297.612 110.706 296.56 109.654 296.56 108.355C296.56 107.079 297.612 106.026 298.889 106.026C300.188 106.026 301.24 107.079 301.24 108.355C301.24 109.654 300.188 110.706 298.889 110.706ZM298.889 107.28C298.307 107.28 297.814 107.773 297.814 108.355C297.814 108.96 298.307 109.452 298.889 109.452C299.493 109.452 299.986 108.96 299.986 108.355C299.986 107.773 299.493 107.28 298.889 107.28Z" fill="#DEDEDE"/>
										<path d="M1.05243 143.376L2.46312 144.876L3.98578 143.466C4.2097 143.264 4.54558 143.287 4.74711 143.488C4.79189 143.533 4.82175 143.585 4.83668 143.645C4.92625 143.846 4.88146 144.093 4.72472 144.249L3.20206 145.66L4.63515 147.183C4.72472 147.295 4.7695 147.429 4.7695 147.563C4.7695 147.72 4.70233 147.832 4.61276 147.944C4.5008 148.034 4.36644 148.101 4.2097 148.078C4.07535 148.078 3.941 148.011 3.85143 147.922L2.41834 146.399L0.918073 147.832C0.806113 147.922 0.671761 147.967 0.537409 147.967C0.380664 147.967 0.246312 147.899 0.156744 147.81C0.044784 147.698 0 147.563 0 147.407C0.022392 147.272 0.0671761 147.138 0.179136 147.048L1.6794 145.615L0.268704 144.115C0.179136 144.003 0.11196 143.869 0.134352 143.734C0.134352 143.578 0.201528 143.443 0.291096 143.354C0.515017 143.152 0.850897 143.152 1.05243 143.376Z" fill="#DEDEDE"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M23.377 169.104C22.0783 169.104 21.0259 168.052 21.0259 166.753C21.0259 165.455 22.0783 164.425 23.377 164.425C24.6534 164.425 25.7058 165.455 25.7058 166.753C25.7058 168.052 24.6534 169.104 23.377 169.104ZM23.377 165.656C22.7725 165.656 22.2798 166.149 22.2798 166.753C22.2798 167.358 22.7725 167.851 23.377 167.851C23.9816 167.851 24.4519 167.358 24.4519 166.753C24.4519 166.149 23.9816 165.656 23.377 165.656Z" fill="#DEDEDE"/>
										<path d="M63.6831 242.707C63.4368 242.707 63.2352 242.506 63.2129 242.259C63.1905 241.991 63.392 241.767 63.6607 241.744C65.2281 241.655 66.818 241.498 68.3854 241.274C68.6541 241.252 68.878 241.431 68.9228 241.677C68.9676 241.946 68.7885 242.192 68.5198 242.237C66.9299 242.461 65.3177 242.618 63.7055 242.707C63.7055 242.707 63.698 242.707 63.6831 242.707ZM56.9879 242.685C56.9729 242.685 56.958 242.685 56.9431 242.685C55.3533 242.573 53.741 242.416 52.1512 242.17C51.8825 242.125 51.7034 241.901 51.7481 241.632C51.7929 241.364 52.0392 241.185 52.2855 241.229C53.853 241.453 55.4428 241.632 57.0103 241.722C57.279 241.744 57.4805 241.968 57.4581 242.237C57.4357 242.483 57.2342 242.685 56.9879 242.685ZM75.0358 240.916C74.8119 240.916 74.6104 240.759 74.5656 240.558C74.4984 240.289 74.6552 240.042 74.9015 239.975C76.4241 239.572 77.9692 239.102 79.4471 238.565C79.6934 238.497 79.9621 238.609 80.0517 238.856C80.1412 239.102 80.0069 239.393 79.7606 239.483C78.2603 239.998 76.6929 240.49 75.1478 240.893C75.103 240.908 75.0657 240.916 75.0358 240.916ZM45.6575 240.804C45.6127 240.804 45.5679 240.796 45.5232 240.781C43.9781 240.356 42.4331 239.863 40.9328 239.304C40.6865 239.214 40.5521 238.945 40.6417 238.699C40.7313 238.453 41 238.318 41.2687 238.408C42.7465 238.968 44.2692 239.438 45.7919 239.863C46.0382 239.931 46.1949 240.199 46.1053 240.446C46.0606 240.669 45.859 240.804 45.6575 240.804ZM85.784 236.885C85.6049 236.885 85.4258 236.796 85.3586 236.617C85.2242 236.393 85.3362 236.102 85.5601 235.99C86.9708 235.295 88.3815 234.512 89.725 233.706C89.9489 233.571 90.24 233.638 90.3744 233.862C90.5087 234.086 90.4416 234.377 90.2176 234.512C88.8517 235.34 87.4186 236.124 85.9855 236.84C85.9109 236.87 85.8437 236.885 85.784 236.885ZM34.9541 236.661C34.8795 236.661 34.8048 236.646 34.7302 236.617C33.2971 235.9 31.8864 235.094 30.5205 234.243C30.2966 234.109 30.2294 233.818 30.3638 233.594C30.4981 233.37 30.7892 233.302 31.0131 233.437C32.3566 234.265 33.745 235.049 35.1556 235.766C35.402 235.878 35.4915 236.169 35.3796 236.415C35.29 236.572 35.1109 236.661 34.9541 236.661ZM95.4798 230.772C95.3454 230.772 95.2111 230.705 95.0991 230.593C94.9424 230.392 94.9871 230.078 95.1887 229.921C96.4426 228.958 97.6518 227.928 98.7938 226.854C98.9953 226.674 99.3088 226.674 99.4879 226.876C99.6671 227.055 99.6447 227.369 99.4432 227.548C98.2788 228.645 97.0472 229.697 95.7709 230.683C95.6813 230.75 95.5917 230.772 95.4798 230.772ZM25.2808 230.481C25.1688 230.481 25.0792 230.436 24.9897 230.369C23.7357 229.384 22.5042 228.309 21.3398 227.212C21.1382 227.033 21.1382 226.719 21.3174 226.54C21.4965 226.339 21.7876 226.339 21.9891 226.518C23.1311 227.593 24.3403 228.645 25.5719 229.63C25.7734 229.787 25.8182 230.078 25.6614 230.302C25.5719 230.414 25.4151 230.481 25.2808 230.481ZM103.765 222.823C103.653 222.823 103.541 222.801 103.451 222.711C103.25 222.554 103.227 222.241 103.407 222.039C104.414 220.853 105.399 219.576 106.318 218.3C106.474 218.076 106.765 218.031 106.989 218.188C107.191 218.345 107.258 218.636 107.101 218.86C106.161 220.158 105.176 221.435 104.123 222.666C104.034 222.778 103.899 222.823 103.765 222.823ZM17.0629 222.465C16.9285 222.465 16.7942 222.42 16.6822 222.308C15.6522 221.076 14.6669 219.778 13.7489 218.479C13.5921 218.255 13.6593 217.964 13.8608 217.807C14.0847 217.65 14.3758 217.718 14.5326 217.919C15.4283 219.218 16.4135 220.472 17.4212 221.681C17.6003 221.883 17.5555 222.196 17.354 222.353C17.2644 222.442 17.1748 222.465 17.0629 222.465ZM110.281 213.374C110.206 213.374 110.132 213.359 110.057 213.329C109.833 213.194 109.743 212.903 109.855 212.679C110.617 211.291 111.333 209.858 111.983 208.425C112.095 208.179 112.363 208.067 112.61 208.179C112.856 208.291 112.946 208.559 112.856 208.806C112.207 210.283 111.468 211.739 110.706 213.127C110.617 213.284 110.46 213.374 110.281 213.374ZM10.614 212.971C10.4348 212.971 10.2781 212.881 10.1885 212.724C9.42721 211.314 8.73305 209.858 8.08369 208.38C7.97172 208.134 8.08369 207.843 8.33 207.753C8.57631 207.641 8.86741 207.753 8.95697 208C9.58395 209.455 10.2781 210.888 11.0394 212.276C11.1514 212.5 11.0618 212.791 10.8379 212.926C10.7633 212.956 10.6886 212.971 10.614 212.971ZM114.782 202.827C114.737 202.827 114.685 202.819 114.625 202.805C114.379 202.715 114.244 202.446 114.311 202.2C114.782 200.7 115.207 199.155 115.543 197.61C115.588 197.341 115.857 197.184 116.103 197.251C116.349 197.296 116.528 197.565 116.461 197.811C116.125 199.379 115.7 200.946 115.23 202.491C115.162 202.693 114.983 202.827 114.782 202.827ZM6.22515 202.357C6.02362 202.357 5.82209 202.222 5.77731 202.021C5.30707 200.498 4.90402 198.908 4.59053 197.341C4.52335 197.095 4.70249 196.826 4.9488 196.781C5.21751 196.736 5.46382 196.893 5.5086 197.139C5.84448 198.707 6.22515 200.252 6.67299 201.752C6.76256 201.998 6.60581 202.267 6.3595 202.357C6.31472 202.357 6.26993 202.357 6.22515 202.357ZM117.043 191.564C117.028 191.564 117.013 191.564 116.999 191.564C116.73 191.541 116.551 191.295 116.573 191.049C116.73 189.481 116.819 187.869 116.819 186.302C116.842 186.033 117.043 185.809 117.312 185.831C117.581 185.831 117.782 186.055 117.782 186.302C117.76 187.914 117.67 189.526 117.514 191.138C117.491 191.385 117.29 191.564 117.043 191.564ZM4.05312 191.094C3.80681 191.094 3.60528 190.914 3.58289 190.668C3.42614 189.056 3.35897 187.444 3.35897 185.831C3.33658 185.563 3.5605 185.361 3.8292 185.361C4.09791 185.361 4.29943 185.563 4.29943 185.831C4.32183 187.399 4.389 189.011 4.52335 190.579C4.54575 190.847 4.36661 191.071 4.0979 191.094C4.08298 191.094 4.06805 191.094 4.05312 191.094ZM116.999 180.077C116.752 180.077 116.551 179.898 116.506 179.651C116.349 178.084 116.103 176.516 115.812 174.949V174.904C115.745 174.635 115.924 174.389 116.17 174.344C116.439 174.3 116.685 174.456 116.73 174.725L116.752 174.77C117.043 176.36 117.29 177.972 117.469 179.562C117.491 179.808 117.29 180.054 117.043 180.077C117.028 180.077 117.013 180.077 116.999 180.077ZM4.18747 179.606C4.17255 179.606 4.15762 179.606 4.14269 179.606C3.87398 179.584 3.67246 179.338 3.71724 179.091C3.89638 177.479 4.14269 175.889 4.45618 174.3C4.52335 174.053 4.76967 173.874 5.01598 173.941C5.28468 173.986 5.44143 174.232 5.39664 174.501C5.08315 176.046 4.83684 177.614 4.65771 179.181C4.63531 179.427 4.43379 179.606 4.18747 179.606ZM114.625 168.791C114.423 168.791 114.222 168.657 114.155 168.455C113.684 166.955 113.125 165.455 112.542 163.999C112.431 163.753 112.542 163.484 112.789 163.372C113.035 163.283 113.304 163.395 113.416 163.641C114.02 165.119 114.58 166.641 115.073 168.164C115.14 168.41 115.006 168.679 114.759 168.769C114.715 168.784 114.67 168.791 114.625 168.791ZM6.6506 168.388C6.59088 168.388 6.53864 168.381 6.49385 168.366C6.24754 168.298 6.11319 168.03 6.18036 167.761C6.69538 166.238 7.25518 164.716 7.88216 163.26C7.99412 163.014 8.26282 162.902 8.50913 162.992C8.75545 163.104 8.86741 163.372 8.75545 163.619C8.15086 165.074 7.59106 166.574 7.09844 168.075C7.03126 168.276 6.82973 168.388 6.6506 168.388ZM110.057 158.267C109.878 158.267 109.721 158.177 109.632 158.021C108.848 156.632 108.019 155.289 107.124 153.99C106.989 153.766 107.034 153.475 107.258 153.318C107.482 153.161 107.773 153.229 107.93 153.453C108.825 154.774 109.676 156.162 110.46 157.55C110.594 157.774 110.505 158.065 110.281 158.2C110.206 158.244 110.132 158.267 110.057 158.267ZM11.3081 157.909C11.2186 157.909 11.1365 157.886 11.0618 157.841C10.8379 157.707 10.7707 157.416 10.8827 157.192C11.6888 155.804 12.5621 154.415 13.4578 153.094C13.6145 152.893 13.9056 152.826 14.1295 152.982C14.3535 153.139 14.3982 153.43 14.2415 153.654C13.3458 154.953 12.4949 156.296 11.7112 157.662C11.6216 157.819 11.4649 157.909 11.3081 157.909ZM103.451 148.885C103.317 148.885 103.183 148.817 103.071 148.705C102.041 147.519 100.943 146.354 99.8238 145.257C99.6223 145.078 99.6223 144.787 99.8014 144.585C99.9806 144.406 100.294 144.406 100.473 144.585C101.638 145.705 102.757 146.869 103.81 148.101C103.966 148.28 103.944 148.593 103.742 148.773C103.653 148.84 103.541 148.885 103.451 148.885ZM17.981 148.571C17.869 148.571 17.757 148.526 17.6675 148.437C17.4659 148.28 17.4436 147.966 17.6227 147.765C18.6751 146.578 19.7947 145.391 20.9591 144.294C21.1382 144.093 21.4517 144.115 21.6309 144.294C21.81 144.496 21.81 144.787 21.6085 144.966C20.4889 146.063 19.3693 147.228 18.3392 148.414C18.2497 148.504 18.1153 148.571 17.981 148.571ZM95.0767 141.025C94.9871 141.025 94.8752 140.98 94.7856 140.913C93.5317 139.95 92.2329 139.054 90.8894 138.204C90.6879 138.047 90.6207 137.756 90.755 137.532C90.8894 137.308 91.1805 137.241 91.4044 137.397C92.7703 138.248 94.0915 139.189 95.3678 140.174C95.5693 140.331 95.6141 140.622 95.4574 140.823C95.3678 140.958 95.2111 141.025 95.0767 141.025ZM26.378 140.756C26.2436 140.756 26.0869 140.689 25.9973 140.577C25.8406 140.353 25.8853 140.062 26.0869 139.905C27.3856 138.92 28.7067 138.002 30.0727 137.151C30.2966 137.017 30.5877 137.084 30.722 137.308C30.8564 137.532 30.7892 137.823 30.5877 137.957C29.2442 138.808 27.923 139.704 26.6691 140.667C26.5795 140.734 26.4899 140.756 26.378 140.756ZM85.3138 135.002C85.2391 135.002 85.1645 134.979 85.0899 134.934C83.6792 134.263 82.2237 133.613 80.7458 133.053C80.4995 132.964 80.3651 132.673 80.4771 132.426C80.5667 132.18 80.8354 132.068 81.0817 132.158C82.582 132.74 84.0822 133.389 85.5153 134.083C85.7616 134.195 85.8512 134.486 85.7392 134.733C85.6497 134.89 85.4929 135.002 85.3138 135.002ZM36.1857 134.8C36.0289 134.8 35.8498 134.71 35.7602 134.531C35.6483 134.285 35.7602 134.016 35.9842 133.904C37.4396 133.21 38.9399 132.583 40.4402 132.001C40.6865 131.911 40.9552 132.046 41.0448 132.292C41.1343 132.538 41.0224 132.807 40.776 132.897C39.2982 133.456 37.8203 134.083 36.4096 134.755C36.335 134.785 36.2603 134.8 36.1857 134.8ZM74.5208 131.038C74.491 131.038 74.4537 131.038 74.4089 131.038C72.8862 130.635 71.3188 130.322 69.7513 130.053C69.505 130.008 69.3259 129.762 69.3707 129.515C69.4154 129.247 69.6618 129.068 69.9081 129.112C71.4979 129.381 73.0877 129.717 74.6328 130.098C74.9015 130.165 75.0582 130.434 74.9911 130.68C74.9239 130.904 74.7447 131.038 74.5208 131.038ZM47.001 130.949C46.7995 130.949 46.598 130.814 46.5532 130.59C46.486 130.344 46.6428 130.075 46.8891 130.008C47.8519 129.784 48.8148 129.583 49.7776 129.381C50.3822 129.269 51.0092 129.157 51.6362 129.068C51.8825 129.023 52.1288 129.202 52.1736 129.471C52.2184 129.717 52.0392 129.963 51.7705 130.008C51.1659 130.098 50.5614 130.21 49.9568 130.322C49.0163 130.501 48.0535 130.725 47.113 130.949C47.0831 130.949 47.0458 130.949 47.001 130.949ZM63.1681 129.359C63.1531 129.359 63.1457 129.359 63.1457 129.359C62.3172 129.314 61.4663 129.314 60.6378 129.314C59.8988 129.314 59.1375 129.314 58.3986 129.359C58.1299 129.359 57.9059 129.157 57.9059 128.888C57.8836 128.62 58.0851 128.418 58.3538 128.396C59.1151 128.373 59.8764 128.351 60.6378 128.351C61.4887 128.351 62.3396 128.373 63.1905 128.418C63.4592 128.418 63.6607 128.642 63.6383 128.911C63.6383 129.157 63.4144 129.359 63.1681 129.359Z" fill="#B7BCC4"/>
										<path d="M234.982 199.401C234.713 199.431 234.437 199.453 234.154 199.468C233.885 199.468 233.661 199.267 233.661 199.02C233.639 198.752 233.84 198.528 234.109 198.505C235.654 198.416 237.244 198.304 238.789 198.125C239.057 198.102 239.281 198.304 239.326 198.55C239.348 198.819 239.147 199.065 238.901 199.088C237.602 199.222 236.281 199.334 234.982 199.401ZM227.548 199.625C227.533 199.625 227.518 199.625 227.503 199.625C225.936 199.603 224.346 199.535 222.756 199.446C222.51 199.446 222.308 199.222 222.308 198.953C222.331 198.685 222.554 198.483 222.823 198.505C224.368 198.595 225.958 198.64 227.525 198.662C227.794 198.662 227.996 198.886 227.996 199.155C227.996 199.401 227.794 199.603 227.548 199.625ZM245.439 198.192C245.193 198.192 244.969 198.035 244.924 197.789C244.879 197.52 245.058 197.274 245.327 197.229C246.872 196.983 248.417 196.669 249.94 196.333C250.186 196.289 250.455 196.445 250.5 196.714C250.567 196.96 250.388 197.207 250.141 197.274C248.596 197.61 247.029 197.923 245.484 198.169C245.469 198.184 245.454 198.192 245.439 198.192ZM216.24 198.864C216.21 198.864 216.18 198.856 216.15 198.841C214.583 198.662 212.993 198.416 211.448 198.147C211.202 198.102 211.023 197.856 211.067 197.587C211.112 197.341 211.358 197.162 211.605 197.207C213.15 197.475 214.717 197.699 216.262 197.901C216.531 197.946 216.71 198.17 216.688 198.438C216.643 198.662 216.464 198.841 216.24 198.864ZM256.478 195.639C256.254 195.662 256.053 195.527 255.986 195.303C255.919 195.057 256.053 194.788 256.322 194.721C257.822 194.273 259.322 193.803 260.8 193.288C261.046 193.221 261.315 193.355 261.405 193.602C261.494 193.848 261.36 194.117 261.114 194.206C259.613 194.699 258.091 195.191 256.59 195.639C256.546 195.639 256.508 195.639 256.478 195.639ZM205.089 196.804C205.029 196.804 204.977 196.796 204.932 196.781C203.409 196.401 201.864 195.997 200.342 195.55C200.095 195.46 199.938 195.191 200.028 194.945C200.095 194.699 200.364 194.542 200.61 194.632C202.111 195.079 203.633 195.482 205.156 195.863C205.425 195.908 205.581 196.177 205.514 196.423C205.469 196.647 205.29 196.781 205.089 196.804ZM267.159 191.877C266.98 191.877 266.779 191.765 266.689 191.586C266.6 191.34 266.712 191.049 266.958 190.959C268.391 190.355 269.846 189.705 271.235 189.034C271.481 188.922 271.772 189.011 271.884 189.257C271.996 189.481 271.884 189.772 271.66 189.884C270.227 190.579 268.772 191.228 267.316 191.833C267.271 191.847 267.219 191.862 267.159 191.877ZM194.229 193.467C194.154 193.467 194.087 193.46 194.027 193.445C192.549 192.885 191.071 192.303 189.616 191.676C189.369 191.586 189.258 191.295 189.347 191.049C189.459 190.803 189.75 190.691 189.974 190.803C191.43 191.407 192.885 192.012 194.363 192.549C194.609 192.639 194.721 192.907 194.632 193.154C194.564 193.333 194.408 193.445 194.229 193.467ZM277.348 186.884C277.169 186.906 276.989 186.817 276.9 186.66C276.766 186.414 276.855 186.123 277.079 186.011C278.445 185.227 279.788 184.421 281.11 183.592C281.334 183.458 281.625 183.525 281.781 183.749C281.916 183.973 281.849 184.264 281.625 184.398C280.281 185.249 278.915 186.055 277.549 186.839C277.49 186.869 277.422 186.884 277.348 186.884ZM183.816 188.922C183.742 188.922 183.66 188.907 183.57 188.877C182.182 188.16 180.771 187.399 179.383 186.615C179.159 186.481 179.092 186.212 179.226 185.966C179.338 185.742 179.629 185.652 179.875 185.787C181.219 186.57 182.607 187.309 184.018 188.026C184.242 188.138 184.331 188.429 184.219 188.653C184.152 188.81 183.995 188.922 183.816 188.922ZM286.887 180.793C286.73 180.793 286.551 180.726 286.461 180.592C286.305 180.368 286.349 180.077 286.573 179.92C287.827 179.002 289.081 178.039 290.313 177.076C290.514 176.919 290.805 176.942 290.984 177.143C291.141 177.345 291.096 177.658 290.895 177.815C289.663 178.8 288.409 179.763 287.133 180.704C287.058 180.749 286.976 180.778 286.887 180.793ZM174.009 183.234C173.919 183.234 173.807 183.212 173.717 183.144C172.419 182.271 171.098 181.375 169.821 180.435C169.62 180.278 169.553 179.987 169.709 179.763C169.866 179.562 170.18 179.517 170.381 179.674C171.635 180.592 172.934 181.487 174.255 182.361C174.479 182.495 174.524 182.786 174.389 183.01C174.3 183.144 174.165 183.212 174.009 183.234ZM295.664 173.628C295.53 173.628 295.373 173.583 295.284 173.471C295.105 173.27 295.105 172.978 295.306 172.799C296.448 171.747 297.59 170.65 298.687 169.552C298.889 169.351 299.18 169.351 299.382 169.53C299.561 169.732 299.561 170.023 299.382 170.224C298.262 171.321 297.12 172.441 295.956 173.493C295.866 173.583 295.754 173.605 295.664 173.628ZM164.917 176.449C164.805 176.472 164.671 176.427 164.581 176.337C163.372 175.33 162.186 174.277 161.021 173.202C160.82 173.023 160.82 172.732 160.999 172.531C161.156 172.352 161.469 172.329 161.671 172.508C162.813 173.561 163.999 174.613 165.186 175.621C165.388 175.777 165.432 176.091 165.253 176.292C165.164 176.382 165.052 176.449 164.917 176.449ZM303.569 165.5C303.457 165.522 303.322 165.477 303.233 165.388C303.031 165.231 303.009 164.917 303.188 164.716C304.196 163.551 305.226 162.32 306.189 161.111C306.345 160.887 306.637 160.864 306.86 161.021C307.062 161.178 307.084 161.491 306.928 161.693C305.942 162.924 304.935 164.156 303.905 165.343C303.815 165.455 303.703 165.5 303.569 165.5ZM156.655 168.702C156.52 168.702 156.386 168.657 156.274 168.545C155.199 167.403 154.124 166.238 153.094 165.029C152.915 164.828 152.938 164.537 153.139 164.358C153.341 164.201 153.632 164.223 153.811 164.425C154.819 165.589 155.893 166.753 156.968 167.895C157.147 168.075 157.147 168.388 156.946 168.567C156.856 168.657 156.767 168.702 156.655 168.702ZM310.51 156.543C310.421 156.543 310.309 156.52 310.219 156.453C309.995 156.319 309.951 156.028 310.085 155.804C310.981 154.505 311.854 153.184 312.66 151.863C312.794 151.639 313.108 151.572 313.332 151.706C313.556 151.84 313.623 152.132 313.466 152.355C312.638 153.699 311.764 155.042 310.869 156.341C310.801 156.476 310.645 156.543 310.51 156.543ZM149.333 160.058C149.176 160.058 149.019 160.013 148.907 159.879C147.967 158.625 147.026 157.326 146.153 156.028C145.996 155.804 146.063 155.513 146.265 155.356C146.489 155.199 146.78 155.266 146.937 155.49C147.81 156.767 148.728 158.043 149.668 159.297C149.825 159.498 149.78 159.812 149.579 159.969C149.504 160.028 149.422 160.058 149.333 160.058ZM316.399 146.847C316.31 146.862 316.228 146.847 316.153 146.802C315.907 146.668 315.817 146.377 315.952 146.153C316.691 144.765 317.385 143.354 318.056 141.943C318.168 141.697 318.46 141.607 318.706 141.719C318.93 141.831 319.042 142.122 318.93 142.346C318.258 143.779 317.541 145.212 316.78 146.601C316.713 146.757 316.556 146.847 316.399 146.847ZM143.04 150.654C142.861 150.654 142.682 150.564 142.593 150.407C141.786 149.064 141.025 147.653 140.286 146.265C140.152 146.041 140.241 145.75 140.488 145.638C140.712 145.503 141.003 145.593 141.137 145.817C141.854 147.205 142.615 148.594 143.399 149.937C143.533 150.161 143.466 150.452 143.242 150.586C143.167 150.616 143.1 150.639 143.04 150.654ZM321.147 136.547C321.072 136.547 321.005 136.532 320.945 136.502C320.699 136.412 320.587 136.144 320.676 135.897C321.236 134.442 321.796 132.942 322.289 131.464C322.378 131.217 322.647 131.083 322.893 131.173C323.139 131.262 323.274 131.531 323.184 131.777C322.692 133.277 322.132 134.778 321.572 136.233C321.482 136.412 321.326 136.524 321.147 136.547ZM137.845 140.577C137.666 140.577 137.465 140.465 137.398 140.286C136.748 138.853 136.144 137.375 135.561 135.897C135.472 135.651 135.606 135.382 135.83 135.293C136.076 135.181 136.368 135.315 136.457 135.561C137.017 137.017 137.621 138.472 138.248 139.905C138.36 140.152 138.248 140.42 138.025 140.532C137.965 140.547 137.905 140.562 137.845 140.577ZM324.684 125.754C324.64 125.754 324.587 125.754 324.528 125.754C324.281 125.687 324.125 125.418 324.192 125.172C324.595 123.649 324.976 122.104 325.289 120.581C325.356 120.312 325.603 120.156 325.871 120.223C326.118 120.268 326.274 120.514 326.23 120.783C325.894 122.328 325.513 123.873 325.11 125.395C325.065 125.619 324.886 125.754 324.684 125.754ZM133.86 129.963C133.658 129.963 133.457 129.829 133.389 129.628C132.919 128.127 132.471 126.582 132.068 125.06C132.001 124.813 132.158 124.545 132.427 124.477C132.673 124.41 132.942 124.567 133.009 124.813C133.389 126.336 133.815 127.859 134.285 129.336C134.375 129.583 134.218 129.851 133.972 129.941C133.942 129.956 133.904 129.963 133.86 129.963ZM326.968 114.647C326.939 114.647 326.901 114.647 326.857 114.647C326.61 114.602 326.431 114.356 326.453 114.087C326.677 112.565 326.879 110.975 327.036 109.43C327.058 109.161 327.282 108.982 327.551 109.004C327.819 109.027 327.998 109.251 327.976 109.519C327.819 111.087 327.64 112.677 327.416 114.244C327.372 114.468 327.192 114.625 326.968 114.647ZM131.105 118.969C130.881 118.969 130.658 118.812 130.613 118.566C130.322 117.021 130.053 115.453 129.829 113.886C129.807 113.617 129.986 113.393 130.232 113.349C130.501 113.304 130.747 113.483 130.792 113.752C130.993 115.297 131.262 116.864 131.553 118.387C131.598 118.655 131.441 118.902 131.173 118.947C131.158 118.947 131.135 118.954 131.105 118.969ZM327.954 103.339C327.939 103.339 327.924 103.339 327.909 103.339C327.64 103.339 327.439 103.115 327.439 102.869C327.484 101.302 327.506 99.7118 327.461 98.1443C327.461 97.898 327.685 97.6741 327.931 97.6741C328.2 97.6741 328.424 97.8756 328.424 98.1443C328.446 99.7118 328.446 101.302 328.402 102.891C328.379 103.138 328.2 103.339 327.954 103.339ZM129.628 107.706C129.359 107.728 129.135 107.527 129.113 107.28C129.083 106.907 129.06 106.534 129.045 106.161C128.956 104.951 128.911 103.742 128.866 102.533C128.866 102.264 129.068 102.063 129.336 102.041C129.605 102.041 129.807 102.242 129.829 102.511C129.851 103.698 129.919 104.907 129.986 106.093C130.016 106.467 130.046 106.84 130.075 107.213C130.098 107.459 129.896 107.706 129.628 107.706ZM327.64 92.0089C327.372 92.0313 327.148 91.8298 327.125 91.5835C326.991 90.016 326.834 88.4486 326.633 86.9035L326.61 86.7468C326.565 86.5005 326.745 86.2542 327.013 86.2094C327.282 86.187 327.506 86.3661 327.551 86.6348L327.573 86.7692C327.775 88.3366 327.954 89.9264 328.088 91.4939C328.11 91.7626 327.909 91.9865 327.64 92.0089ZM129.404 96.3753C129.389 96.3753 129.374 96.3753 129.359 96.3753C129.09 96.3753 128.889 96.1514 128.911 95.8827C128.956 94.3153 129.068 92.7254 129.202 91.158C129.224 90.8893 129.448 90.6878 129.717 90.7102C129.986 90.7326 130.165 90.9565 130.143 91.2252C130.008 92.7926 129.919 94.3601 129.851 95.9275C129.851 96.1738 129.65 96.3753 129.404 96.3753ZM326.028 80.6338C325.782 80.6561 325.58 80.4994 325.513 80.2531C325.222 78.7304 324.864 77.1854 324.483 75.6627C324.416 75.4164 324.573 75.1477 324.841 75.0805C325.088 75.0357 325.356 75.1701 325.401 75.4388C325.804 76.9615 326.14 78.5289 326.453 80.074C326.498 80.3203 326.341 80.5666 326.073 80.6338C326.058 80.6338 326.043 80.6338 326.028 80.6338ZM130.501 85.0898C130.456 85.0898 130.419 85.0898 130.389 85.0898C130.12 85.045 129.941 84.7987 129.986 84.5524C130.232 82.9849 130.523 81.4175 130.837 79.85C130.881 79.6037 131.128 79.447 131.397 79.4918C131.643 79.5365 131.822 79.7829 131.755 80.0516C131.441 81.5742 131.173 83.1417 130.926 84.6867C130.904 84.9106 130.702 85.0898 130.501 85.0898ZM323.162 69.6617C322.938 69.6841 322.736 69.5497 322.669 69.3482C322.199 67.8479 321.684 66.3476 321.124 64.8922C321.035 64.6458 321.147 64.3771 321.393 64.2876C321.639 64.198 321.93 64.31 322.02 64.5563C322.58 66.0341 323.095 67.5344 323.587 69.0347C323.654 69.3034 323.52 69.5721 323.274 69.6393C323.229 69.6542 323.192 69.6617 323.162 69.6617ZM132.874 73.9833C132.815 73.9982 132.762 73.9982 132.718 73.9833C132.449 73.8938 132.315 73.6474 132.382 73.3787C132.807 71.8561 133.255 70.3334 133.748 68.8332C133.837 68.5868 134.106 68.4525 134.352 68.5197C134.599 68.6092 134.733 68.8779 134.666 69.1243C134.173 70.6245 133.703 72.1248 133.3 73.6474C133.233 73.849 133.076 73.9833 132.874 73.9833ZM319.064 59.0926C318.863 59.115 318.683 59.0031 318.594 58.8239C317.945 57.3908 317.25 55.9801 316.556 54.5918C316.422 54.3455 316.511 54.0544 316.758 53.9425C316.982 53.8305 317.273 53.9201 317.385 54.144C318.124 55.5547 318.818 56.9878 319.467 58.4209C319.579 58.6672 319.467 58.9359 319.221 59.0478C319.176 59.0777 319.124 59.0926 319.064 59.0926ZM136.502 63.2351C136.427 63.2351 136.36 63.2202 136.3 63.1904C136.054 63.1008 135.942 62.8321 136.032 62.5858C136.614 61.1079 137.263 59.6524 137.913 58.2193C138.025 57.973 138.316 57.8611 138.54 57.973C138.786 58.085 138.898 58.3761 138.786 58.6224C138.114 60.0331 137.487 61.4886 136.905 62.9441C136.838 63.1232 136.681 63.2128 136.502 63.2351ZM313.78 49.061C313.6 49.0834 313.444 48.9938 313.354 48.8371C312.548 47.5159 311.697 46.1724 310.824 44.8737C310.689 44.6722 310.734 44.3587 310.958 44.2243C311.182 44.0676 311.473 44.1348 311.608 44.3587C312.503 45.6574 313.354 47.0009 314.16 48.3444C314.295 48.5684 314.227 48.8595 314.003 48.9938C313.929 49.0386 313.854 49.061 313.78 49.061ZM141.339 52.9796C141.249 52.9796 141.167 52.9572 141.092 52.9124C140.846 52.7781 140.756 52.5094 140.891 52.2631C141.652 50.8747 142.436 49.4864 143.264 48.1429C143.399 47.919 143.69 47.8518 143.914 47.9862C144.138 48.1205 144.205 48.4116 144.07 48.6355C143.264 49.9791 142.481 51.345 141.719 52.7333C141.652 52.8676 141.495 52.9572 141.339 52.9796ZM307.398 39.7235C307.241 39.7235 307.084 39.6787 306.995 39.5444C306.032 38.3128 305.047 37.0813 304.039 35.8945C303.86 35.693 303.882 35.3795 304.084 35.2227C304.285 35.0436 304.576 35.066 304.756 35.2675C305.763 36.4767 306.771 37.7082 307.734 38.9622C307.89 39.1637 307.868 39.4548 307.644 39.634C307.57 39.6937 307.487 39.7235 307.398 39.7235ZM147.317 43.3286C147.205 43.3286 147.093 43.3062 147.004 43.2391C146.78 43.0823 146.735 42.7912 146.892 42.5673C147.787 41.291 148.75 39.9922 149.713 38.7607C149.87 38.5367 150.161 38.5144 150.385 38.6711C150.586 38.8278 150.631 39.1189 150.452 39.3429C149.512 40.5744 148.571 41.8508 147.676 43.1271C147.586 43.2391 147.452 43.3286 147.317 43.3286ZM299.986 31.1474C299.852 31.1698 299.695 31.125 299.605 31.013C298.508 29.8934 297.389 28.7962 296.247 27.7214C296.067 27.5423 296.045 27.2288 296.224 27.0496C296.403 26.8481 296.717 26.8481 296.896 27.0272C298.06 28.1021 299.18 29.2217 300.277 30.3413C300.479 30.5428 300.456 30.8339 300.277 31.013C300.188 31.1026 300.076 31.1474 299.986 31.1474ZM154.326 34.4166C154.214 34.439 154.08 34.3942 153.99 34.3046C153.789 34.1255 153.766 33.8344 153.945 33.6329C154.998 32.4461 156.073 31.2817 157.17 30.1621C157.349 29.9606 157.662 29.9606 157.841 30.1397C158.043 30.3189 158.043 30.6324 157.864 30.8115C156.767 31.9311 155.692 33.0955 154.662 34.2599C154.572 34.3718 154.46 34.4166 154.326 34.4166ZM291.634 23.4893C291.522 23.4893 291.388 23.4669 291.298 23.3773C290.089 22.3921 288.835 21.4068 287.581 20.4888C287.379 20.332 287.335 20.0409 287.491 19.817C287.648 19.6155 287.939 19.5707 288.163 19.7274C289.417 20.6679 290.693 21.6532 291.903 22.6384C292.104 22.8175 292.126 23.1086 291.97 23.3102C291.88 23.4221 291.768 23.4893 291.634 23.4893ZM162.32 26.3779C162.186 26.3779 162.029 26.3331 161.939 26.2211C161.76 26.0196 161.76 25.7285 161.962 25.5494C163.148 24.4969 164.358 23.4669 165.567 22.4593C165.768 22.3025 166.082 22.3249 166.239 22.5264C166.395 22.728 166.373 23.0415 166.171 23.1982C164.962 24.1835 163.753 25.2135 162.611 26.2659C162.521 26.3331 162.409 26.3779 162.32 26.3779ZM282.476 16.8165C282.364 16.8165 282.274 16.7941 282.184 16.7269C280.863 15.8984 279.52 15.0699 278.154 14.2862C277.93 14.1518 277.863 13.8607 277.997 13.6368C278.131 13.3905 278.423 13.3233 278.646 13.4577C280.012 14.2414 281.378 15.0699 282.699 15.9432C282.923 16.0775 282.968 16.3686 282.834 16.5926C282.744 16.7269 282.61 16.7941 282.476 16.8165ZM171.165 19.302C171.008 19.302 170.829 19.2348 170.739 19.1005C170.583 18.8765 170.627 18.5855 170.851 18.4287C172.128 17.5106 173.449 16.6373 174.77 15.7864C174.994 15.6297 175.285 15.6969 175.442 15.9208C175.576 16.1447 175.509 16.4358 175.285 16.5702C173.986 17.4211 172.665 18.2944 171.411 19.2124C171.336 19.2572 171.254 19.2871 171.165 19.302ZM272.601 11.2185C272.511 11.2185 272.429 11.2035 272.354 11.1737C270.966 10.4795 269.511 9.80778 268.1 9.1808C267.854 9.06884 267.742 8.80014 267.854 8.55382C267.943 8.30751 268.234 8.19555 268.48 8.30751C269.914 8.93449 271.369 9.60625 272.78 10.3004C273.026 10.4348 273.116 10.7035 273.004 10.9498C272.914 11.1065 272.757 11.1961 272.601 11.2185ZM180.749 13.2785C180.569 13.2785 180.39 13.189 180.301 13.0322C180.166 12.7859 180.256 12.5172 180.48 12.3829C181.868 11.6215 183.279 10.8826 184.69 10.1884C184.936 10.0765 185.227 10.166 185.339 10.4124C185.451 10.6363 185.361 10.9274 185.115 11.0393C183.727 11.7335 182.316 12.45 180.95 13.2114C180.875 13.2412 180.808 13.2636 180.749 13.2785ZM262.166 6.76246C262.091 6.77739 262.024 6.76992 261.964 6.74007C260.487 6.22505 258.986 5.71004 257.486 5.26219C257.24 5.17263 257.105 4.92631 257.173 4.65761C257.262 4.4113 257.531 4.27695 257.777 4.34412C259.277 4.81435 260.8 5.30698 262.278 5.84439C262.524 5.93396 262.659 6.20266 262.569 6.44897C262.502 6.6505 262.345 6.76246 262.166 6.76246ZM190.982 8.37469C190.78 8.39708 190.579 8.28512 190.511 8.08359C190.399 7.83728 190.511 7.56857 190.758 7.45661C192.213 6.87442 193.714 6.29223 195.191 5.77721C195.438 5.68764 195.729 5.822 195.818 6.06831C195.886 6.31462 195.774 6.58332 195.527 6.67289C194.049 7.18791 192.572 7.74771 191.116 8.35229C191.071 8.36722 191.026 8.37469 190.982 8.37469ZM251.261 3.5604C251.216 3.5604 251.171 3.55294 251.127 3.53801C249.604 3.17974 248.059 2.86625 246.514 2.57515C246.268 2.53037 246.088 2.28406 246.133 2.03774C246.178 1.76904 246.424 1.5899 246.693 1.63469C248.238 1.92578 249.806 2.26166 251.351 2.61994C251.597 2.68711 251.754 2.93342 251.709 3.17974C251.664 3.40366 251.463 3.53801 251.261 3.5604ZM201.685 4.70239C201.484 4.70239 201.26 4.56804 201.215 4.34412C201.125 4.09781 201.282 3.82911 201.528 3.76193C203.051 3.33648 204.596 2.93342 206.141 2.59754C206.387 2.53037 206.656 2.68711 206.701 2.93342C206.768 3.20213 206.611 3.44844 206.343 3.51562C204.82 3.87389 203.297 4.25455 201.797 4.68C201.767 4.69493 201.73 4.70239 201.685 4.70239ZM240.087 1.61229C240.058 1.61229 240.028 1.61229 239.998 1.61229C238.453 1.43316 236.885 1.29881 235.318 1.18685C235.049 1.16445 234.848 0.940534 234.87 0.67183C234.892 0.425517 235.116 0.223989 235.385 0.223989C236.953 0.335949 238.542 0.492693 240.11 0.67183C240.379 0.694222 240.558 0.940534 240.535 1.18685C240.513 1.43316 240.311 1.5899 240.087 1.61229ZM212.769 2.26166C212.523 2.26166 212.299 2.10492 212.254 1.85861C212.232 1.5899 212.388 1.34359 212.657 1.3212C213.62 1.16445 214.605 1.00771 215.591 0.873358C216.173 0.806182 216.777 0.739006 217.36 0.67183C217.628 0.627046 217.852 0.828574 217.897 1.07489C217.919 1.34359 217.74 1.5899 217.471 1.61229C216.889 1.67947 216.307 1.74665 215.725 1.83621C214.74 1.94817 213.777 2.10492 212.814 2.26166C212.799 2.26166 212.784 2.26166 212.769 2.26166ZM228.779 0.962926C228.765 0.962926 228.75 0.962926 228.735 0.962926C227.19 0.962926 225.6 1.00771 224.032 1.07489C223.764 1.09728 223.562 0.89575 223.54 0.627046C223.517 0.358341 223.719 0.134421 223.988 0.134421C225.577 0.044853 227.167 0.0224609 228.735 0.0224609C229.003 0.0224609 229.205 0.223989 229.205 0.492694C229.205 0.739006 229.026 0.940534 228.779 0.962926Z" fill="#B7BCC4"/>
										<path d="M244.431 59.2716V223.204H243.984L231.578 211.134L219.173 223.204H217.875L205.469 211.134L193.042 223.204H191.765L179.383 211.157L167 223.204H165.723L153.318 211.134L140.913 223.204H139.614L127.209 211.134L114.804 223.204H113.505L101.122 211.157L88.7397 223.204H87.9336V13.7039H198.864L244.431 59.2716Z" fill="var(--ayyash-color-primary)"/>
										<path d="M244.432 59.2716H198.864V13.7039L244.432 59.2716Z" fill="var(--ayyash-color-secondary)"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M130.053 144.54V138.427H113.505C111.415 138.427 109.848 137.95 108.803 136.994C107.758 136.054 107.235 134.77 107.235 133.143C107.235 132.725 107.31 132.299 107.459 131.867C107.609 131.449 107.84 131.001 108.153 130.523C108.467 130.045 108.788 129.59 109.116 129.157C109.445 128.724 109.848 128.187 110.325 127.545L127.791 104.168C128.941 102.63 129.881 101.518 130.613 100.831C131.359 100.13 132.247 99.7788 133.277 99.7788C136.621 99.7788 138.293 101.697 138.293 105.534V131.038H139.704C141.391 131.038 142.749 131.269 143.779 131.732C144.794 132.195 145.302 133.203 145.302 134.755C145.302 136.039 144.884 136.972 144.048 137.554C143.212 138.136 141.958 138.427 140.286 138.427H138.293V144.54C138.293 146.242 137.912 147.504 137.151 148.325C136.405 149.146 135.412 149.556 134.173 149.556C132.934 149.556 131.934 149.138 131.172 148.302C130.426 147.451 130.053 146.197 130.053 144.54ZM115.879 131.038H130.053V111.893L115.879 131.038Z" fill="white"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M183.436 125.037C183.436 128.635 183.219 131.732 182.786 134.33C182.338 136.927 181.525 139.278 180.346 141.383C178.853 143.981 176.92 145.981 174.546 147.384C172.173 148.788 169.538 149.489 166.642 149.489C163.298 149.489 160.297 148.549 157.64 146.668C154.998 144.772 153.005 142.152 151.661 138.808C150.99 136.987 150.49 134.972 150.161 132.762C149.848 130.553 149.691 128.165 149.691 125.597C149.691 122.283 149.863 119.297 150.206 116.64C150.564 113.983 151.117 111.691 151.863 109.766C153.162 106.616 155.043 104.205 157.506 102.533C159.984 100.876 162.94 100.048 166.373 100.048C168.627 100.048 170.68 100.421 172.531 101.167C174.382 101.899 176.002 102.974 177.39 104.392C178.793 105.81 179.972 107.564 180.928 109.654C182.6 113.266 183.436 118.394 183.436 125.037ZM174.412 124.388C174.412 120.357 174.173 117.066 173.695 114.513C173.203 111.945 172.389 110.012 171.254 108.713C170.105 107.4 168.523 106.743 166.507 106.743C163.596 106.743 161.574 108.206 160.439 111.132C159.319 114.058 158.76 118.558 158.76 124.634C158.76 128.769 158.999 132.158 159.476 134.8C159.954 137.427 160.768 139.42 161.917 140.779C163.066 142.122 164.619 142.794 166.575 142.794C168.59 142.794 170.172 142.092 171.322 140.689C172.456 139.286 173.255 137.278 173.718 134.666C174.18 132.053 174.412 128.627 174.412 124.388Z" fill="white"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M210.261 144.54V138.427H193.736C191.646 138.427 190.079 137.95 189.034 136.994C187.989 136.054 187.466 134.77 187.466 133.143C187.466 132.725 187.541 132.299 187.69 131.867C187.84 131.449 188.071 131.001 188.384 130.523C188.698 130.045 189.019 129.59 189.347 129.157C189.676 128.724 190.079 128.187 190.556 127.545L208.022 104.168C209.172 102.63 210.112 101.518 210.844 100.831C211.59 100.13 212.478 99.7788 213.508 99.7788C216.837 99.7788 218.509 101.697 218.524 105.534V131.038H219.935C221.622 131.038 222.98 131.269 224.01 131.732C225.025 132.195 225.533 133.203 225.533 134.755C225.533 136.039 225.115 136.972 224.279 137.554C223.443 138.136 222.189 138.427 220.517 138.427H218.524V144.54C218.509 146.242 218.128 147.504 217.382 148.325C216.636 149.146 215.635 149.556 214.382 149.556C213.157 149.556 212.165 149.138 211.403 148.302C210.642 147.451 210.261 146.197 210.261 144.54ZM196.11 131.038H210.261V111.893L196.11 131.038Z" fill="white"/>
										<path d="M164.962 271.324C162.813 273.474 159.297 273.474 157.147 271.324L123.627 237.803L119.372 233.549C122.485 231.511 125.149 228.846 127.187 225.756L164.962 263.532C167.112 265.681 167.112 269.174 164.962 271.324Z" fill="#9C9C9C"/>
										<path d="M128.889 227.436L137.621 236.169C135.561 239.281 132.919 241.946 129.807 243.983L125.328 239.505L121.074 235.251C124.186 233.213 126.828 230.548 128.889 227.436Z" fill="#5E5E5E"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M137.621 210.687C137.621 213.889 137.173 216.979 136.322 219.912C135.27 223.562 133.613 226.988 131.441 230.011C129.291 233.034 126.649 235.654 123.626 237.803C118.185 241.7 111.512 243.984 104.324 243.984C97.8754 243.984 91.8295 242.147 86.7241 238.968C85.9927 238.505 85.2761 238.02 84.5745 237.512C80.2976 234.333 76.8045 230.19 74.4309 225.353C72.7739 221.995 71.6767 218.322 71.2513 214.448C71.102 213.224 71.0273 211.97 71.0273 210.687C71.0273 192.303 85.9404 177.39 104.324 177.39C112.677 177.39 120.312 180.48 126.157 185.563C131.844 190.511 135.83 197.341 137.151 205.089C137.375 206.447 137.517 207.835 137.576 209.253C137.606 209.731 137.621 210.209 137.621 210.687ZM111.512 237.109C113.438 236.594 115.296 235.855 117.021 234.937C117.827 234.519 118.61 234.056 119.372 233.549C122.484 231.511 125.126 228.847 127.187 225.756C128.776 223.338 130.008 220.651 130.769 217.762C131.262 215.904 131.575 213.956 131.665 211.941C131.68 211.523 131.687 211.105 131.687 210.687C131.687 202.536 128.127 195.214 122.462 190.198C118.476 186.66 113.438 184.286 107.885 183.547C106.72 183.398 105.533 183.324 104.324 183.324C100.965 183.324 97.7634 183.928 94.8077 185.025C85.4926 188.474 78.5511 196.871 77.2075 207.014C77.0433 208.223 76.9612 209.448 76.9612 210.687C76.9612 214.001 77.5434 217.18 78.6182 220.114C80.5216 225.286 83.9028 229.72 88.2916 232.877C92.7924 236.146 98.3232 238.072 104.324 238.072C106.81 238.072 109.228 237.736 111.512 237.109Z" fill="#B8B8B8"/>
										<path d="M83.5893 213.71C82.1786 213.71 81.0366 212.568 81.0366 211.157C81.0366 204.798 83.4997 198.841 88.0005 194.363C92.4789 189.885 98.4352 187.421 104.772 187.421C106.183 187.421 107.325 188.563 107.325 189.974C107.325 191.385 106.183 192.527 104.772 192.527C99.8011 192.527 95.1212 194.452 91.6057 197.968C88.0901 201.506 86.142 206.164 86.142 211.157C86.142 212.568 85 213.71 83.5893 213.71Z" fill="white"/>
										</g>
										<defs>
										<clipPath id="clip0_1000_1981">
										<rect width="337" height="272.959" fill="white"/>
										</clipPath>
										</defs>
									</svg>
								</div><!-- .error-page-img -->
								<header class="entry-header">
									<h3 class="page-title"><?php esc_html_e( 'Oops! Page Not Found', 'ayyash' ); ?></h3>
								</header><!-- .entry-header -->
								<div class="entry-content">
									<p class="page-content"><?php esc_html_e( 'The page you are looking for was moved, removed, renamed or might never existed.', 'ayyash' ); ?></p>
								</div><!-- .entry-content -->
							</section><!-- .error-404 -->
						</main><!-- #main -->
					</div><!-- #primary -->
				</div><!-- .row -->
			</div><!-- .container -->
		</div>
	</div><!-- #content -->
<?php
get_footer();
