<?php

function avidnews_sanitize_select( $input, $setting ) {
	
	// Ensure input is a slug
	$input = sanitize_key( $input );
	
	// Get list of choices from the control
	// associated with the setting
	$choices = $setting->manager->get_control( $setting->id );
	
	// If the input is a valid key, return it;
	// otherwise, return the default
	return ( array_key_exists( $input, $choices->choices ) ? $input : $setting->default );
}



function avidnews_layout_customizer_settings( $wp_customize ){



	//INDEX POSTS STYLE
	$wp_customize->add_setting('avidnews_index_class_name_settings', array(
	    'default' => __('newsjolt-magazine-index', 'avidnews'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'avidnews_index_class_name_display_control', array(
	    'label'    => __('Avidnews - Change Style', 'avidnews'),
	    'section'  => 'newsjolt_magazine_index_class_name_section',
	    'settings' => 'avidnews_index_class_name_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'newsjolt-magazine-index' 		            => __('List Layout - Right Sidebar', 'avidnews'),
	    				'newsjolt-magazine-index-twenty-three' 		=> __('List (box shadow) - Two Columns Right Sidebar - Right Sidebar', 'avidnews'),
	    				'newsjolt-magazine-index-twenty-four' 		=> __('List (border) - Two Columns Right Sidebar - Right Sidebar', 'avidnews'),
	    			   )
	)));

	//CHANGE STYLE FEATURE SECTION
	$wp_customize->add_setting('avidnews_feature_change_style_settings', array(
	    'default' => __('newsjolt-magazine-feature-eighteen', 'avidnews'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));


	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'avidnews_feature_change_style_control', array(
	    'label'    => __('Avidnews - Change Style', 'avidnews'),
	    'section'  => 'newsjolt_magazine_feature_section',
	    'settings' => 'avidnews_feature_change_style_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'newsjolt-magazine-feature-eighteen' => __('Style 18 - ( IV Left side 2 Images 2 Right Images )', 'avidnews'),
	    				'newsjolt-magazine-feature-twenty-two' 		=> __('Style 22', 'avidnews'),
	    			   )
	)));




}


add_action('customize_register', 'avidnews_layout_customizer_settings');	