<?php 
/**
 * The default template for displaying content
 *
 * Used for both singular and index.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 */
?>
<div class="post post-full avadanta-corpo" id="post-<?php the_ID(); ?>">
	<div class="post-thumb">
		<?php if(has_post_thumbnail()) : ?>
		<a href="<?php the_permalink(); ?>">
			<?php the_post_thumbnail(); ?>
		</a>
		 <?php endif; ?>
	</div>
	<?php $avadanta_post_read_text = get_theme_mod('avadanta_post_read_text','Read More'); ?>
	<div class="post-entry d-sm-flex d-block align-items-start">
		<div class="post-content">
			<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
			<div class="post-author d-flex align-items-center avadanta-corpo-post">
				<div class="author-thumb">
					<?php echo get_avatar( get_the_author_meta('user_email'), $size = '50'); ?>
				</div>
				<div class="author-name">
					<?php avadanta_posted_by(); ?>
				</div>
				<div class="post-tag d-flex comment">
				<?php avadanta_get_comments_numbers(); ?>
				</div>
				<div class="post-tag d-flex date">
				<?php avadanta_posted_on(); ?>
				</div>

			</div>
			
			<div class="content">
					<?php
						the_excerpt();
					?>
			</div>
			<div class="post-tag d-flex readmre avata-corpo-btn">
				<a href="<?php the_permalink(); ?>"><?php echo esc_html($avadanta_post_read_text); ?>
				</a>
			</div>
		</div>
	</div>
</div><!-- .post -->