<?php
function avadanta_corporate_sections_settings( $wp_customize ) {
    $wp_customize->remove_setting( 'avadanta_menubar_bg_color' );
    $wp_customize->remove_setting( 'avadanta_menu_item_color' );
    $wp_customize->remove_setting( 'avadanta_menu_item_hover_color' );
    $wp_customize->remove_setting( 'avadanta_submenu_item_hover_color' );
    $wp_customize->remove_section( 'avadanta_site_settings' );
    $wp_customize->remove_section( 'avadanta_navigation_settings' );
    $wp_customize->remove_section( 'avadanta_bottom_footer_settings' );



    $wp_customize->add_setting('avadanta_post_read_text',   
        array(
            'sanitize_callback' => 'avadanta_sanitize_text',
            'default'           => __('Read More', 'avadanta-corporate'),
            ));

    $wp_customize->add_control('avadanta_post_read_text',
        array(
            'label'       => esc_html__('Read More Text', 'avadanta-corporate'),
            'section'     => 'avadanta_post_settings',
            'type'        => 'text',
        )
    );


            $wp_customize->add_setting('avadanta_theme_color_scheme',array(
        'default' => esc_html__('#f8194f','avadanta-corporate'),
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    
    $wp_customize->add_control(
        new WP_Customize_Color_Control($wp_customize,'avadanta_theme_color_scheme',array(
            'label' => esc_html__('Theme Color','avadanta-corporate'),           
            'description' => esc_html__('Change Theme Color','avadanta-corporate'),
            'section' => 'colors',
            'settings' => 'avadanta_theme_color_scheme'
        ))
    );



     $wp_customize->add_section('avadanta_bottom_footer1_settings',
        array(
            'priority'    => null,
            'title'       => esc_html__('Bottom Footer Options', 'avadanta-corporate'),
            'description' => '',
            'panel'       => 'section_settings',
        )
    );


$wp_customize->add_setting('avadanta_copyright_enable',
        array(
            'sanitize_callback' => 'avadanta_sanitize_checkbox',
            'default'           => 0,
        )
    );
    $wp_customize->add_control('avadanta_copyright_enable',
        array(
            'type'        => 'checkbox',
            'label'       => esc_html__('Disable Copyright Section?', 'avadanta-corporate'),
            'section'     => 'avadanta_bottom_footer1_settings',
            'description' => esc_html__('Check this box to Disable copyright section.', 'avadanta-corporate'),
        )
    );
    $wp_customize->add_setting('avadanta_copyright_text',   
        array(
            'sanitize_callback' => 'avadanta_sanitize_text',
            /* translators: %s: Copyright Text */
            'default'           => sprintf(__('Proudly powered by %1$s WordPress %3$s', "avadanta-corporate"),
                '<a href="https://wordpress.org/" target="_blank">',
                '<a href="" target="_blank">',
                '</a>'
            ),
        )
    );
    $wp_customize->add_control('avadanta_copyright_text',
        array(
            'label'       => esc_html__('Copyright Content Here', 'avadanta-corporate'),
            'section'     => 'avadanta_bottom_footer1_settings',
            'type'        => 'textarea',
        )
    );
    

}
add_action( 'customize_register', 'avadanta_corporate_sections_settings', 30);