<?php
/* Notifications in customizer */
require get_template_directory() . '/inc/customizer/customizer-notify.php';
$auramart_config_customizer = array(
	'recommended_plugins'       => array(
		'woocommerce' => array(
			'recommended' => true,
			'description' => sprintf(__('Install and activate <strong>WooCommerce</strong> plugin for taking full advantage of all the features this theme has to offer.', 'auramart')),
		)
	),
	'recommended_actions'       => array(),
	'recommended_actions_title' => esc_html__( 'Recommended Actions', 'auramart' ),
	'recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'auramart' ),
	'install_button_label'      => esc_html__( 'Install and Activate', 'auramart' ),
	'activate_button_label'     => esc_html__( 'Activate', 'auramart' ),
	'auramart_deactivate_button_label'   => esc_html__( 'Deactivate', 'auramart' ),
);
AuraMart_Customizer_Notify::init( apply_filters( 'auramart_customizer_notify_array', $auramart_config_customizer ) );



class auramart_import_dummy_data {

	private static $instance;

	public static function init( ) {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof auramart_import_dummy_data ) ) {
			self::$instance = new auramart_import_dummy_data;
			self::$instance->auramart_setup_actions();
		}

	}

	/**
	 * Setup the class props based on the config array.
	 */
	

	/**
	 * Setup the actions used for this class.
	 */
	public function auramart_setup_actions() {

		// Enqueue scripts
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'auramart_import_customize_scripts' ), 0 );

	}
	
	

	public function auramart_import_customize_scripts() {

	wp_enqueue_script( 'auramart-import-customizer-js', get_template_directory_uri() . '/inc/customizer/assets/js/import-customizer.js', array( 'customize-controls' ) );
	}
}

$auramart_import_customizers = array(

		'import_data' => array(
			'recommended' => true,
			
		),
);
auramart_import_dummy_data::init( apply_filters( 'auramart_import_customizer', $auramart_import_customizers ) );