<?php
function auramart_footer( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	// Footer Panel // 
	$wp_customize->add_panel( 
		'footer_section', 
		array(
			'priority'      => 34,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Footer', 'auramart'),
		) 
	);

	// Footer Setting Section // 
	$wp_customize->add_section(
        'footer_copy_Section',
        array(
            'title' 		=> __('Below Footer','auramart'),
			'panel'  		=> 'footer_section',
			'priority'      => 4,
		)
    );
	
	// Copyright
	$auramart_copyright = esc_html__('Copyright &copy; [current_year] [site_title] | Powered by [theme_author]', 'auramart' );
	$wp_customize->add_setting( 
		'footer_copyright' , 
			array(
			'default'	      => $auramart_copyright,
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'auramart_sanitize_html',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'footer_copyright', 
		array(
			'label'	      => esc_html__( 'Copyright', 'auramart' ),
			'section'     => 'footer_copy_Section',
			'type'        => 'textarea'
		) 
	);
	
}
add_action( 'customize_register', 'auramart_footer' );
// Footer selective refresh
function auramart_footer_partials( $wp_customize ){	
	// footer_copyright
	$wp_customize->selective_refresh->add_partial( 'footer_copyright', array(
		'selector'            => '.footer-copyright .copyright-text',
		'settings'            => 'footer_copyright',
		'render_callback'  => 'auramart_footer_copyright_render_callback',
	) );
	
	}
add_action( 'customize_register', 'auramart_footer_partials' );


// footer_copyright
function auramart_footer_copyright_render_callback() {
	return get_theme_mod( 'footer_copyright' );
}

