<?php
/**
 * AuraMart Theme Customizer.
 *
 * @package AuraMart
 */

 if ( ! class_exists( 'AuraMart_Customizer' ) ) {

	/**
	 * Customizer Loader
	 *
	 * @since 1.0.0
	 */
	class AuraMart_Customizer {

		/**
		 * Instance
		 *
		 * @access private
		 * @var object
		 */
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			/**
			 * Customizer
			 */
			 add_action( 'admin_enqueue_scripts',array( $this, 'auramart_admin_script' ) );
			add_action( 'customize_preview_init', array( $this, 'auramart_customize_preview_js' ) );
			add_action( 'customize_controls_enqueue_scripts',array( $this, 'auramart_customizer_script' ) );
			add_action( 'customize_register',array( $this, 'auramart_customizer_register' ) );
			add_action( 'after_setup_theme',array( $this, 'auramart_customizer_settings' ) );
		}
		
		/**
		 * Add postMessage support for site title and description for the Theme Customizer.
		 *
		 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
		 */
		function auramart_customizer_register( $wp_customize ) {
			
			$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
			$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
			$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
			$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
			$wp_customize->get_setting('custom_logo')->transport = 'refresh';

			/**
			 * Helper files
			 */
			require AURAMART_PARENT_INC_DIR . '/customizer/sanitization.php';
		}
		
		/**
		 * Admin Script
		 */
		function auramart_admin_script() {
			wp_enqueue_style('auramart-admin-style', AURAMART_PARENT_INC_URI . '/customizer/assets/css/admin.css');
			wp_enqueue_script( 'auramart-admin-script', AURAMART_PARENT_INC_URI . '/customizer/assets/js/admin-script.js', array( 'jquery' ), '', true );
			wp_localize_script( 'auramart-admin-script', 'auramart_ajax_object',
				array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
			);
		}
		
		/**
		 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
		 */
		function auramart_customize_preview_js() {
			wp_enqueue_script( 'auramart-customizer', AURAMART_PARENT_INC_URI . '/customizer/assets/js/customizer-preview.js', array( 'customize-preview' ), '20151215', true );
		}
		
		function auramart_customizer_script() {
			 wp_enqueue_script( 'auramart-customizer-section', AURAMART_PARENT_INC_URI .'/customizer/assets/js/customizer-section.js', array("jquery"),'', true  );	
		}

		// Include customizer customizer settings.
			
		function auramart_customizer_settings() {
				 require AURAMART_PARENT_INC_DIR . '/customizer/customizer-options/auramart-header.php';
				 require AURAMART_PARENT_INC_DIR . '/customizer/customizer-options/auramart-blog.php';
				 require AURAMART_PARENT_INC_DIR . '/customizer/customizer-options/auramart-footer.php';
				 require AURAMART_PARENT_INC_DIR . '/customizer/customizer-options/auramart-general.php';
				 require AURAMART_PARENT_INC_DIR . '/customizer/customizer-options/auramart_recommended_plugin.php';
		}

	}
}// End if().

/**
 *  Kicking this off by calling 'get_instance()' method
 */
AuraMart_Customizer::get_instance();