<?php
add_action('wp_enqueue_scripts', 'attire_shop_enqueue_scripts', 99);

function attire_shop_enqueue_scripts()
{
    wp_dequeue_script('flexslider');
    wp_dequeue_script('flexslider-init');

    wp_register_style('attire-shop-main', get_stylesheet_directory_uri() . '/main.min.css');
    wp_enqueue_style('attire-shop-main');

    wp_register_style('splide', get_stylesheet_directory_uri() . '/splide/css/splide.min.css');
    wp_enqueue_style('splide');
    wp_register_script('splide', get_stylesheet_directory_uri() . '/splide/js/splide.min.js', false, null, true);
    wp_enqueue_script('splide');

    wp_register_script('attire-shop-app', get_stylesheet_directory_uri() . '/app.js', ['jquery'], null, true);
    wp_enqueue_script('attire-shop-app');
}

add_action('woocommerce_before_add_to_cart_quantity', 'attire_before_atc');
add_action('woocommerce_after_add_to_cart_quantity', 'attire_after_atc');

function attire_before_atc()
{
    echo '		<div class="attire-shop-decrement decrement"><span>-</span></div>';
}


function attire_after_atc()
{
    echo '		<div class="attire-shop-increment increment">+</div>';
}