// Create and mount the thumbnails slider.
document.addEventListener('DOMContentLoaded', function () {
    if (document.getElementById('secondary-slider'))
        var secondarySlider = new Splide('#secondary-slider', {
            rewind: true,
            fixedWidth: 100,
            fixedHeight: 100,
            isNavigation: true,
            gap: 5,
            focus: 'center',
            pagination: false,
            cover: false,
            breakpoints: {
                '600': {
                    fixedWidth: 66,
                    fixedHeight: 40,
                }
            }
        }).mount();

// Create the main slider.
    if (document.getElementById('primary-slider'))
        var primarySlider = new Splide('#primary-slider', {
            type: 'fade',
            heightRatio: 1,
            pagination: false,
            arrows: false,
        });

// Set the thumbnails slider as a sync target and then call mount.
    if (primarySlider && secondarySlider)
        primarySlider.sync(secondarySlider).mount();
});

jQuery(document).ready(function ($) {
    $('body')
        .on('click', '.attire-shop-increment', function (e) {
            let target_element = $(this).siblings('.quantity').find('input');
            let current_value = Number($(this).siblings('.quantity').find('input').val());
            $(target_element).val(current_value + 1);
            jQuery("[name='update_cart']").prop("disabled", false);
        })
        .on('click', '.attire-shop-decrement', function (e) {
            let target_element = $(this).siblings('.quantity').find('input');
            let current_value = Number($(this).siblings('.quantity').find('input').val());
            let new_value = current_value - 1 > -1 ? current_value - 1 : 0;
            $(target_element).val(new_value);
            jQuery("[name='update_cart']").prop("disabled", false);
        });
});