<?php
/**
* Wizard
* @package Whizzie
* @since 1.0.0
*/

class Whizzie {
	protected $version = '1.1.0';
	protected $theme_name = '';
	protected $theme_title = '';
	protected $page_slug = '';
	protected $page_title = '';
	protected $config_steps = array();
	public $parent_slug;
	/**
	 * Constructor
	 * @param $config Configuration parameters
	 */
	public function __construct( $config ) {
		$this->set_vars( $config );
		$this->init();
	}

	/**
	 * Set variables based on configuration
	 * @param $config Configuration parameters
	 */
	public function set_vars( $config ) {
		if ( isset( $config['page_slug'] ) ) {
			$this->page_slug = esc_attr( $config['page_slug'] );
		}
		if ( isset( $config['page_title'] ) ) {
			$this->page_title = esc_attr( $config['page_title'] );
		}
		if ( isset( $config['steps'] ) ) {
			$this->config_steps = $config['steps'];
		}

		$current_theme = wp_get_theme();
		$this->theme_title = $current_theme->get( 'Name' );
		$this->theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $current_theme->get( 'Name' ) ) );
		$this->page_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_page_slug', $this->theme_name . '-wizard' );
		$this->parent_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_parent_slug', '' );
	}

	/*** Initialize hooks and actions ***/
	public function init() {
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'wp_ajax_setup_widgets', array( $this, 'setup_widgets' ) );
	}
	
	public function enqueue_scripts() {
		wp_enqueue_style( 'theme-wizard-style', get_template_directory_uri() . '/theme-wizard/assets/css/theme-wizard-style.css');
		wp_register_script( 'theme-wizard-script', get_template_directory_uri() . '/theme-wizard/assets/js/theme-wizard-script.js', array( 'jquery' ));
		wp_localize_script(
			'theme-wizard-script',
			'aster_startup_whizzie_params',
			array(
				'ajaxurl' => admin_url( 'admin-ajax.php' ),
				'verify_text' => esc_html( 'verifying', 'aster-startup' )
			)
		);
		wp_enqueue_script( 'theme-wizard-script' );
	}

	public function menu_page() {
		add_theme_page( esc_html( $this->page_title ), esc_html( $this->page_title ), 'manage_options', $this->page_slug, array( $this, 'aster_startup_setup_wizard' ) );
	}

	/*** Display the wizard page content ***/
	public function wizard_page() { ?>
		<div class="main-wrap">
			<div class="card whizzie-wrap">
				<ul class="whizzie-menu">
					<?php foreach ( $this->get_steps() as $step ) : ?>
						<li data-step="<?php echo esc_attr( $step['id'] ); ?>" class="step step-<?php echo esc_attr( $step['id'] ); ?>">

							<h2><?php echo esc_html( $step['title'] ); ?></h2>

							<?php
							$content = call_user_func( array( $this, $step['view'] ) );
							?>

							<?php if ( isset( $content['summary'] ) ) : ?>
								<div class="summary">
									<?php echo wp_kses_post( $content['summary'] ); ?>
								</div>
							<?php endif; ?>

							<?php if ( isset( $content['detail'] ) ) : ?>
								<p>
									<a href="#" class="more-info">
										<?php esc_html_e( 'More Info', 'aster-startup' ); ?>
									</a>
								</p>
								<div class="detail">
									<?php echo wp_kses_post( $content['detail'] ); ?>
								</div>
							<?php endif; ?>

							<?php if ( ! empty( $step['button_text'] ) ) : ?>
								<div class="button-wrap">

									<?php if ( ! get_option( 'is-demo-imported' ) ) : ?>

										<a href="#"
										class="button button-primary do-it"
										data-callback="<?php echo esc_attr( $step['callback'] ); ?>"
										data-step="<?php echo esc_attr( $step['id'] ); ?>">
											<?php echo esc_html( $step['button_text'] ); ?>
										</a>

									<?php else : ?>

										<a target="_blank"
										href="<?php echo esc_url( home_url() ); ?>"
										class="button button-primary"
										style="font-size:20px;font-weight:600;">
											<?php esc_html_e( 'Visit Site', 'aster-startup' ); ?>
										</a>

									<?php endif; ?>

								</div>
							<?php endif; ?>

						</li>
					<?php endforeach; ?>
				</ul>
				<div class="step-loading">
					<span class="spinner"></span>
				</div>
			</div>
		</div>
	<?php }

	/*** Setup wizard page content and options ***/
	public function aster_startup_setup_wizard() { ?>
		<div class="wrapper-info get-stared-page-wrap">
			<div class="tab-sec theme-option-tab">
				<div id="demo_offer" class="tabcontent">
					<?php $this->wizard_page(); ?>
				</div>
			</div>
		</div>
	<?php }

	/**
	 * Get the steps for the wizard
	 * @return array
	 */
	public function get_steps() {
		$steps = array(
			'intro' => array(
				'id' => 'intro',
				'title' => __( 'Welcome to ', 'aster-startup' ) . $this->theme_title,
				'view' => 'get_step_intro',
				'callback' => 'do_next_step',
				'button_text' => __( 'Start Now', 'aster-startup' ),
				'can_skip' => false
			),
			'widgets' => array(
				'id' => 'widgets',
				'title' => __( 'Demo Importer', 'aster-startup' ),
				'view' => 'get_step_widgets',
				'callback' => 'install_widgets',
				'button_text' => __( 'Import Demo', 'aster-startup' ),
				'can_skip' => true
			),
			'done' => array(
				'id' => 'done',
				'title' => __( 'All Done', 'aster-startup' ),
				'view' => 'get_step_done'
			)
		);

		return $steps;
	}

	/*** Display the content for the intro step ***/
	public function get_step_intro() { ?>
		<div class="summary">
			<p style="text-align: center;"><?php esc_html_e( 'Thank you for choosing our theme! We are excited to help you get started with your new website.', 'aster-startup' ); ?></p>
			<p style="text-align: center;"><?php esc_html_e( 'This section will guide you through setting up and customizing the theme. You can follow the steps to import demo content or adjust settings at any time to make the website look and work the way you want.', 'aster-startup' ); ?></p>
		</div>
	<?php }

	/*** Display the content for the widgets step ***/
	public function get_step_widgets() { ?>
		<div class="summary">
			<p><?php esc_html_e('To get started, use the button below to import demo content and add widgets to your site. After installation, you can manage settings and customize your site using the Customizer. Enjoy your new theme!', 'aster-startup'); ?></p>
		</div>
	<?php }

	/*** Display the content for the final step ***/
	public function get_step_done() { ?>
		<div id="aster-demo-setup-guid">
			<div class="aster-setup-menu">
				<h3><?php esc_html_e('Setup Navigation Menu','aster-startup'); ?></h3>
				<p><?php esc_html_e('Follow the following Steps to Setup Menu','aster-startup'); ?></p>
				<h4><?php esc_html_e('A) Create Pages','aster-startup'); ?></h4>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Pages >> Add New','aster-startup'); ?></li>
					<li><?php esc_html_e('Enter Page Details And Save Changes','aster-startup'); ?></li>
				</ol>
				<h4><?php esc_html_e('B) Add Pages To Menu','aster-startup'); ?></h4>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Appearance >> Menu','aster-startup'); ?></li>
					<li><?php esc_html_e('Click On The Create Menu Option','aster-startup'); ?></li>
					<li><?php esc_html_e('Select The Pages And Click On The Add to Menu Button','aster-startup'); ?></li>
					<li><?php esc_html_e('Select Primary Menu From The Menu Setting','aster-startup'); ?></li>
					<li><?php esc_html_e('Click On The Save Menu Button','aster-startup'); ?></li>
				</ol>
			</div>
			<div class="aster-setup-widget">
				<h3><?php esc_html_e('Setup Footer Widgets','aster-startup'); ?></h3>
				<p><?php esc_html_e('Follow the following Steps to Setup Footer Widgets','aster-startup'); ?></p>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Appearance >> Widgets','aster-startup'); ?></li>
					<li><?php esc_html_e('Drag And Add The Widgets In The Footer Columns','aster-startup'); ?></li>
				</ol>
			</div>
			<div style="display:flex; flex-wrap: wrap; justify-content: center; margin-top: 20px; gap:20px">
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url(home_url()); ?>" class="button button-primary">Visit Site</a>
				</div>
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>" class="button button-primary">Customize Your Demo</a>
				</div>
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url( admin_url('themes.php?page=aster-startup-getting-started') ); ?>" class="button button-primary">Dashboard</a>
				</div>
			</div>
		</div>
	<?php }

	/***------------------------------------------------- Imports the Demo Content* @since 1.1.0 ----------------------------------------------****/


	//                      ------------- MENUS -----------------                    //

	public function aster_startup_customizer_primary_menu(){

		// ------- Create Primary Menu --------
		$aster_startup_menuname = $aster_startup_themename . 'Main Menu';
		$aster_startup_bpmenulocation = 'primary';
		$aster_startup_menu_exists = wp_get_nav_menu_object( $aster_startup_menuname );

		if( !$aster_startup_menu_exists){
			$aster_startup_menu_id = wp_create_nav_menu($aster_startup_menuname);
			$aster_startup_parent_item = 
			wp_update_nav_menu_item($aster_startup_menu_id, 0, array(
				'menu-item-title' =>  __('HOME','aster-startup'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url( '/' ),
				'menu-item-status' => 'publish'));

			wp_update_nav_menu_item($aster_startup_menu_id, 0, array(
				'menu-item-title' =>  __('PAGES','aster-startup'),
				'menu-item-classes' => 'pages',
				'menu-item-url' => get_permalink(get_page_by_title('PAGES')),
				'menu-item-status' => 'publish'));

			wp_update_nav_menu_item($aster_startup_menu_id, 0, array(
				'menu-item-title' =>  __('PORTFOLIO','aster-startup'),
				'menu-item-classes' => 'portfolio',
				'menu-item-url' => get_permalink(get_page_by_title('PORTFOLIO')),
				'menu-item-status' => 'publish'));

			wp_update_nav_menu_item($aster_startup_menu_id, 0, array(
				'menu-item-title'   => __('BLOGS', 'aster-startup'),
				'menu-item-classes' => 'blog',
				'menu-item-url'     => get_permalink(get_page_by_title('BLOGS')),
				'menu-item-status'  => 'publish'
			));
			
			if( !has_nav_menu( $aster_startup_bpmenulocation ) ){
				$locations = get_theme_mod('nav_menu_locations');
				$locations[$aster_startup_bpmenulocation] = $aster_startup_menu_id;
				set_theme_mod( 'nav_menu_locations', $locations );
			}
		}
	}

	public function setup_widgets() {

		// Create a front page and assigned the template
		$aster_startup_home_title = 'HOME';
		$aster_startup_home_check = get_page_by_title($aster_startup_home_title);
		$aster_startup_home = array(
			'post_type' => 'page',
			'post_title' => $aster_startup_home_title,
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' => 'home'
		);
		$aster_startup_home_id = wp_insert_post($aster_startup_home);

		//Set the static front page
		$aster_startup_home = get_page_by_title( 'HOME' );
		update_option( 'page_on_front', $aster_startup_home->ID );
		update_option( 'show_on_front', 'page' );


		// Create a posts page and assigned the template
		$aster_startup_blog_title = 'SHOP';
		$aster_startup_blog = get_page_by_title($aster_startup_blog_title);

		if (!$aster_startup_blog) {
			$aster_startup_blog = array(
				'post_type' => 'page',
				'post_title' => $aster_startup_blog_title,
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name' => 'blog'
			);
			$aster_startup_blog_id = wp_insert_post($aster_startup_blog);

			if (is_wp_error($aster_startup_blog_id)) {
				// Handle error
			}
		} else {
			$aster_startup_blog_id = $aster_startup_blog->ID;
		}
		// Set the posts page
		update_option('page_for_posts', $aster_startup_blog_id);

		// Create a posts page and assigned the template
		$aster_startup_blog_title = 'PAGES';
		$aster_startup_blog = get_page_by_title($aster_startup_blog_title);

		if (!$aster_startup_blog) {
			$aster_startup_blog = array(
				'post_type' => 'page',
				'post_title' => $aster_startup_blog_title,
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name' => 'blog'
			);
			$aster_startup_blog_id = wp_insert_post($aster_startup_blog);

			if (is_wp_error($aster_startup_blog_id)) {
				// Handle error
			}
		} else {
			$aster_startup_blog_id = $aster_startup_blog->ID;
		}
		// Set the posts page
		update_option('page_for_posts', $aster_startup_blog_id);

		// Create a Blogs and assigned the template
		$aster_startup_blog_title = 'BLOGS';
		$aster_startup_blog_check = get_page_by_title($aster_startup_blog_title);
		$aster_startup_blog = array(
			'post_type' => 'page',
			'post_title' => $aster_startup_blog_title,
			'post_content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>',
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' => 'blog'
		);
		$aster_startup_blog_id = wp_insert_post($aster_startup_blog);

		// Create a Portfolio and assigned the template
		$aster_startup_portfolio_title = 'PORTFOLIO';
		$aster_startup_portfolio_check = get_page_by_title($aster_startup_portfolio_title);
		$aster_startup_portfolio = array(
			'post_type' => 'page',
			'post_title' => $aster_startup_portfolio_title,
			'post_content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>',
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' => 'portfolio'
		);
		$aster_startup_portfolio_id = wp_insert_post($aster_startup_portfolio);

		// ------------------------------------------ Header Section --------------------------------------

			set_theme_mod( 'aster_startup_phone_topbar_number', '+1 123 456 7890');

		// ---------------------------------------- Slider --------------------------------------------------- //
			
				// Create categories if not already created
			$aster_startup_category_slider = wp_create_category('Slider');
			

			// Array of categories to assign to each set of posts
			$aster_startup_categories = array($aster_startup_category_slider);

			// Loop to create posts
			for ($i = 1; $i <= 3; $i++) {
				set_theme_mod('aster_startup_banner_button_label_'.$i,'Read More');
				$title = array(
					'Empowering Your Business with Seamless IT Solutions',
					'Enhancing Your Business with Effortless IT Solutions',
					'Elevating Your Business with Streamlined IT Solutions',
				);

				// Determine category and post index to use for title
				$category_index = ($i <= 3) ? 0 : 1; // First 3 for Slider, next 3 for Blog
				$post_title = $title[$i - 1]; // Adjust for zero-based index in title array

				// Create post object
				$my_post = array(
					'post_title'    => wp_strip_all_tags($post_title),
					'post_content'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s ',
					'post_status'   => 'publish',
					'post_type'     => 'post',
					'post_category' => array($aster_startup_categories[$category_index]), // Assign Slider to first 3, Blog to next 3
				);

				// Insert the post into the database
				$post_id = wp_insert_post($my_post);

				set_theme_mod('aster_startup_banner_slider_content_post_'.$i, $post_id);

				// Determine the category and set image URLs based on category
				if ($category_index === 0) { // Slider category

					$aster_startup_image_name = "slider-" . $i . ".jpg";
    				$aster_startup_image_url = get_template_directory_uri() . '/resource/img/' . $aster_startup_image_name;
				}

				$aster_startup_upload_dir = wp_upload_dir();
				$aster_startup_image_data = file_get_contents($aster_startup_image_url);
				$aster_startup_unique_file_name = wp_unique_filename($aster_startup_upload_dir['path'], $aster_startup_image_name);
				$filename = basename($aster_startup_unique_file_name);

				if (wp_mkdir_p($aster_startup_upload_dir['path'])) {
					$file = $aster_startup_upload_dir['path'] . '/' . $filename;
				} else {
					$file = $aster_startup_upload_dir['basedir'] . '/' . $filename;
				}

				if ( ! function_exists( 'WP_Filesystem' ) ) {
				    require_once( ABSPATH . 'wp-admin/includes/file.php' );
				}

				WP_Filesystem();
				global $wp_filesystem;

				if ( ! $wp_filesystem->put_contents( $file, $aster_startup_image_data, FS_CHMOD_FILE ) ) {
				    wp_die( 'Error saving file!' );
				}

				$wp_filetype = wp_check_filetype($filename, null);
				$attachment = array(
					'post_mime_type' => $wp_filetype['type'],
					'post_title'     => sanitize_file_name($filename),
					'post_content'   => '',
					'post_status'    => 'inherit'
				);

				$aster_startup_attach_id = wp_insert_attachment($attachment, $file, $post_id);

				require_once(ABSPATH . 'wp-admin/includes/image.php');

				$aster_startup_attach_data = wp_generate_attachment_metadata($aster_startup_attach_id, $file);
				wp_update_attachment_metadata($aster_startup_attach_id, $aster_startup_attach_data);
				set_post_thumbnail($post_id, $aster_startup_attach_id);
			}


		// ---------------------------------------- Services --------------------------------------------------- //	

			set_theme_mod('aster_startup_services_short_heading','Our Services');
			set_theme_mod('aster_startup_services_heading','Best Solutions For All');

			set_theme_mod('aster_startup_trending_post_category','services');
			// Create categories if not already created
			$aster_startup_category_services = wp_create_category('Services');
			

			// Array of categories to assign to each set of posts
			$aster_startup_categories = array($aster_startup_category_services);

			// Loop to create posts
			for ($i = 1; $i <= 3; $i++) {
				$title = array(
					'Managed IT Services',
					'Cyber Security Solutions',
					'Cloud Solutions & Migration',
				);

				// Determine category and post index to use for title
				$category_index = ($i <= 3) ? 0 : 1; // First 3 for Slider, next 3 for Blog
				$post_title = $title[$i - 1]; // Adjust for zero-based index in title array

				// Create post object
				$my_post = array(
					'post_title'    => wp_strip_all_tags($post_title),
					'post_content'  => 'Proactively envisioned multimedia based expertise and cross-media growth strategies. Seamlessly visualize quality intellectual.',
					'post_status'   => 'publish',
					'post_type'     => 'post',
					'post_category' => array($aster_startup_categories[$category_index]), // Assign Slider to first 3, Blog to next 3
				);

				// Insert the post into the database
				$post_id = wp_insert_post($my_post);

				// Determine the category and set image URLs based on category
				if ($category_index === 0) { // Slider category
				    $aster_startup_image_name = "services-" . $i . ".png";
    				$aster_startup_image_url = get_template_directory_uri() . '/resource/img/' . $aster_startup_image_name;
				}

				$aster_startup_upload_dir = wp_upload_dir();
				$aster_startup_image_data = file_get_contents($aster_startup_image_url);
				$aster_startup_unique_file_name = wp_unique_filename($aster_startup_upload_dir['path'], $aster_startup_image_name);
				$filename = basename($aster_startup_unique_file_name);

				if (wp_mkdir_p($aster_startup_upload_dir['path'])) {
					$file = $aster_startup_upload_dir['path'] . '/' . $filename;
				} else {
					$file = $aster_startup_upload_dir['basedir'] . '/' . $filename;
				}

				if ( ! function_exists( 'WP_Filesystem' ) ) {
				    require_once( ABSPATH . 'wp-admin/includes/file.php' );
				}

				WP_Filesystem();
				global $wp_filesystem;

				if ( ! $wp_filesystem->put_contents( $file, $aster_startup_image_data, FS_CHMOD_FILE ) ) {
				    wp_die( 'Error saving file!' );
				}

				$wp_filetype = wp_check_filetype($filename, null);
				$attachment = array(
					'post_mime_type' => $wp_filetype['type'],
					'post_title'     => sanitize_file_name($filename),
					'post_content'   => '',
					'post_status'    => 'inherit'
				);

				$aster_startup_attach_id = wp_insert_attachment($attachment, $file, $post_id);

				require_once(ABSPATH . 'wp-admin/includes/image.php');

				$aster_startup_attach_data = wp_generate_attachment_metadata($aster_startup_attach_id, $file);
				wp_update_attachment_metadata($aster_startup_attach_id, $aster_startup_attach_data);
				set_post_thumbnail($post_id, $aster_startup_attach_id);
			}



		// ---------------------------------------- Related post_tag --------------------------------------------------- //	
		
			set_theme_mod('aster_startup_post_related_post_label','Related Posts');
			set_theme_mod('aster_startup_related_posts_count','3');

		$this->aster_startup_customizer_primary_menu();
		update_option('is-demo-imported', true);
	}
}