<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package aster_startup
 */

function aster_startup_body_classes( $aster_startup_classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$aster_startup_classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$aster_startup_classes[] = 'no-sidebar';
	}

	$aster_startup_classes[] = aster_startup_sidebar_layout();

	return $aster_startup_classes;
}
add_filter( 'body_class', 'aster_startup_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function aster_startup_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'aster_startup_pingback_header' );


/**
 * Get all posts for customizer Post content type.
 */
function aster_startup_get_post_choices() {
	$aster_startup_choices = array( '' => esc_html__( '--Select--', 'aster-startup' ) );
	$aster_startup_args    = array( 'numberposts' => -1 );
	$aster_startup_posts   = get_posts( $aster_startup_args );

	foreach ( $aster_startup_posts as $aster_startup_post ) {
		$aster_startup_id             = $aster_startup_post->ID;
		$aster_startup_title          = $aster_startup_post->post_title;
		$aster_startup_choices[ $aster_startup_id ] = $aster_startup_title;
	}

	return $aster_startup_choices;
}

/**
 * Get all pages for customizer Page content type.
 */
function aster_startup_get_page_choices() {
	$aster_startup_choices = array( '' => esc_html__( '--Select--', 'aster-startup' ) );
	$aster_startup_pages   = get_pages();

	foreach ( $aster_startup_pages as $aster_startup_page ) {
		$aster_startup_choices[ $aster_startup_page->ID ] = $aster_startup_page->post_title;
	}

	return $aster_startup_choices;
}

/**
 * Get all categories for customizer Category content type.
 */
function aster_startup_get_post_cat_choices() {
	$aster_startup_choices = array( '' => esc_html__( '--Select--', 'aster-startup' ) );
	$aster_startup_cats    = get_categories();

	foreach ( $aster_startup_cats as $aster_startup_cat ) {
		$aster_startup_choices[ $aster_startup_cat->term_id ] = $aster_startup_cat->name;
	}

	return $aster_startup_choices;
}

/**
 * Get all donation forms for customizer form content type.
 */
function aster_startup_get_post_donation_form_choices() {
	$aster_startup_choices = array( '' => esc_html__( '--Select--', 'aster-startup' ) );
	$aster_startup_posts   = get_posts(
		array(
			'post_type'   => 'give_forms',
			'numberposts' => -1,
		)
	);
	foreach ( $aster_startup_posts as $aster_startup_post ) {
		$aster_startup_choices[ $aster_startup_post->ID ] = $aster_startup_post->post_title;
	}
	return $aster_startup_choices;
}

if ( ! function_exists( 'aster_startup_excerpt_length' ) ) :
	/**
	 * Excerpt length.
	 */
	function aster_startup_excerpt_length( $aster_startup_length ) {
		if ( is_admin() ) {
			return $aster_startup_length;
		}

		return get_theme_mod( 'aster_startup_excerpt_length', 20 );
	}
endif;
add_filter( 'excerpt_length', 'aster_startup_excerpt_length', 999 );

if ( ! function_exists( 'aster_startup_excerpt_more' ) ) :
	/**
	 * Excerpt more.
	 */
	function aster_startup_excerpt_more( $aster_startup_more ) {
		if ( is_admin() ) {
			return $aster_startup_more;
		}

		return '&hellip;';
	}
endif;
add_filter( 'excerpt_more', 'aster_startup_excerpt_more' );

if ( ! function_exists( 'aster_startup_sidebar_layout' ) ) {
	/**
	 * Get sidebar layout.
	 */
	function aster_startup_sidebar_layout() {
		$aster_startup_sidebar_position      = get_theme_mod( 'aster_startup_sidebar_position', 'right-sidebar' );
		$aster_startup_sidebar_position_post = get_theme_mod( 'aster_startup_post_sidebar_position', 'right-sidebar' );
		$aster_startup_sidebar_position_page = get_theme_mod( 'aster_startup_page_sidebar_position', 'right-sidebar' );

		if ( is_home() ) {
			$aster_startup_sidebar_position = $aster_startup_sidebar_position_post;
		} elseif ( is_page() ) {
			$aster_startup_sidebar_position = $aster_startup_sidebar_position_page;
		}

		return $aster_startup_sidebar_position;
	}
}

if ( ! function_exists( 'aster_startup_is_sidebar_enabled' ) ) {
	/**
	 * Check if sidebar is enabled.
	 */
	function aster_startup_is_sidebar_enabled() {
		$aster_startup_sidebar_position      = get_theme_mod( 'aster_startup_sidebar_position', 'right-sidebar' );
		$aster_startup_sidebar_position_post = get_theme_mod( 'aster_startup_post_sidebar_position', 'right-sidebar' );
		$aster_startup_sidebar_position_page = get_theme_mod( 'aster_startup_page_sidebar_position', 'right-sidebar' );

		$aster_startup_sidebar_enabled = true;
		if ( is_single() || is_archive() || is_search() ) {
			if ( 'no-sidebar' === $aster_startup_sidebar_position ) {
				$aster_startup_sidebar_enabled = false;
			}
		} elseif ( is_home() ) {
			if ( 'no-sidebar' === $aster_startup_sidebar_position || 'no-sidebar' === $aster_startup_sidebar_position_post ) {
				$aster_startup_sidebar_enabled = false;
			}
		} elseif ( is_page() ) {
			if ( 'no-sidebar' === $aster_startup_sidebar_position || 'no-sidebar' === $aster_startup_sidebar_position_page ) {
				$aster_startup_sidebar_enabled = false;
			}
		}
		return $aster_startup_sidebar_enabled;
	}
}

if ( ! function_exists( 'aster_startup_get_homepage_sections ' ) ) {
	/**
	 * Returns homepage sections.
	 */
	function aster_startup_get_homepage_sections() {
		$aster_startup_sections = array(
			'banner'  => esc_html__( 'Banner Section', 'aster-startup' ),
			'product' => esc_html__( 'Product Section', 'aster-startup' ),
		);
		return $aster_startup_sections;
	}
}

/**
 * Renders customizer section link
 */
function aster_startup_section_link( $aster_startup_section_id ) {
	$aster_startup_section_name      = str_replace( 'aster_startup_', ' ', $aster_startup_section_id );
	$aster_startup_section_name      = str_replace( '_', ' ', $aster_startup_section_name );
	$aster_startup_starting_notation = '#';
	?>
	<span class="section-link">
		<span class="section-link-title"><?php echo esc_html( $aster_startup_section_name ); ?></span>
	</span>
	<style type="text/css">
		<?php echo $aster_startup_starting_notation . $aster_startup_section_id; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>:hover .section-link {
			visibility: visible;
		}
	</style>
	<?php
}

/**
 * Adds customizer section link css
 */
function aster_startup_section_link_css() {
	if ( is_customize_preview() ) {
		?>
		<style type="text/css">
			.section-link {
				visibility: hidden;
				background-color: black;
				position: relative;
				top: 80px;
				z-index: 99;
				left: 40px;
				color: #fff;
				text-align: center;
				font-size: 20px;
				border-radius: 10px;
				padding: 20px 10px;
				text-transform: capitalize;
			}

			.section-link-title {
				padding: 0 10px;
			}

			.banner-section {
				position: relative;
			}

			.banner-section .section-link {
				position: absolute;
				top: 100px;
			}
		</style>
		<?php
	}
}
add_action( 'wp_head', 'aster_startup_section_link_css' );

/**
 * Breadcrumb.
 */
function aster_startup_breadcrumb( $aster_startup_args = array() ) {
	if ( ! get_theme_mod( 'aster_startup_enable_breadcrumb', true ) ) {
		return;
	}

	$aster_startup_args = array(
		'show_on_front' => false,
		'show_title'    => true,
		'show_browse'   => false,
	);
	breadcrumb_trail( $aster_startup_args );
}
add_action( 'aster_startup_breadcrumb', 'aster_startup_breadcrumb', 10 );

/**
 * Add separator for breadcrumb trail.
 */
function aster_startup_breadcrumb_trail_print_styles() {
	$aster_startup_breadcrumb_separator = get_theme_mod( 'aster_startup_breadcrumb_separator', '/' );

	$aster_startup_style = '
		.trail-items li::after {
			content: "' . $aster_startup_breadcrumb_separator . '";
		}'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	$aster_startup_style = apply_filters( 'aster_startup_breadcrumb_trail_inline_style', trim( str_replace( array( "\r", "\n", "\t", '  ' ), '', $aster_startup_style ) ) );

	if ( $aster_startup_style ) {
		echo "\n" . '<style type="text/css" id="breadcrumb-trail-css">' . $aster_startup_style . '</style>' . "\n"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
add_action( 'wp_head', 'aster_startup_breadcrumb_trail_print_styles' );

/**
 * Pagination for archive.
 */
function aster_startup_render_posts_pagination() {
	$aster_startup_is_pagination_enabled = get_theme_mod( 'aster_startup_enable_pagination', true );
	if ( $aster_startup_is_pagination_enabled ) {
		$aster_startup_pagination_type = get_theme_mod( 'aster_startup_pagination_type', 'default' );
		if ( 'default' === $aster_startup_pagination_type ) :
			the_posts_navigation();
		else :
			the_posts_pagination();
		endif;
	}
}
add_action( 'aster_startup_posts_pagination', 'aster_startup_render_posts_pagination', 10 );

/**
 * Pagination for single post.
 */
function aster_startup_render_post_navigation() {
	the_post_navigation(
		array(
			'prev_text' => '<span>&#10229;</span> <span class="nav-title">%title</span>',
			'next_text' => '<span class="nav-title">%title</span> <span>&#10230;</span>',
		)
	);
}
add_action( 'aster_startup_post_navigation', 'aster_startup_render_post_navigation' );

/**
 * Adds footer copyright text.
 */
function aster_startup_output_footer_copyright_content() {
    $aster_startup_theme_data = wp_get_theme();
    $aster_startup_copyright_text = get_theme_mod('aster_startup_footer_copyright_text');

    if (!empty($aster_startup_copyright_text)) {
        $aster_startup_text = esc_html($aster_startup_copyright_text);
    } else {
    	$aster_startup_default_text = '<a href="'. esc_url(__('https://asterthemes.com/products/free-startup-wordpress-theme','aster-startup')) . '" target="_blank"> ' . esc_html($aster_startup_theme_data->get('Name')) . '</a>' . '&nbsp;' . esc_html__('by', 'aster-startup') . '&nbsp;<a target="_blank" href="' . esc_url($aster_startup_theme_data->get('AuthorURI')) . '">' . esc_html(ucwords($aster_startup_theme_data->get('Author'))) . '</a>';

		/* translators: %s: a link to WordPress */
		$aster_startup_default_text .= sprintf(esc_html__(' | Powered by %s', 'aster-startup'), '<a href="' . esc_url(__('https://wordpress.org/', 'aster-startup')) . '" target="_blank">WordPress</a>. ');
        $aster_startup_text = $aster_startup_default_text;
    }
    ?>
    <span><?php echo wp_kses_post($aster_startup_text); ?></span>
    <?php
}
add_action('aster_startup_footer_copyright', 'aster_startup_output_footer_copyright_content');

/* Footer Social Icons */ 
function aster_startup_footer_social_links() {

    if ( get_theme_mod('aster_startup_enable_footer_icon_section', true) ) {

            ?>
            <div class="socialicons">
				<div class="asterthemes-wrapper">
					<?php if ( get_theme_mod('aster_startup_footer_facebook_link', 'https://www.facebook.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('aster_startup_footer_facebook_link', 'https://www.facebook.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('aster_startup_facebook_icon', 'fab fa-facebook-f')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Facebook', 'aster-startup'); ?></span>
						</a>
					<?php } ?>
					<?php if ( get_theme_mod('aster_startup_footer_twitter_link', 'https://x.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('aster_startup_footer_twitter_link', 'https://x.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('aster_startup_twitter_icon', 'fab fa-twitter')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Twitter', 'aster-startup'); ?></span>
						</a>
					<?php } ?>
					<?php if ( get_theme_mod('aster_startup_footer_instagram_link', 'https://www.instagram.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('aster_startup_footer_instagram_link', 'https://www.instagram.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('aster_startup_instagram_icon', 'fab fa-instagram')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Instagram', 'aster-startup'); ?></span>
						</a>
					<?php } ?>
					<?php if ( get_theme_mod('aster_startup_footer_linkedin_link', 'https://in.linkedin.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('aster_startup_footer_linkedin_link', 'https://in.linkedin.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('aster_startup_linkedin_icon', 'fab fa-linkedin')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Linkedin', 'aster-startup'); ?></span>
						</a>
					<?php } ?>
					<?php if ( get_theme_mod('aster_startup_footer_youtube_link', 'https://www.youtube.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('aster_startup_footer_youtube_link', 'https://www.youtube.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('aster_startup_youtube_icon', 'fab fa-youtube')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Youtube', 'aster-startup'); ?></span>
						</a>
					<?php } ?>
				</div>
			</div>
            <?php
    }
}
add_action('wp_footer', 'aster_startup_footer_social_links');

if ( ! function_exists( 'aster_startup_footer_widget' ) ) :
	function aster_startup_footer_widget() {
		$aster_startup_footer_widget_column = get_theme_mod('aster_startup_footer_widget_column','4');

		$aster_startup_column_class = '';
		if ($aster_startup_footer_widget_column == '1') {
			$aster_startup_column_class = 'one-column';
		} elseif ($aster_startup_footer_widget_column == '2') {
			$aster_startup_column_class = 'two-columns';
		} elseif ($aster_startup_footer_widget_column == '3') {
			$aster_startup_column_class = 'three-columns';
		} else {
			$aster_startup_column_class = 'four-columns';
		}
	
		if($aster_startup_footer_widget_column !== ''): 
		?>
		<div class="dt_footer-widgets <?php echo esc_attr($aster_startup_column_class); ?>">
			<div class="footer-widgets-column">
				<?php
				$footer_widgets_active = false;

				// Loop to check if any footer widget is active
				for ($aster_startup_i = 1; $aster_startup_i <= $aster_startup_footer_widget_column; $aster_startup_i++) {
					if (is_active_sidebar('aster-startup-footer-widget-' . $aster_startup_i)) {
						$footer_widgets_active = true;
						break;
					}
				}

				if ($footer_widgets_active) {
					// Display active footer widgets
					for ($aster_startup_i = 1; $aster_startup_i <= $aster_startup_footer_widget_column; $aster_startup_i++) {
						if (is_active_sidebar('aster-startup-footer-widget-' . $aster_startup_i)) : ?>
							<div class="footer-one-column">
								<?php dynamic_sidebar('aster-startup-footer-widget-' . $aster_startup_i); ?>
							</div>
						<?php endif;
					}
				} else {
				?>
				<div class="footer-one-column default-widgets">
					<aside id="search-2" class="widget widget_search default_footer_search">
						<div class="widget-header">
							<h4 class="widget-title"><?php esc_html_e('Search Here', 'aster-startup'); ?></h4>
						</div>
						<?php get_search_form(); ?>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="recent-posts-2" class="widget widget_recent_entries">
						<h2 class="widget-title"><?php esc_html_e('Recent Posts', 'aster-startup'); ?></h2>
						<ul>
							<?php
							$recent_posts = wp_get_recent_posts(array(
								'numberposts' => 5,
								'post_status' => 'publish',
							));
							foreach ($recent_posts as $post) {
								echo '<li><a href="' . esc_url(get_permalink($post['ID'])) . '">' . esc_html($post['post_title']) . '</a></li>';
							}
							wp_reset_query();
							?>
						</ul>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="recent-comments-2" class="widget widget_recent_comments">
						<h2 class="widget-title"><?php esc_html_e('Recent Comments', 'aster-startup'); ?></h2>
						<ul>
							<?php
							$recent_comments = get_comments(array(
								'number' => 5,
								'status' => 'approve',
							));
							foreach ($recent_comments as $comment) {
								echo '<li><a href="' . esc_url(get_comment_link($comment)) . '">' .
									/* translators: %s: details. */
									sprintf(esc_html__('Comment on %s', 'aster-startup'), get_the_title($comment->comment_post_ID)) .
									'</a></li>';
							}
							?>
						</ul>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="categories" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer1', 'aster-startup'); ?>">
                        <h3 class="widget-title"><?php esc_html_e('Categories', 'aster-startup'); ?></h3>
                        <ul>
                            <?php wp_list_categories('title_li='); ?>
                        </ul>
                    </aside>
				</div>
			</div>
			<?php } ?>
		</div>
		<?php 
		endif;
	} 
	endif;
	add_action( 'aster_startup_footer_widget', 'aster_startup_footer_widget' );


function aster_startup_footer_text_transform_css() {
    $aster_startup_footer_text_transform = get_theme_mod('footer_text_transform', 'none');
    ?>
    <style type="text/css">
        .site-footer h4 {
            text-transform: <?php echo esc_html($aster_startup_footer_text_transform); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_footer_text_transform_css');

/**
 * GET START FUNCTION
 */

function aster_startup_getpage_css($hook) {
	wp_enqueue_script( 'aster-startup-admin-script', get_template_directory_uri() . '/resource/js/aster-startup-admin-notice-script.js', array( 'jquery' ) );
    wp_localize_script( 'aster-startup-admin-script', 'aster_startup_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
    wp_enqueue_style( 'aster-startup-notice-style', get_template_directory_uri() . '/resource/css/notice.css' );
}

add_action( 'admin_enqueue_scripts', 'aster_startup_getpage_css' );


add_action('wp_ajax_aster_startup_dismissable_notice', 'aster_startup_dismissable_notice');
function aster_startup_switch_theme() {
    delete_user_meta(get_current_user_id(), 'aster_startup_dismissable_notice');
}
add_action('after_switch_theme', 'aster_startup_switch_theme');
function aster_startup_dismissable_notice() {
    update_user_meta(get_current_user_id(), 'aster_startup_dismissable_notice', true);
    die();
}

function aster_startup_deprecated_hook_admin_notice() {
    global $pagenow;
    
    // Check if the current page is the one where you don't want the notice to appear
    if ( $pagenow === 'themes.php' && isset( $_GET['page'] ) && $_GET['page'] === 'aster-startup-getting-started' ) {
        return;
    }

    $dismissed = get_user_meta( get_current_user_id(), 'aster_startup_dismissable_notice', true );
    if ( !$dismissed) { ?>
        <div class="getstrat updated notice notice-success is-dismissible notice-get-started-class">
            <div class="at-admin-content" >
                <h2><?php esc_html_e('Welcome to Aster Startup', 'aster-startup'); ?></h2>
                <p><?php _e('Explore the features of our Pro Theme and take your Startup journey to the next level.', 'aster-startup'); ?></p>
                <p ><?php _e('Get Started With Theme By Clicking On Getting Started.', 'aster-startup'); ?><p>
                <div style="display: flex; justify-content: center; align-items:center; flex-wrap: wrap; gap: 5px">
                    <a class="admin-notice-btn button button-primary button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=aster-startup-getting-started' )); ?>"><?php esc_html_e( 'Get started', 'aster-startup' ) ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://demo.asterthemes.com/startup-business/"><?php esc_html_e('View Demo', 'aster-startup') ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://asterthemes.com/products/startup-business-wordpress-theme"><?php esc_html_e('Buy Now', 'aster-startup') ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="<?php echo esc_url( ASTER_STARTUP_BUNDLE_PAGE ); ?>"><?php esc_html_e('Get Bundle', 'aster-startup') ?></a>
                </div>
            </div>
            <div class="at-admin-image">
                <img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;border: 2px solid #ddd;border-radius: 4px;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
            </div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'aster_startup_deprecated_hook_admin_notice' );


//Admin Notice For Getstart
function aster_startup_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}