<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package aster_startup
 */


 function aster_startup_customizer_css() {
    $enable_breadcrumb = get_theme_mod('aster_startup_enable_breadcrumb', true);
    ?>
    <style type="text/css">
        <?php if (!$enable_breadcrumb) : ?>
            nav.woocommerce-breadcrumb {
                display: none;
            }
        <?php endif; ?>
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_customizer_css');

function aster_startup_customize_css() {
    ?>
    <style type="text/css">
        :root {
            --primary-color: <?php echo esc_html( get_theme_mod( 'primary_color', '#1678F4' ) ); ?>;
        }
    </style>
    <?php
}
add_action( 'wp_head', 'aster_startup_customize_css' );

function aster_startup_enqueue_selected_fonts() {
    $aster_startup_fonts_url = aster_startup_get_fonts_url();
    if (!empty($aster_startup_fonts_url)) {
        wp_enqueue_style('aster-startup-google-fonts', $aster_startup_fonts_url, array(), null);
    }
}
add_action('wp_enqueue_scripts', 'aster_startup_enqueue_selected_fonts');

function aster_startup_layout_customizer_css() {
    $aster_startup_margin = get_theme_mod('aster_startup_layout_width_margin', 50);
    ?>
    <style type="text/css">
        body.site-boxed--layout #page  {
            margin: 0 <?php echo esc_attr($aster_startup_margin); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_layout_customizer_css');

function aster_startup_blog_layout_customizer_css() {
    // Retrieve the blog layout option
    $aster_startup_blog_layout_option = get_theme_mod('aster_startup_blog_layout_option_setting', 'Left');

    // Initialize custom CSS variable
    $aster_startup_custom_css = '';

    // Generate custom CSS based on the layout option
    if ($aster_startup_blog_layout_option === 'Default') {
        $aster_startup_custom_css .= '.mag-post-detail { text-align: center; }';
    } elseif ($aster_startup_blog_layout_option === 'Left') {
        $aster_startup_custom_css .= '.mag-post-detail { text-align: left; }';
    } elseif ($aster_startup_blog_layout_option === 'Right') {
        $aster_startup_custom_css .= '.mag-post-detail { text-align: right; }';
    }

    // Output the combined CSS
    ?>
    <style type="text/css">
        <?php echo wp_kses($aster_startup_custom_css, array( 'style' => array(), 'text-align' => array() )); ?>
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_blog_layout_customizer_css');

// Featured Image Dimension
function aster_startup_custom_featured_image_css() {
    $aster_startup_dimension = get_theme_mod('aster_startup_blog_post_featured_image_dimension', 'default');
    $aster_startup_width = get_theme_mod('aster_startup_blog_post_featured_image_custom_width', '');
    $aster_startup_height = get_theme_mod('aster_startup_blog_post_featured_image_custom_height', '');
    
    if ($aster_startup_dimension === 'custom' && $aster_startup_width && $aster_startup_height) {
        $aster_startup_custom_css = "body:not(.single-post) .mag-post-single .mag-post-img img { width: {$aster_startup_width}px !important; height: {$aster_startup_height}px !important; }";
        wp_add_inline_style('aster-startup-style', $aster_startup_custom_css);
    }
}
add_action('wp_enqueue_scripts', 'aster_startup_custom_featured_image_css');

// Featured Image Border Radius
function aster_startup_featured_image_border_radius_css() {
    $aster_startup_featured_image_border_radius = get_theme_mod('aster_startup_featured_image_border_radius', 10);
    ?>
    <style type="text/css">  
        .mag-post-single img {
            border-radius: <?php echo esc_attr($aster_startup_featured_image_border_radius); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_featured_image_border_radius_css');

function aster_startup_sidebar_width_customizer_css() {
    $aster_startup_sidebar_width = get_theme_mod('aster_startup_sidebar_width', '30');
    ?>
    <style type="text/css">
        .right-sidebar .asterthemes-wrapper .asterthemes-page {
            grid-template-columns: auto <?php echo esc_attr($aster_startup_sidebar_width); ?>%;
        }
        .left-sidebar .asterthemes-wrapper .asterthemes-page {
            grid-template-columns: <?php echo esc_attr($aster_startup_sidebar_width); ?>% auto;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_sidebar_width_customizer_css');

if ( ! function_exists( 'aster_startup_get_page_title' ) ) {
    function aster_startup_get_page_title() {
        $aster_startup_title = '';

        if (is_404()) {
            $aster_startup_title = esc_html__('Page Not Found', 'aster-startup');
        } elseif (is_search()) {
            $aster_startup_title = esc_html__('Search Results for: ', 'aster-startup') . esc_html(get_search_query());
        } elseif (is_home() && !is_front_page()) {
            $aster_startup_title = esc_html__('Blogs', 'aster-startup');
        } elseif (function_exists('is_shop') && is_shop()) {
            $aster_startup_title = esc_html__('Shop', 'aster-startup');
        } elseif (is_page()) {
            $aster_startup_title = get_the_title();
        } elseif (is_single()) {
            $aster_startup_title = get_the_title();
        } elseif (is_archive()) {
            $aster_startup_title = get_the_archive_title();
        } else {
            $aster_startup_title = get_the_archive_title();
        }

        return apply_filters('aster_startup_page_title', $aster_startup_title);
    }
}

if ( ! function_exists( 'aster_startup_has_page_header' ) ) {
    function aster_startup_has_page_header() {
        // Default to true (display header)
        $aster_startup_return = true;

        // Custom conditions for disabling the header
        if ('hide-all-devices' === get_theme_mod('aster_startup_page_header_visibility', 'all-devices')) {
            $aster_startup_return = false;
        }

        // Apply filters and return
        return apply_filters('aster_startup_display_page_header', $aster_startup_return);
    }
}

if ( ! function_exists( 'aster_startup_page_header_style' ) ) {
    function aster_startup_page_header_style() {
        $aster_startup_style = get_theme_mod('aster_startup_page_header_style', 'default');
        return apply_filters('aster_startup_page_header_style', $aster_startup_style);
    }
}

function aster_startup_page_title_customizer_css() {
    $aster_startup_layout_option = get_theme_mod('aster_startup_page_header_layout', 'left');
    ?>
    <style type="text/css">
        .asterthemes-wrapper.page-header-inner {
            <?php if ($aster_startup_layout_option === 'flex') : ?>
                display: flex;
                justify-content: space-between;
                align-items: center;
            <?php else : ?>
                text-align: <?php echo esc_attr($aster_startup_layout_option); ?>;
            <?php endif; ?>
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_page_title_customizer_css');

function aster_startup_pagetitle_height_css() {
    $aster_startup_height = get_theme_mod('aster_startup_pagetitle_height', 50);
    ?>
    <style type="text/css">
        header.page-header {
            padding: <?php echo esc_attr($aster_startup_height); ?>px 0;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_pagetitle_height_css');

function aster_startup_site_logo_width() {
    $aster_startup_site_logo_width = get_theme_mod('aster_startup_site_logo_width', 200);
    ?>
    <style type="text/css">
        .site-logo img {
            max-width: <?php echo esc_attr($aster_startup_site_logo_width); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_site_logo_width');

function aster_startup_menu_font_size_css() {
    $aster_startup_menu_font_size = get_theme_mod('aster_startup_menu_font_size', 13);
    ?>
    <style type="text/css">
        .main-navigation a {
            font-size: <?php echo esc_attr($aster_startup_menu_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_menu_font_size_css');

//Menu Font Weight
function aster_startup_menu_font_weight_css() {
	$aster_startup_font_weight = get_theme_mod( 'aster_startup_menu_font_weight', 700 );

	$aster_startup_custom_css = "
		.main-navigation a {
		    font-weight: {$aster_startup_font_weight};
		}
	";

	wp_add_inline_style( 'aster-startup-style', $aster_startup_custom_css );
}
add_action( 'wp_enqueue_scripts', 'aster_startup_menu_font_weight_css' );

function aster_startup_menu_text_transform_css() {
    $menu_text_transform = get_theme_mod('aster_startup_menu_text_transform', 'uppercase');
    ?>
    <style type="text/css">
        .main-navigation a {
            text-transform: <?php echo esc_attr($menu_text_transform); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_menu_text_transform_css');

function aster_startup_sidebar_widget_font_size_css() {
    $aster_startup_sidebar_widget_font_size = get_theme_mod('aster_startup_sidebar_widget_font_size', 21);
    ?>
    <style type="text/css">
        h2.wp-block-heading {
            font-size: <?php echo esc_attr($aster_startup_sidebar_widget_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_sidebar_widget_font_size_css');

// Retrieve the slider visibility setting
$aster_startup_slider = get_theme_mod('aster_startup_enable_banner_section', true);

// Function to output custom CSS directly in the head section
function aster_startup_custom_css() {
    global $aster_startup_slider;
    if ($aster_startup_slider == false) {
        echo '<style type="text/css">
            .home header.site-header .header-main-wrapper .bottom-header-outer-wrapper .bottom-header-part {
                background: var(--primary-color) !important;
                position: relative !important;
            }
        </style>';
    }
}

// Hook the function into the wp_head action
add_action('wp_head', 'aster_startup_custom_css');

// Woocommerce Related Products Settings
function aster_startup_related_product_css() {
    $aster_startup_related_product_show_hide = get_theme_mod('aster_startup_related_product_show_hide', true);

    if ( $aster_startup_related_product_show_hide != true) {
        ?>
        <style type="text/css">
            .related.products {
                display: none;
            }
        </style>
        <?php
    }
}
add_action('wp_head', 'aster_startup_related_product_css');

// Woocommerce Product Sale Position 
function aster_startup_product_sale_position_customizer_css() {
    $aster_startup_layout_option = get_theme_mod('aster_startup_product_sale_position', 'left');
    ?>
    <style type="text/css">
        .woocommerce ul.products li.product .onsale {
            <?php if ($aster_startup_layout_option === 'left') : ?>
                right: auto;
                left: 0px;
            <?php else : ?>
                left: auto;
                right: 0px;
            <?php endif; ?>
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_product_sale_position_customizer_css');  

//Footer Social Icon Alignment
function aster_startup_footer_icons_alignment_css() {
    $aster_startup_footer_social_align = get_theme_mod( 'aster_startup_footer_social_align', 'center' );   
    ?>
    <style type="text/css">
        .socialicons {
            text-align: <?php echo esc_attr( $aster_startup_footer_social_align ); ?> 
        }

        /* Mobile Specific */
        @media screen and (max-width: 575px) {
            .socialicons {
                text-align: center;
            }
        }
    </style>
    <?php
}
add_action( 'wp_head', 'aster_startup_footer_icons_alignment_css' );

//Copyright Alignment
function aster_startup_footer_copyright_alignment_css() {
    $aster_startup_footer_bottom_align = get_theme_mod( 'aster_startup_footer_bottom_align', 'center' );   
    ?>
    <style type="text/css">
        .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
            justify-content: <?php echo esc_attr( $aster_startup_footer_bottom_align ); ?> 
        }

        /* Mobile Specific */
        @media screen and (max-width: 575px) {
            .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
                justify-content: center;
                text-align:center;
            }
        }
    </style>
    <?php
}
add_action( 'wp_head', 'aster_startup_footer_copyright_alignment_css' );

//Copyright Font Size
function aster_startup_copyright_font_size_css() {
    $aster_startup_copyright_font_size = get_theme_mod('aster_startup_copyright_font_size', 16);
    ?>
    <style type="text/css">
        .site-footer-bottom .site-info span {
            font-size: <?php echo esc_attr($aster_startup_copyright_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_copyright_font_size_css');

// Preloader Background Color Setting
function aster_startup_preloader_background_colors_css() {
    $aster_startup_preloader_background_color_setting = get_theme_mod('aster_startup_preloader_background_color_setting', '');
        // Only output CSS if a color is set
        if (empty($aster_startup_preloader_background_color_setting)) {
            return;
        }
    ?>
    <style type="text/css">
        #loader {
            background-color: <?php echo esc_attr($aster_startup_preloader_background_color_setting); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_preloader_background_colors_css');

// Preloader Background Image Setting
function aster_startup_preloader_background_image_css() {
    $aster_startup_preloader_background_image_setting = get_theme_mod('aster_startup_preloader_background_image_setting', '');
        // Only output CSS if the background image is set
        if (empty($aster_startup_preloader_background_image_setting)) {
            return;
        }
    ?>
    <style type="text/css">
        #loader {
            background-image: url('<?php echo esc_url($aster_startup_preloader_background_image_setting); ?>');
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
        }
    </style>
    <?php
}
add_action('wp_head', 'aster_startup_preloader_background_image_css');

//Footer Heading Alignment
function aster_startup_footer_heading_alignment_css() {
    $aster_startup_footer_header_align = get_theme_mod( 'aster_startup_footer_header_align', 'left' );   
    ?>
    <style type="text/css">
        .site-footer h4, footer#colophon h2.wp-block-heading, footer#colophon .widgettitle, footer#colophon .widget-title {
            text-align: <?php echo esc_attr( $aster_startup_footer_header_align ); ?> 
        }
    </style>
    <?php
}
add_action( 'wp_head', 'aster_startup_footer_heading_alignment_css' );