<?php

/**
 * Dynamic CSS
 */
function aster_startup_dynamic_css() {
	$aster_startup_primary_color = get_theme_mod( 'primary_color', '#1678F4' );

	$aster_startup_site_title_font       = get_theme_mod( 'aster_startup_site_title_font', 'Oswald' );
	$aster_startup_site_description_font = get_theme_mod( 'aster_startup_site_description_font', 'Nunito' );
	$aster_startup_header_font           = get_theme_mod( 'aster_startup_header_font', 'Nunito' );
	$aster_startup_content_font             = get_theme_mod( 'aster_startup_content_font', 'Nunito' );

	// Enqueue Google Fonts
	$aster_startup_fonts_url = aster_startup_get_fonts_url();
	if ( ! empty( $aster_startup_fonts_url ) ) {
		wp_enqueue_style( 'aster-startup-google-fonts', esc_url( $aster_startup_fonts_url ), array(), null );
	}

	$aster_startup_custom_css  = '';
	$aster_startup_custom_css .= '
    /* Color */
    :root {
        --primary-color: ' . esc_attr( $aster_startup_primary_color ) . ';
        --header-text-color: ' . esc_attr( '#' . get_header_textcolor() ) . ';
    }
    ';

	$aster_startup_custom_css .= '
    /* Typography */
    :root {
        --font-heading: "' . esc_attr( $aster_startup_header_font ) . '", serif;
        --font-main: -apple-system, BlinkMacSystemFont, "' . esc_attr( $aster_startup_content_font ) . '", "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
    }

    body,
	button, input, select, optgroup, textarea, p {
        font-family: "' . esc_attr( $aster_startup_content_font ) . '", serif;
	}

	.site-identity p.site-title, h1.site-title a, h1.site-title, p.site-title a, .site-branding h1.site-title a {
        font-family: "' . esc_attr( $aster_startup_site_title_font ) . '", serif;
	}
    
	p.site-description {
        font-family: "' . esc_attr( $aster_startup_site_description_font ) . '", serif !important;
	}
    ';

	wp_add_inline_style( 'aster-startup-style', $aster_startup_custom_css );
}
add_action( 'wp_enqueue_scripts', 'aster_startup_dynamic_css', 99 );
