<?php
/**
 * Typography Setting
 *
 * @package aster_startup
 */

// Typography Setting
$wp_customize->add_section(
    'aster_startup_typography_setting',
    array(
        'panel' => 'aster_startup_theme_options',
        'title' => esc_html__( 'Typography Setting', 'aster-startup' ),
    )
);

$wp_customize->add_setting(
    'aster_startup_site_title_font',
    array(
        'default'           => 'Oswald',
        'sanitize_callback' => 'aster_startup_sanitize_google_fonts',
    )
);

$wp_customize->add_control(
    'aster_startup_site_title_font',
    array(
        'label'    => esc_html__( 'Site Title Font Family', 'aster-startup' ),
        'section'  => 'aster_startup_typography_setting',
        'settings' => 'aster_startup_site_title_font',
        'type'     => 'select',
        'choices'  => aster_startup_get_all_google_font_families(),
    )
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'aster_startup_site_description_font',
	array(
		'default'           => 'Nunito',
		'sanitize_callback' => 'aster_startup_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'aster_startup_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'aster-startup' ),
		'section'  => 'aster_startup_typography_setting',
		'settings' => 'aster_startup_site_description_font',
		'type'     => 'select',
		'choices'  => aster_startup_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'aster_startup_header_font',
	array(
		'default'           => 'Nunito',
		'sanitize_callback' => 'aster_startup_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'aster_startup_header_font',
	array(
		'label'    => esc_html__( 'Heading Font Family', 'aster-startup' ),
		'section'  => 'aster_startup_typography_setting',
		'settings' => 'aster_startup_header_font',
		'type'     => 'select',
		'choices'  => aster_startup_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'aster_startup_content_font',
	array(
		'default'           => 'Nunito',
		'sanitize_callback' => 'aster_startup_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'aster_startup_content_font',
	array(
		'label'    => esc_html__( 'Content Font Family', 'aster-startup' ),
		'section'  => 'aster_startup_typography_setting',
		'settings' => 'aster_startup_content_font',
		'type'     => 'select',
		'choices'  => aster_startup_get_all_google_font_families(),
	)
);
