<?php
/**
 * Header Options
 *
 * @package aster_startup
 */

// ---------------------------------------- GENERAL OPTIONBS ----------------------------------------------------
// ---------------------------------------- PRELOADER ----------------------------------------------------

$wp_customize->add_section(
	'aster_startup_general_options',
	array(
		'panel' => 'aster_startup_theme_options',
		'title' => esc_html__( 'General Options', 'aster-startup' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'aster_startup_preloader_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Aster_Startup_Separator_Custom_Control( $wp_customize, 'aster_startup_preloader_separator', array(
	'label' => __( 'Enable / Disable Site Preloader Section', 'aster-startup' ),
	'section' => 'aster_startup_general_options',
	'settings' => 'aster_startup_preloader_separator',
) ) );


// General Options - Enable Preloader.
$wp_customize->add_setting(
	'aster_startup_enable_preloader',
	array(
		'sanitize_callback' => 'aster_startup_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_preloader',
		array(
			'label'   => esc_html__( 'Enable Preloader', 'aster-startup' ),
			'section' => 'aster_startup_general_options',
		)
	)
);

// Preloader Style Setting
$wp_customize->add_setting(
    'aster_startup_preloader_style',
    array(
        'default'           => 'style1',
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    'aster_startup_preloader_style',
    array(
        'type'     => 'select',
        'label'    => esc_html__('Select Preloader Styles', 'aster-startup'),
		'active_callback' => 'aster_startup_is_preloader_style',
        'section'  => 'aster_startup_general_options',
        'choices'  => array(
            'style1' => esc_html__('Style 1', 'aster-startup'),
            'style2' => esc_html__('Style 2', 'aster-startup'),
            'style3' => esc_html__('Style 3', 'aster-startup'),
        ),
    )
);

// Preloader Background Color Setting
$wp_customize->add_setting(
	'aster_startup_preloader_background_color_setting',
	 array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 'aster_startup_preloader_background_color_setting', 
		array(
			'label' => __('Preloader Background Color', 'aster-startup'),
			'active_callback' => 'aster_startup_is_preloader_style',
			'section' => 'aster_startup_general_options',
		)
	)
);

// Preloader Background Image Setting
$wp_customize->add_setting(
	'aster_startup_preloader_background_image_setting', 
	array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize, 'aster_startup_preloader_background_image_setting',
		 array(
			'label' => __('Preloader Background Image', 'aster-startup'),
			'active_callback' => 'aster_startup_is_preloader_style',
			'section' => 'aster_startup_general_options',
		)
	)
);

// ---------------------------------------- PAGINATION ----------------------------------------------------

// Add Separator Custom Control
$wp_customize->add_setting( 'aster_startup_pagination_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Aster_Startup_Separator_Custom_Control( $wp_customize, 'aster_startup_pagination_separator', array(
	'label' => __( 'Enable / Disable Pagination Section', 'aster-startup' ),
	'section' => 'aster_startup_general_options',
	'settings' => 'aster_startup_pagination_separator',
) ) );

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'aster_startup_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'aster_startup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'aster-startup' ),
			'section'  => 'aster_startup_general_options',
			'settings' => 'aster_startup_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'aster_startup_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'aster_startup_sanitize_select',
	)
);

$wp_customize->add_control(
	'aster_startup_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'aster-startup' ),
		'section'         => 'aster_startup_general_options',
		'settings'        => 'aster_startup_pagination_type',
		'active_callback' => 'aster_startup_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'aster-startup' ),
			'numeric' => __( 'Numeric', 'aster-startup' ),
		),
	)
);

// ---------------------------------------- BREADCRUMB ----------------------------------------------------

// Add Separator Custom Control
$wp_customize->add_setting( 'aster_startup_breadcrumb_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Aster_Startup_Separator_Custom_Control( $wp_customize, 'aster_startup_breadcrumb_separators', array(
	'label' => __( 'Enable / Disable Breadcrumb Section', 'aster-startup' ),
	'section' => 'aster_startup_general_options',
	'settings' => 'aster_startup_breadcrumb_separators',
)));

// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'aster_startup_enable_breadcrumb',
	array(
		'sanitize_callback' => 'aster_startup_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'aster-startup' ),
			'section' => 'aster_startup_general_options',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'aster_startup_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'aster_startup_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'aster-startup' ),
		'active_callback' => 'aster_startup_is_breadcrumb_enabled',
		'section'         => 'aster_startup_general_options',
	)
);

// ---------------------------------------- Website layout ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'aster_startup_layuout_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Aster_Startup_Separator_Custom_Control( $wp_customize, 'aster_startup_layuout_separator', array(
	'label' => __( 'Website Layout Setting', 'aster-startup' ),
	'section' => 'aster_startup_general_options',
	'settings' => 'aster_startup_layuout_separator',
)));


$wp_customize->add_setting(
	'aster_startup_website_layout',
	array(
		'sanitize_callback' => 'aster_startup_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_website_layout',
		array(
			'label'   => esc_html__('Boxed Layout', 'aster-startup'),
			'section' => 'aster_startup_general_options',
		)
	)
);

$wp_customize->add_setting('aster_startup_layout_width_margin', array(
	'default'           => 50,
	'sanitize_callback' => 'aster_startup_sanitize_range_value',
));

$wp_customize->add_control(new Aster_Startup_Customize_Range_Control($wp_customize, 'aster_startup_layout_width_margin', array(
		'label'       => __('Set Width', 'aster-startup'),
		'description' => __('Adjust the width around the website layout by moving the slider. Use this setting to customize the appearance of your site to fit your design preferences.', 'aster-startup'),
		'section'     => 'aster_startup_general_options',
		'settings'    => 'aster_startup_layout_width_margin',
		'active_callback' => 'aster_startup_is_layout_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 130,
			'step' => 1,
		),
)));

// ---------------------------------------- HEADER OPTIONS ----------------------------------------------------

$wp_customize->add_section(
	'aster_startup_header_options',
	array(
		'panel' => 'aster_startup_theme_options',
		'title' => esc_html__( 'Header Options', 'aster-startup' ),
	)
);


// Add setting for sticky header
$wp_customize->add_setting(
	'aster_startup_enable_sticky_header',
	array(
		'sanitize_callback' => 'aster_startup_sanitize_switch',
		'default'           => false,
	)
);

// Add control for sticky header setting
$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_sticky_header',
		array(
			'label'   => esc_html__( 'Enable Sticky Header', 'aster-startup' ),
			'section' => 'aster_startup_header_options',
		)
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'aster_startup_enable_header_search_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'aster_startup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_header_search_section',
		array(
			'label'    => esc_html__( 'Enable Search Section', 'aster-startup' ),
			'section'  => 'aster_startup_header_options',
			'settings' => 'aster_startup_enable_header_search_section',
		)
	)
);

// Header Options - Contact Number.
$wp_customize->add_setting(
	'aster_startup_phone_topbar_number',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'aster_startup_phone_topbar_number',
	array(
		'label'           => esc_html__( 'Phone Number', 'aster-startup' ),
		'section'         => 'aster_startup_header_options',
		'type'            => 'text',
	)
);
// icon // 
$wp_customize->add_setting(
	'aster_startup_Call_header_icon',
	array(
        'default' => 'fas fa-phone',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Aster_Startup_Change_Icon_Control($wp_customize, 
	'aster_startup_Call_header_icon',
	array(
	    'label'   		=> __('Call Icon','aster-startup'),
	    'section' 		=> 'aster_startup_header_options',
		'iconset' => 'fa',
	))  
);

// Add Separator Custom Control
$wp_customize->add_setting( 'aster_startup_menu_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Aster_Startup_Separator_Custom_Control( $wp_customize, 'aster_startup_menu_separator', array(
	'label' => __( 'Menu Settings', 'aster-startup' ),
	'section' => 'aster_startup_header_options',
	'settings' => 'aster_startup_menu_separator',
)));

$wp_customize->add_setting( 'aster_startup_menu_font_size', array(
    'default'           => 13,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'aster_startup_menu_font_size', array(
    'type'        => 'number',
    'section'     => 'aster_startup_header_options',
    'label'       => __( 'Menu Font Size ', 'aster-startup' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));

// Add setting for menu font weight
$wp_customize->add_setting('aster_startup_menu_font_weight', array(
    'default'           => '700',
    'sanitize_callback' => 'sanitize_text_field',
));

// Add control for menu font weight
$wp_customize->add_control('aster_startup_menu_font_weight', array(
    'type'     => 'select',
    'section'  => 'aster_startup_header_options', 
    'label'    => __('Menu Font Weight', 'aster-startup'),
    'choices'  => array(
		'100' => __('100','aster-startup'),
		'200' => __('200','aster-startup'),
		'300' => __('300','aster-startup'),
		'400' => __('400','aster-startup'),
		'500' => __('500','aster-startup'),
		'600' => __('600','aster-startup'),
		'700' => __('700','aster-startup'),
		'800' => __('800','aster-startup'),
		'900' => __('900','aster-startup'),
    ),
));

$wp_customize->add_setting( 'aster_startup_menu_text_transform', array(
    'default'           => 'uppercase', // Default value for text transform
    'sanitize_callback' => 'sanitize_text_field',
) );

// Add control for menu text transform
$wp_customize->add_control( 'aster_startup_menu_text_transform', array(
    'type'     => 'select',
    'section'  => 'aster_startup_header_options', // Adjust the section as needed
    'label'    => __( 'Menu Text Transform', 'aster-startup' ),
    'choices'  => array(
        'none'       => __( 'None', 'aster-startup' ),
        'capitalize' => __( 'Capitalize', 'aster-startup' ),
        'uppercase'  => __( 'Uppercase', 'aster-startup' ),
        'lowercase'  => __( 'Lowercase', 'aster-startup' ),
    ),
) );

// Menu Text Color 
$wp_customize->add_setting(
	'aster_startup_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'aster_startup_menu_text_color', 
		array(
			'label' => __('Menu Color', 'aster-startup'),
			'section' => 'aster_startup_header_options',
		)
	)
);

// Sub Menu Text Color 
$wp_customize->add_setting(
	'aster_startup_sub_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'aster_startup_sub_menu_text_color', 
		array(
			'label' => __('Sub Menu Color', 'aster-startup'),
			'section' => 'aster_startup_header_options',
		)
	)
);

// ----------------------------------------SITE IDENTITY----------------------------------------------------

$wp_customize->add_setting( 'aster_startup_site_title_size', array(
    'default'           => 30, // Default font size in pixels
    'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
) );

// Add control for site title size
$wp_customize->add_control( 'aster_startup_site_title_size', array(
    'type'        => 'number',
    'section'     => 'title_tagline', // You can change this section to your preferred section
    'label'       => __( 'Site Title Font Size ', 'aster-startup' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
) );

// Site Title - Enable Setting.
$wp_customize->add_setting(
	'aster_startup_enable_site_title_setting',
	array(
		'default'           => true,
		'sanitize_callback' => 'aster_startup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_site_title_setting',
		array(
			'label'    => esc_html__( 'Disable Site Title', 'aster-startup' ),
			'section'  => 'title_tagline',
			'settings' => 'aster_startup_enable_site_title_setting',
		)
	)
);

// Tagline - Enable Setting.
$wp_customize->add_setting(
	'aster_startup_enable_tagline_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'aster_startup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_tagline_setting',
		array(
			'label'    => esc_html__( 'Enable Tagline', 'aster-startup' ),
			'section'  => 'title_tagline',
			'settings' => 'aster_startup_enable_tagline_setting',
		)
	)
);

$wp_customize->add_setting('aster_startup_site_logo_width', array(
    'default'           => 200,
    'sanitize_callback' => 'aster_startup_sanitize_range_value',
));

$wp_customize->add_control(new Aster_Startup_Customize_Range_Control($wp_customize, 'aster_startup_site_logo_width', array(
    'label'       => __('Adjust Site Logo Width', 'aster-startup'),
    'description' => __('This setting controls the Width of Site Logo', 'aster-startup'),
    'section'     => 'title_tagline',
    'settings'    => 'aster_startup_site_logo_width',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 400,
        'step' => 5,
    ),
)));