<?php
/**
 * Footer Options
 *
 * @package aster_startup
 */

$wp_customize->add_section(
	'aster_startup_footer_options',
	array(
		'panel' => 'aster_startup_theme_options',
		'title' => esc_html__( 'Footer Options', 'aster-startup' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'aster_startup_footer_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Aster_Startup_Separator_Custom_Control( $wp_customize, 'aster_startup_footer_separators', array(
	'label' => __( 'Footer Settings', 'aster-startup' ),
	'section' => 'aster_startup_footer_options',
	'settings' => 'aster_startup_footer_separators',
)));

// Footer Section - Enable Section.
$wp_customize->add_setting(
	'aster_startup_enable_footer_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'aster_startup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_footer_section',
		array(
			'label'    => esc_html__( 'Show / Hide Footer', 'aster-startup' ),
			'section'  => 'aster_startup_footer_options',
			'settings' => 'aster_startup_enable_footer_section',
		)
	)
);

// column // 
$wp_customize->add_setting(
	'aster_startup_footer_widget_column',
	array(
        'default'			=> '4',
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'aster_startup_sanitize_select',
		
	)
);	

$wp_customize->add_control(
	'aster_startup_footer_widget_column',
	array(
	    'label'   		=> __('Select Widget Column','aster-startup'),
		'description' => __('Note: Default footer widgets are shown. Add your preferred widgets in (Appearance > Widgets > Footer) to see changes.', 'aster-startup'),
	    'section' 		=> 'aster_startup_footer_options',
		'type'			=> 'select',
		'choices'        => 
		array(
			'' => __( 'None', 'aster-startup' ),
			'1' => __( '1 Column', 'aster-startup' ),
			'2' => __( '2 Column', 'aster-startup' ),
			'3' => __( '3 Column', 'aster-startup' ),
			'4' => __( '4 Column', 'aster-startup' )
		) 
	) 
);

//  BG Color // 
$wp_customize->add_setting('footer_background_color_setting', array(
    'default' => '#1678F4',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_background_color_setting', array(
    'label' => __('Footer Background Color', 'aster-startup'),
    'section' => 'aster_startup_footer_options',
)));

// Footer Background Image Setting
$wp_customize->add_setting('footer_background_image_setting', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_background_image_setting', array(
    'label' => __('Footer Background Image', 'aster-startup'),
    'section' => 'aster_startup_footer_options',
)));

// Footer Background Attachment
$wp_customize->add_setting(
	'aster_startup_footer_image_attachment_setting',
	array(
		'default'=> 'scroll',
		'sanitize_callback' => 'aster_startup_sanitize_choices'
	)
);

$wp_customize->add_control(
	'aster_startup_footer_image_attachment_setting',
	array(
		'type' => 'select',
		'label' => __('Footer Background Attatchment','aster-startup'),
		'choices' => array(
			'fixed' => __('fixed','aster-startup'),
			'scroll' => __('scroll','aster-startup'),
		),
		'section'=> 'aster_startup_footer_options',
  	)
);

//Footer Image Position
$wp_customize->add_setting(
	'aster_startup_footer_img_position_setting',
	array(
        'default'			=> 'center center',
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'aster_startup_sanitize_choices',
		
	)
);	

$wp_customize->add_control(
	'aster_startup_footer_img_position_setting',
	array(
		'label'   		=> __('Footer Image Position','aster-startup'),
	    'section' 		=> 'aster_startup_footer_options',
		'type'			=> 'select',
		'choices'       => 
		array(
			'center center'   => __( 'Center', 'aster-startup' ),
			'center top'   	  => __( 'Top', 'aster-startup' ),
			'center bottom'   => __( 'Bottom', 'aster-startup' ),
		) 
	) 
);

$wp_customize->add_setting('footer_text_transform', array(
    'default' => 'none',
    'sanitize_callback' => 'sanitize_text_field',
));

// Add Footer Text Transform Control
$wp_customize->add_control('footer_text_transform', array(
    'label' => __('Footer Heading Text Transform', 'aster-startup'),
    'section' => 'aster_startup_footer_options',
    'settings' => 'footer_text_transform',
    'type' => 'select',
    'choices' => array(
        'none' => __('None', 'aster-startup'),
        'capitalize' => __('Capitalize', 'aster-startup'),
        'uppercase' => __('Uppercase', 'aster-startup'),
        'lowercase' => __('Lowercase', 'aster-startup'),
    ),
));

// Footer Heading Alignment
$wp_customize->add_setting(
	'aster_startup_footer_header_align',
	array(
		'default' 			=> 'left',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'aster_startup_footer_header_align',
	array(
		'label' => __('Footer Heading Alignment ','aster-startup'),
		'section' => 'aster_startup_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','aster-startup'),
			'right' => __('Right','aster-startup'),
			'center' => __('Center','aster-startup'),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'aster_startup_copyright_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Aster_Startup_Separator_Custom_Control( $wp_customize, 'aster_startup_copyright_separators', array(
	'label' => __( 'Copyright Settings', 'aster-startup' ),
	'section' => 'aster_startup_footer_options',
	'settings' => 'aster_startup_copyright_separators',
)));

// Copyright Section - Enable Section.
$wp_customize->add_setting(
	'aster_startup_enable_copyright_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'aster_startup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_copyright_section',
		array(
			'label'    => esc_html__( 'Show / Hide Copyright', 'aster-startup' ),
			'section'  => 'aster_startup_footer_options',
			'settings' => 'aster_startup_enable_copyright_section',
		)
	)
);

$wp_customize->add_setting(
	'aster_startup_footer_copyright_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses_post',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'aster_startup_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'aster-startup' ),
		'section'  => 'aster_startup_footer_options',
		'settings' => 'aster_startup_footer_copyright_text',
		'type'     => 'textarea',
	)
);

//Copyright Alignment
$wp_customize->add_setting(
	'aster_startup_footer_bottom_align',
	array(
		'default' 			=> 'center',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'aster_startup_footer_bottom_align',
	array(
		'label' => __('Copyright Alignment ','aster-startup'),
		'section' => 'aster_startup_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','aster-startup'),
			'right' => __('Right','aster-startup'),
			'center' => __('Center','aster-startup'),
		),
	)
);

//Copyright Font Size
$wp_customize->add_setting( 
	'aster_startup_copyright_font_size', 
	array(
		'default'           => 16,
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control( 'aster_startup_copyright_font_size', 
	array(
		'type'        => 'number',
		'section'     => 'aster_startup_footer_options',
		'label'       => __( 'Copyright Font Size ', 'aster-startup' ),
		'input_attrs' => 
		array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'aster_startup_scroll_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Aster_Startup_Separator_Custom_Control( $wp_customize, 'aster_startup_scroll_separators', array(
	'label' => __( 'Scroll Top Settings', 'aster-startup' ),
	'section' => 'aster_startup_footer_options',
	'settings' => 'aster_startup_scroll_separators',
)));

// Footer Options - Scroll Top.
$wp_customize->add_setting(
	'aster_startup_scroll_top',
	array(
		'sanitize_callback' => 'aster_startup_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_scroll_top',
		array(
			'label'   => esc_html__( 'Enable Scroll Top Button', 'aster-startup' ),
			'section' => 'aster_startup_footer_options',
		)
	)
);
// icon // 
$wp_customize->add_setting(
	'aster_startup_scroll_btn_icon',
	array(
        'default' => 'fas fa-chevron-up',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Aster_Startup_Change_Icon_Control($wp_customize, 
	'aster_startup_scroll_btn_icon',
	array(
	    'label'   		=> __('Scroll Top Icon','aster-startup'),
	    'section' 		=> 'aster_startup_footer_options',
		'iconset' => 'fa',
	))  
);


$wp_customize->add_setting( 'aster_startup_scroll_top_position', array(
    'default'           => 'bottom-right',
    'sanitize_callback' => 'aster_startup_sanitize_scroll_top_position',
) );

// Add control for Scroll Top Button Position
$wp_customize->add_control( 'aster_startup_scroll_top_position', array(
    'label'    => __( 'Scroll Top Button Position', 'aster-startup' ),
    'section'  => 'aster_startup_footer_options',
    'settings' => 'aster_startup_scroll_top_position',
    'type'     => 'select',
    'choices'  => array(
        'bottom-right' => __( 'Bottom Right', 'aster-startup' ),
        'bottom-left'  => __( 'Bottom Left', 'aster-startup' ),
        'bottom-center'=> __( 'Bottom Center', 'aster-startup' ),
    ),
) );

$wp_customize->add_setting( 'aster_startup_scroll_top_shape', array(
    'default'           => 'box',
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'aster_startup_scroll_top_shape', array(
    'label'    => __( 'Scroll to Top Button Shape', 'aster-startup' ),
    'section'  => 'aster_startup_footer_options',
    'settings' => 'aster_startup_scroll_top_shape',
    'type'     => 'radio',
    'choices'  => array(
        'box'        => __( 'Box', 'aster-startup' ),
        'curved-box' => __( 'Curved Box', 'aster-startup' ),
        'circle'     => __( 'Circle', 'aster-startup' ),
    ),
) );