<?php
/**
 * Excerpt
 *
 * @package aster_startup
 */

$wp_customize->add_section(
	'aster_startup_excerpt_options',
	array(
		'panel' => 'aster_startup_theme_options',
		'title' => esc_html__( 'Excerpt', 'aster-startup' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'aster_startup_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'absint',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'aster_startup_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'aster-startup' ),
		'section'     => 'aster_startup_excerpt_options',
		'settings'    => 'aster_startup_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 10,
			'max'  => 200,
			'step' => 1,
		),
	)
);