<?php

function aster_startup_sanitize_select( $aster_startup_input, $aster_startup_setting ) {
	$aster_startup_input = sanitize_key( $aster_startup_input );
	$aster_startup_choices = $aster_startup_setting->manager->get_control( $aster_startup_setting->id )->choices;
	return ( array_key_exists( $aster_startup_input, $aster_startup_choices ) ? $aster_startup_input : $aster_startup_setting->default );
}

function aster_startup_sanitize_switch( $aster_startup_input ) {
	if ( true === $aster_startup_input ) {
		return true;
	} else {
		return false;
	}
}

function aster_startup_sanitize_google_fonts( $aster_startup_input, $aster_startup_setting ) {
	$aster_startup_choices = $aster_startup_setting->manager->get_control( $aster_startup_setting->id )->choices;
	return ( array_key_exists( $aster_startup_input, $aster_startup_choices ) ? $aster_startup_input : $aster_startup_setting->default );
}
/**
 * Sanitize HTML input.
 *
 * @param string $aster_startup_input HTML input to sanitize.
 * @return string Sanitized HTML.
 */
function aster_startup_sanitize_html( $aster_startup_input ) {
    return wp_kses_post( $aster_startup_input );
}

/**
 * Sanitize URL input.
 *
 * @param string $aster_startup_input URL input to sanitize.
 * @return string Sanitized URL.
 */
function aster_startup_sanitize_url( $aster_startup_input ) {
    return esc_url_raw( $aster_startup_input );
}

// Sanitize Scroll Top Position
function aster_startup_sanitize_scroll_top_position( $aster_startup_input ) {
    $valid_positions = array( 'bottom-right', 'bottom-left', 'bottom-center' );
    if ( in_array( $aster_startup_input, $valid_positions ) ) {
        return $aster_startup_input;
    } else {
        return 'bottom-right'; // Default to bottom-right if invalid value
    }
}

function aster_startup_sanitize_choices( $aster_startup_input, $aster_startup_setting ) {
	global $wp_customize; 
	$aster_startup_control = $wp_customize->get_control( $aster_startup_setting->id ); 
	if ( array_key_exists( $aster_startup_input, $aster_startup_control->choices ) ) {
		return $aster_startup_input;
	} else {
		return $aster_startup_setting->default;
	}
}

function aster_startup_sanitize_range_value( $aster_startup_number, $aster_startup_setting ) {

	// Ensure input is an absolute integer.
	$aster_startup_number = absint( $aster_startup_number );

	// Get the input attributes associated with the setting.
	$aster_startup_atts = $aster_startup_setting->manager->get_control( $aster_startup_setting->id )->input_attrs;

	// Get minimum number in the range.
	$aster_startup_min = ( isset( $aster_startup_atts['min'] ) ? $aster_startup_atts['min'] : $aster_startup_number );

	// Get maximum number in the range.
	$aster_startup_max = ( isset( $aster_startup_atts['max'] ) ? $aster_startup_atts['max'] : $aster_startup_number );

	// Get step.
	$aster_startup_step = ( isset( $aster_startup_atts['step'] ) ? $aster_startup_atts['step'] : 1 );

	// If the number is within the valid range, return it; otherwise, return the default.
	return ( $aster_startup_min <= $aster_startup_number && $aster_startup_number <= $aster_startup_max && is_int( $aster_startup_number / $aster_startup_step ) ? $aster_startup_number : $aster_startup_setting->default );
}