<?php
/**
 * Services Section
 *
 * @package aster_startup
 */

$wp_customize->add_section(
	'aster_startup_services_section',
	array(
		'panel'    => 'aster_startup_front_page_options',
		'title'    => esc_html__( 'Services Section', 'aster-startup' ),
		'priority' => 10,
	)
);

// Services Section - Enable Section.
$wp_customize->add_setting(
	'aster_startup_enable_service_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'aster_startup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_service_section',
		array(
			'label'    => esc_html__( 'Enable Services Section', 'aster-startup' ),
			'section'  => 'aster_startup_services_section',
			'settings' => 'aster_startup_enable_service_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'aster_startup_enable_service_section',
		array(
			'selector' => '#aster_startup_service_section .section-link',
			'settings' => 'aster_startup_enable_service_section',
		)
	);
}

// Services Section - Short Heading.
$wp_customize->add_setting(
	'aster_startup_services_short_heading',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'aster_startup_services_short_heading',
	array(
		'label'           => esc_html__( 'Short Heading', 'aster-startup' ),
		'section'         => 'aster_startup_services_section',
		'settings'        => 'aster_startup_services_short_heading',
		'type'            => 'text',
		'active_callback' => 'aster_startup_is_service_section_enabled',
	)
);

// Services Section - Heading.
$wp_customize->add_setting(
	'aster_startup_services_heading',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'aster_startup_services_heading',
	array(
		'label'           => esc_html__( 'Heading', 'aster-startup' ),
		'section'         => 'aster_startup_services_section',
		'settings'        => 'aster_startup_services_heading',
		'type'            => 'text',
		'active_callback' => 'aster_startup_is_service_section_enabled',
	)
);

$args = array(
	'type'                     => 'post', 
	'child_of'                 => 0,
	'parent'                   => '',
	'orderby'                  => 'term_group',
	'order'                    => 'ASC',
	'hide_empty'               => false,
	'hierarchical'             => 1,
	'number'                   => '',
	'taxonomy'                 => 'category',
	'pad_counts'               => false
);
$aster_startup_categories = get_categories($args);
$cat_posts = array();
$m = 0;
$cat_posts[] = 'Select';

foreach($aster_startup_categories as $category){
	if($m == 0){
		$default = $category->slug;
		$m++;
	}
	$cat_posts[$category->slug] = $category->name;
}

$wp_customize->add_setting('aster_startup_trending_post_category', array(
	'default'	=> 'services',
	'sanitize_callback' => 'aster_startup_sanitize_select',
));

$wp_customize->add_control('aster_startup_trending_post_category', array(
	'type'    => 'select',
	'choices' => $cat_posts,
	'label'   => __('Select category to display posts ','aster-startup'),
	'section' => 'aster_startup_services_section', // Adjust the section as needed
	'active_callback' => 'aster_startup_is_service_section_enabled',
));

for ($i=1; $i <=9 ; $i++) { 
	// icon // 
	$wp_customize->add_setting(
		'aster_startup_services_icon'.$i,
		array(
	        'default' => 'fas fa-laptop',
			'sanitize_callback' => 'sanitize_text_field',
			'capability' => 'edit_theme_options',
			
		)
	);	

	$wp_customize->add_control(new Aster_Startup_Change_Icon_Control($wp_customize, 
		'aster_startup_services_icon' .$i,
		array(
		    'label'   		=> __('Service Icon ','aster-startup') .$i,
		    'section' 		=> 'aster_startup_services_section',
			'iconset' => 'fa',
		))  
	);
}