<?php
/**
 * Banner Section
 *
 * @package aster_startup
 */

$wp_customize->add_section(
	'aster_startup_banner_section',
	array(
		'panel'    => 'aster_startup_front_page_options',
		'title'    => esc_html__( 'Banner Section', 'aster-startup' ),
		'priority' => 10,
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'aster_startup_enable_banner_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'aster_startup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Aster_Startup_Toggle_Switch_Custom_Control(
		$wp_customize,
		'aster_startup_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'aster-startup' ),
			'section'  => 'aster_startup_banner_section',
			'settings' => 'aster_startup_enable_banner_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'aster_startup_enable_banner_section',
		array(
			'selector' => '#aster_startup_banner_section .section-link',
			'settings' => 'aster_startup_enable_banner_section',
		)
	);
}

// Banner Section - Banner Slider Content Type.
$wp_customize->add_setting(
	'aster_startup_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'aster_startup_sanitize_select',
	)
);

$wp_customize->add_control(
	'aster_startup_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Select Banner Slider Content Type', 'aster-startup' ),
		'section'         => 'aster_startup_banner_section',
		'settings'        => 'aster_startup_banner_slider_content_type',
		'type'            => 'select',
		'active_callback' => 'aster_startup_is_banner_slider_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'aster-startup' ),
			'post' => esc_html__( 'Post', 'aster-startup' ),
		),
	)
);

for ( $aster_startup_i = 1; $aster_startup_i <= 3; $aster_startup_i++ ) {

	// Banner Section - Select Banner Post.
	$wp_customize->add_setting(
		'aster_startup_banner_slider_content_post_' . $aster_startup_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'aster_startup_banner_slider_content_post_' . $aster_startup_i,
		array(
			// translators: %d is the post number
			'label'           => sprintf( esc_html__( 'Select Post %d', 'aster-startup' ), $aster_startup_i ),
			'section'         => 'aster_startup_banner_section',
			'settings'        => 'aster_startup_banner_slider_content_post_' . $aster_startup_i,
			'active_callback' => 'aster_startup_is_banner_slider_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => aster_startup_get_post_choices(),
		)
	);

	// Banner Section - Select Banner Page.
	$wp_customize->add_setting(
		'aster_startup_banner_slider_content_page_' . $aster_startup_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'aster_startup_banner_slider_content_page_' . $aster_startup_i,
		array(
			// translators: %d is the page number
			'label'           => sprintf( esc_html__( 'Select Page %d', 'aster-startup' ), $aster_startup_i ),
			'section'         => 'aster_startup_banner_section',
			'settings'        => 'aster_startup_banner_slider_content_page_' . $aster_startup_i,
			'active_callback' => 'aster_startup_is_banner_slider_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => aster_startup_get_page_choices(),
		)
	);

	// Banner Section - Button Label.
	$wp_customize->add_setting(
		'aster_startup_banner_button_label_' . $aster_startup_i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'aster_startup_banner_button_label_' . $aster_startup_i,
		array(
			'label'           => sprintf( esc_html__( 'Button Label', 'aster-startup' )),
			'section'         => 'aster_startup_banner_section',
			'settings'        => 'aster_startup_banner_button_label_' . $aster_startup_i,
			'type'            => 'text',
			'active_callback' => 'aster_startup_is_banner_slider_section_enabled',
		)
	);

	// Banner Section - Button Link.
	$wp_customize->add_setting(
		'aster_startup_banner_button_link_' . $aster_startup_i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'aster_startup_banner_button_link_' . $aster_startup_i,
		array(
			'label'           => sprintf( esc_html__( 'Button Link', 'aster-startup' )  ),
			'section'         => 'aster_startup_banner_section',
			'settings'        => 'aster_startup_banner_button_link_' . $aster_startup_i,
			'type'            => 'url',
			'active_callback' => 'aster_startup_is_banner_slider_section_enabled',
		)
	);
}