<?php

if ( ! get_theme_mod( 'aster_startup_enable_service_section', true ) ) {
	return;
}

$aster_startup_args = '';

aster_startup_render_service_section( $aster_startup_args );

/**
 * Render Service Section.
 */
function aster_startup_render_service_section( $aster_startup_args ) { ?>
	<section id="aster_startup_trending_section" class="asterthemes-frontpage-section trending-section trending-style-1">
		<div class="asterthemes-wrapper">
			<?php
			if ( is_customize_preview() ) :
				aster_startup_section_link( 'aster_startup_service_section' );
			endif;

			$aster_startup_services_short_heading = get_theme_mod( 'aster_startup_services_short_heading', '' );
			$aster_startup_services_heading = get_theme_mod( 'aster_startup_services_heading', '' );
			?>
			<div class="product-contact-inner">
				<?php if ( ! empty( $aster_startup_services_short_heading || $aster_startup_services_heading ) ) { ?>
					<div class="section-heading">
						<h4><?php echo esc_html( $aster_startup_services_short_heading ); ?></h4>
						<h3><?php echo esc_html( $aster_startup_services_heading ); ?></h3>
					</div>
				<?php } ?>
			</div>
		   	<?php $aster_startup_catData = get_theme_mod('aster_startup_trending_post_category',''); ?>
	        <div class="owl-carousel">
		        <?php  $args = array(
	                    'post_type' => 'post', // Changed from 'product' to 'post'
	                    'posts_per_page' => 9,
	                    'category_name' => $aster_startup_catData, // Filter by category slug
	                    'order' => 'ASC'
	                );?>
                <?php $loop = new WP_Query( $args );
                $i=1;
                while ( $loop->have_posts() ) : $loop->the_post(); ?>
                    <div class="tab-post">
                        <figure>
                            <?php if ( has_post_thumbnail() ) : ?>
							    <?php the_post_thumbnail( 'full' ); ?>
							<?php else : ?>
							    <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/resource/img/default.png" alt="Default Image" />
							<?php endif; ?>
                        </figure>
                        <div class="post-content">
                        	<div class="heading-post">
                        		<span><i class="<?php echo esc_attr(get_theme_mod('aster_startup_services_icon' .$i,'fas fa-laptop')); ?>"></i></span>
                        		<h5 class="post-text"><a href="<?php echo esc_url(get_permalink( $loop->post->ID )); ?>"><?php the_title(); ?></a></h5>
                        		<div class="caption-description">
									<p>
										<?php echo wp_kses_post( wp_trim_words( get_the_content(), 15 ) ); ?>
									</p>
								</div>
                        	</div>
                        </div>
                        <div class="post-btn">
                    		<a href="<?php echo esc_url(get_permalink( $loop->post->ID )); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1.5em"  viewBox="0 0 448 512"><!--!Font Awesome Free 7.0.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M438.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.8 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l306.7 0L233.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"/></svg></a>
                    	</div>
                    </div>
                <?php $i++; endwhile; wp_reset_postdata(); ?>
		    </div>
		</div>	    	
	</section>
	<?php
}
