<?php
/**
 * Aster Startup functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package aster_startup
 */

$aster_startup_theme_data = wp_get_theme();
if( ! defined( 'ASTER_STARTUP_THEME_VERSION' ) ) define ( 'ASTER_STARTUP_THEME_VERSION', $aster_startup_theme_data->get( 'Version' ) );
if( ! defined( 'ASTER_STARTUP_THEME_NAME' ) ) define( 'ASTER_STARTUP_THEME_NAME', $aster_startup_theme_data->get( 'Name' ) );
if( ! defined( 'ASTER_STARTUP_THEME_TEXTDOMAIN' ) ) define( 'ASTER_STARTUP_THEME_TEXTDOMAIN', $aster_startup_theme_data->get( 'TextDomain' ) );

if ( ! defined( 'ASTER_STARTUP_VERSION' ) ) {
	define( 'ASTER_STARTUP_VERSION', '1.0.0' );
}

if ( ! function_exists( 'aster_startup_setup' ) ) :
	
	function aster_startup_setup() {
		
		load_theme_textdomain( 'aster-startup', get_template_directory() . '/languages' );

		add_theme_support( 'woocommerce' );

		add_theme_support( 'automatic-feed-links' );
		
		add_theme_support( 'title-tag' );

		add_theme_support( 'post-thumbnails' );

		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary', 'aster-startup' ),
				'social'  => esc_html__( 'Social', 'aster-startup' ),
			)
		);

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'woocommerce',
			)
		);

		add_theme_support( 'post-formats', array(
			'image',
			'video',
			'gallery',
			'audio', 
		) );

		add_theme_support(
			'custom-background',
			apply_filters(
				'aster_startup_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );

		/*
		* This theme styles the visual editor to resemble the theme style,
		* specifically font, colors, icons, and column width.
		*/
		add_editor_style( '/resource/css/editor-style.css' );
	}
endif;
add_action( 'after_setup_theme', 'aster_startup_setup' );

function aster_startup_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'aster_startup_content_width', 640 );
}
add_action( 'after_setup_theme', 'aster_startup_content_width', 0 );

function aster_startup_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'aster-startup' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'aster-startup' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
	);

	// Regsiter 4 footer widgets.
	$aster_startup_footer_widget_column = get_theme_mod('aster_startup_footer_widget_column','4');
	for ($aster_startup_i=1; $aster_startup_i<=$aster_startup_footer_widget_column; $aster_startup_i++) {
		register_sidebar( array(
			'name' => __( 'Footer  ', 'aster-startup' )  . $aster_startup_i,
			'id' => 'aster-startup-footer-widget-' . $aster_startup_i,
			'description' => __( 'The Footer Widget Area', 'aster-startup' )  . $aster_startup_i,
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="widget-header"><h4 class="widget-title">',
			'after_title' => '</h4></div>',
		) );
	}
}
add_action( 'widgets_init', 'aster_startup_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function aster_startup_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	// Slick style.
	wp_enqueue_style( 'slick-style', get_template_directory_uri() . '/resource/css/slick' . $min . '.css', array(), '1.8.1' );

	// Owl Carousel style.
	wp_enqueue_style( 'owl-carousel-css', get_template_directory_uri() . '/resource/css/owl.carousel' . '.css', array(), '2.3.4' );

	// Fontawesome style.
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri())."/resource/css/fontawesome-all.css" );

	// Main style.
	wp_enqueue_style( 'aster-startup-style', get_template_directory_uri() . '/style.css', array(), ASTER_STARTUP_VERSION );

	// RTL style.
	wp_style_add_data('aster-startup-style', 'rtl', 'replace');
		
	// Animate CSS
	wp_enqueue_style( 'animate-style', get_template_directory_uri() . '/resource/css/animate.css' );

	// Navigation script.
	wp_enqueue_script( 'aster-startup-navigation-script', get_template_directory_uri() . '/resource/js/navigation.js', array(), ASTER_STARTUP_VERSION, true );

	// Owl Carousel.
	wp_enqueue_script( 'owl-carouselscript', get_template_directory_uri() . '/resource/js/owl.carousel' . '.js', array( 'jquery' ), '2.3.4', true );

	// Slick script.
	wp_enqueue_script( 'slick-script', get_template_directory_uri() . '/resource/js/slick' . $min . '.js', array( 'jquery' ), '1.8.1', true );

	// Custom script.
	wp_enqueue_script( 'aster-startup-custom-script', get_template_directory_uri() . '/resource/js/custom.js', array( 'jquery' ), ASTER_STARTUP_VERSION, true );

	// Wow script.
	wp_enqueue_script( 'wow-jquery', get_template_directory_uri() . '/resource/js/wow.js', array('jquery'),'' ,true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// Include the file.
	require_once get_theme_file_path( 'theme-library/function-files/wptt-webfont-loader.php' );
}
add_action( 'wp_enqueue_scripts', 'aster_startup_scripts' );

//Change number of products per page 
add_filter( 'loop_shop_per_page', 'aster_startup_products_per_page' );
function aster_startup_products_per_page( $cols ) {
  	return  get_theme_mod( 'aster_startup_products_per_page',9);
}

// Change number or products per row 
add_filter('loop_shop_columns', 'aster_startup_loop_columns');
	if (!function_exists('aster_startup_loop_columns')) {
	function aster_startup_loop_columns() {
		return get_theme_mod( 'aster_startup_products_per_row', 3 );
	}
}

/**
 * Include wptt webfont loader.
 */
require_once get_theme_file_path( 'theme-library/function-files/wptt-webfont-loader.php' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/theme-library/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/theme-library/function-files/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/theme-library/function-files/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/theme-library/customizer.php';

/**
 * Google Fonts
 */
require get_template_directory() . '/theme-library/function-files/google-fonts.php';

/**
 * Dynamic CSS
 */
require get_template_directory() . '/theme-library/dynamic-css.php';

/**
 * Breadcrumb
 */
require get_template_directory() . '/theme-library/function-files/class-breadcrumb-trail.php';

/**
 * Getting Started
*/
require get_template_directory() . '/theme-library/getting-started/getting-started.php';

function aster_startup_links_setup() {
	if ( ! defined( 'ASTER_STARTUP_PREMIUM_PAGE' ) ) {
	define('ASTER_STARTUP_PREMIUM_PAGE',__('https://asterthemes.com/products/startup-business-wordpress-theme','aster-startup'));
	}
	if ( ! defined( 'ASTER_STARTUP_THEME_PAGE' ) ) {
		define('ASTER_STARTUP_THEME_PAGE',__('https://asterthemes.com/products/aster-startup','aster-startup'));
	}
	if ( ! defined( 'ASTER_STARTUP_SUPPORT' ) ) {
	define('ASTER_STARTUP_SUPPORT',__('https://wordpress.org/support/theme/aster-startup/','aster-startup'));
	}
	if ( ! defined( 'ASTER_STARTUP_REVIEW' ) ) {
	define('ASTER_STARTUP_REVIEW',__('https://wordpress.org/support/theme/aster-startup/reviews/','aster-startup'));
	}
	if ( ! defined( 'ASTER_STARTUP_PRO_DEMO' ) ) {
	define('ASTER_STARTUP_PRO_DEMO',__('https://demo.asterthemes.com/startup-business/','aster-startup'));
	}
	if ( ! defined( 'ASTER_STARTUP_THEME_DOCUMENTATION' ) ) {
	define('ASTER_STARTUP_THEME_DOCUMENTATION',__('https://demo.asterthemes.com/docs/startup-business-free/','aster-startup'));
	}
	if ( ! defined( 'ASTER_STARTUP_PREMIUM_DOCUMENTATION' ) ) {
	define('ASTER_STARTUP_PREMIUM_DOCUMENTATION',__('https://demo.asterthemes.com/docs/startup-business-pro/','aster-startup'));
	}
	if ( ! defined( 'ASTER_STARTUP_BUNDLE_PAGE' ) ) {
		define('ASTER_STARTUP_BUNDLE_PAGE',__('https://asterthemes.com/products/wp-theme-bundle','aster-startup'));
	}
}
add_action('after_setup_theme', 'aster_startup_links_setup');

/**
 * Theme Wizard
*/
add_action( 'init', 'aster_startup_load_theme_wizard' );
function aster_startup_load_theme_wizard() {
    require get_parent_theme_file_path( '/theme-wizard/config.php' );
}

// Enqueue Customizer live preview script
function aster_startup_customizer_live_preview() {
    wp_enqueue_script(
        'aster-startup-customizer',
        get_template_directory_uri() . '/js/customizer.js',
        array('jquery', 'customize-preview'),
        '',
        true
    );
}
add_action('customize_preview_init', 'aster_startup_customizer_live_preview');

// Featured Image Dimension
function aster_startup_blog_post_featured_image_dimension(){
	if(get_theme_mod('aster_startup_blog_post_featured_image_dimension') == 'custom' ) {
		return true;
	}
	return false;
}

/**
 * Customizer Settings Functions
*/
require get_template_directory() . '/theme-library/function-files/customizer-settings-functions.php';