(function(api) {

    api.sectionConstructor['ascendoor-magazine-upsell'] = api.Section.extend({

        // Remove events for this section.
        attachEvents: function() {},

        // Ensure this section is active. Normally, sections without contents aren't visible.
        isContextuallyActive: function() {
            return true;
        }
    });

    const ascendoor_magazine_section_lists = ['flash-news', 'banner', 'post-carousel'];
    ascendoor_magazine_section_lists.forEach(ascendoor_magazine_homepage_scroll);

    function ascendoor_magazine_homepage_scroll(item, index) {
        // Detect when the front page sections section is expanded (or closed) so we can adjust the preview accordingly.
        item = item.replace(/-/g, '_');
        wp.customize.section('ascendoor_magazine_' + item + '_section', function(section) {
            section.expanded.bind(function(isExpanding) {
                // Value of isExpanding will = true if you're entering the section, false if you're leaving it.
                wp.customize.previewer.send(item, { expanded: isExpanding });
            });
        });
    }
})(wp.customize);