<?php
/**
 * Category Section
 * 
 * slug: artist-art-gallery/product-section
 * title: Product Section
 * categories: artist-art-gallery
 */

 $artist_art_gallery_plugins_list = get_option( 'active_plugins' );
 $artist_art_gallery_plugin = 'woocommerce/woocommerce.php';
 $artist_art_gallery_results = in_array( $artist_art_gallery_plugin , $artist_art_gallery_plugins_list);
 if ( $artist_art_gallery_results )  {

    return array(
        'title'      =>__( 'Product Section', 'artist-art-gallery' ),
        'categories' => array( 'artist-art-gallery' ),
        'content'    => '<!-- wp:spacer {"height":"40px"} -->
        <div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer -->

        <!-- wp:group {"className":"services-box","layout":{"type":"constrained","contentSize":"80%"}} -->
        <div class="wp-block-group services-box"><!-- wp:group {"className":"service-group","style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained","contentSize":"100%"}} -->
        <div class="wp-block-group service-group"><!-- wp:group {"className":"product-section-top"} -->
        <div class="wp-block-group product-section-top"><!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"},"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} -->
        <div class="wp-block-columns are-vertically-aligned-center" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"center","width":"","style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} -->
        <div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"textAlign":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontSize":"17px"}},"textColor":"tertiary","fontFamily":"roboto"} -->
        <h2 class="wp-block-heading has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family" style="font-size:17px">'. esc_html__('Our Shop','artist-art-gallery').'</h2>
        <!-- /wp:heading -->

        <!-- wp:heading {"textAlign":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontSize":"22px","fontStyle":"normal","fontWeight":"800"}},"textColor":"tertiary","fontFamily":"roboto"} -->
        <h2 class="wp-block-heading has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family" style="font-size:22px;font-style:normal;font-weight:800">'. esc_html__('Arts Gallery Shop','artist-art-gallery').'</h2>
        <!-- /wp:heading --></div>
        <!-- /wp:column -->

        <!-- wp:column {"verticalAlignment":"center","width":"300px","className":"product-top-button","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
        <div class="wp-block-column is-vertically-aligned-center product-top-button" style="flex-basis:300px"><!-- wp:buttons {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"medium","fontFamily":"roboto","layout":{"type":"flex","justifyContent":"right"}} -->
        <div class="wp-block-buttons has-custom-font-size has-roboto-font-family has-medium-font-size" style="font-style:normal;font-weight:400"><!-- wp:button {"backgroundColor":"accent","textColor":"white","className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"spacing":{"padding":{"left":"var:preset|spacing|50","right":"var:preset|spacing|50","top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}}} -->
        <div class="wp-block-button is-style-fill"><a class="wp-block-button__link has-white-color has-accent-background-color has-text-color has-background has-link-color wp-element-button" href="#" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--50)">'. esc_html__('Explore More','artist-art-gallery').'</a></div>
        <!-- /wp:button --></div>
        <!-- /wp:buttons --></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns --></div>
        <!-- /wp:group -->

        <!-- wp:group {"layout":{"type":"constrained","contentSize":"100%"}} -->
        <div class="wp-block-group"><!-- wp:woocommerce/product-collection {"queryId":1,"query":{"perPage":8,"pages":0,"offset":0,"postType":"product","order":"asc","orderBy":"title","search":"","exclude":[],"inherit":false,"taxQuery":[],"isProductCollectionBlock":true,"featured":false,"woocommerceOnSale":false,"woocommerceStockStatus":["instock","outofstock","onbackorder"],"woocommerceAttributes":[],"woocommerceHandPickedProducts":[],"filterable":true,"relatedBy":{"categories":true,"tags":true}},"tagName":"div","displayLayout":{"type":"flex","columns":4,"shrinkColumns":true},"dimensions":{"widthType":"fill"},"queryContextIncludes":["collection"],"__privatePreviewState":{"isPreview":false,"previewMessage":"Actual products will vary depending on the page being viewed."},"className":"dynamic-product-section"} -->
        <div class="wp-block-woocommerce-product-collection dynamic-product-section"><!-- wp:woocommerce/product-template {"className":"product-template-section"} -->
        <!-- wp:group {"className":"stack-img-cart","style":{"spacing":{"blockGap":"0","margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"center"}} -->
        <div class="wp-block-group stack-img-cart" style="margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0"><!-- wp:woocommerce/product-image {"showSaleBadge":false,"imageSizing":"thumbnail","isDescendentOfQueryLoop":true,"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0","left":"0","right":"0"}}}} /-->

        <!-- wp:columns {"className":"cart-wishlist-button","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0"}}}} -->
        <div class="wp-block-columns cart-wishlist-button" style="margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0"><!-- wp:column -->
        <div class="wp-block-column"><!-- wp:woocommerce/product-button {"isDescendentOfQueryLoop":true} /--></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns --></div>
        <!-- /wp:group -->

        <!-- wp:post-terms {"term":"product_cat","textAlign":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|secaccent"}}},"typography":{"fontStyle":"normal","fontWeight":"400"},"spacing":{"padding":{"top":"0","bottom":"0"},"margin":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}},"textColor":"secaccent","fontFamily":"roboto"} /-->

        <!-- wp:post-title {"textAlign":"left","level":3,"isLink":true,"style":{"spacing":{"margin":{"bottom":"0.75rem","top":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|secaccent"}}}},"textColor":"secaccent","fontSize":"upper-heading","fontFamily":"roboto","__woocommerceNamespace":"woocommerce/product-collection/product-title"} /-->

        <!-- wp:woocommerce/product-price {"isDescendentOfQueryLoop":true,"textAlign":"left","textColor":"secaccent","fontSize":"upper-heading","style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|secaccent"}}},"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0"}}}} /-->
        <!-- /wp:woocommerce/product-template --></div>
        <!-- /wp:woocommerce/product-collection --></div>
        <!-- /wp:group --></div>
        <!-- /wp:group --></div>
        <!-- /wp:group -->

        <!-- wp:spacer {"height":"40px"} -->
        <div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer -->',
    );

} else {

    return array(
        'title'      =>__( 'Product Section', 'artist-art-gallery' ),
        'categories' => array( 'artist-art-gallery' ),
        'content'    => '<!-- wp:spacer {"height":"40px"} -->
        <div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer -->

        <!-- wp:group {"className":"services-box","layout":{"type":"constrained","contentSize":"80%"}} -->
        <div class="wp-block-group services-box"><!-- wp:group {"className":"service-group","style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained","contentSize":"100%"}} -->
        <div class="wp-block-group service-group"><!-- wp:group {"className":"product-section-top"} -->
        <div class="wp-block-group product-section-top"><!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"},"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} -->
        <div class="wp-block-columns are-vertically-aligned-center" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"center","width":"","style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} -->
        <div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"textAlign":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontSize":"17px"}},"textColor":"tertiary","fontFamily":"roboto"} -->
        <h2 class="wp-block-heading has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family" style="font-size:17px">'. esc_html__('Our Shop','artist-art-gallery').'</h2>
        <!-- /wp:heading -->

        <!-- wp:heading {"textAlign":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontSize":"22px","fontStyle":"normal","fontWeight":"800"}},"textColor":"tertiary","fontFamily":"roboto"} -->
        <h2 class="wp-block-heading has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family" style="font-size:22px;font-style:normal;font-weight:800">'. esc_html__('Arts Gallery Shop','artist-art-gallery').'</h2>
        <!-- /wp:heading --></div>
        <!-- /wp:column -->

        <!-- wp:column {"verticalAlignment":"center","width":"300px","className":"product-top-button","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
        <div class="wp-block-column is-vertically-aligned-center product-top-button" style="flex-basis:300px"><!-- wp:buttons {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"medium","fontFamily":"roboto","layout":{"type":"flex","justifyContent":"right"}} -->
        <div class="wp-block-buttons has-custom-font-size has-roboto-font-family has-medium-font-size" style="font-style:normal;font-weight:400"><!-- wp:button {"backgroundColor":"accent","textColor":"white","className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"spacing":{"padding":{"left":"var:preset|spacing|50","right":"var:preset|spacing|50","top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}}} -->
        <div class="wp-block-button is-style-fill"><a class="wp-block-button__link has-white-color has-accent-background-color has-text-color has-background has-link-color wp-element-button" href="#" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--50)">'. esc_html__('Explore More','artist-art-gallery').'</a></div>
        <!-- /wp:button --></div>
        <!-- /wp:buttons --></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns --></div>
        <!-- /wp:group -->

        <!-- wp:columns {"className":"product-section-static","style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} -->
        <div class="wp-block-columns product-section-static" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"><!-- wp:column {"verticalAlignment":"center","className":"static-product wow pulse animated","style":{"spacing":{"blockGap":"var:preset|spacing|30","padding":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
        <div class="wp-block-column is-vertically-aligned-center static-product wow pulse animated" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":218,"sizeSlug":"full","linkDestination":"none"} -->
        <figure class="wp-block-image size-full"><img src="'.esc_url(get_template_directory_uri()) .'/assets/images/product04.png" alt="" class="wp-image-218"/></figure>
        <!-- /wp:image -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"tertiary"} -->
        <p class="has-text-align-left has-tertiary-color has-text-color has-link-color" style="font-style:normal;font-weight:400">'. esc_html__('Artist Name Here','artist-art-gallery').'</p>
        <!-- /wp:paragraph -->

        <!-- wp:heading {"textAlign":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}}},"textColor":"tertiary","fontSize":"upper-heading","fontFamily":"roboto"} -->
        <h2 class="wp-block-heading has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family has-upper-heading-font-size" style="font-style:normal;font-weight:600">'. esc_html__('Golden Horizon','artist-art-gallery').'</h2>
        <!-- /wp:heading -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontStyle":"normal","fontWeight":"1000"}},"textColor":"tertiary","fontSize":"upper-heading","fontFamily":"roboto"} -->
        <p class="has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family has-upper-heading-font-size" style="font-style:normal;font-weight:1000">'. esc_html__('$30.00','artist-art-gallery').'</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column -->

        <!-- wp:column {"verticalAlignment":"center","className":"static-product wow pulse animated","style":{"spacing":{"blockGap":"var:preset|spacing|30","padding":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
        <div class="wp-block-column is-vertically-aligned-center static-product wow pulse animated" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":217,"sizeSlug":"full","linkDestination":"none"} -->
        <figure class="wp-block-image size-full"><img src="'.esc_url(get_template_directory_uri()) .'/assets/images/product03.png" alt="" class="wp-image-217"/></figure>
        <!-- /wp:image -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"tertiary"} -->
        <p class="has-text-align-left has-tertiary-color has-text-color has-link-color" style="font-style:normal;font-weight:400">'. esc_html__('Artist Name Here','artist-art-gallery').'</p>
        <!-- /wp:paragraph -->

        <!-- wp:heading {"textAlign":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}}},"textColor":"tertiary","fontSize":"upper-heading","fontFamily":"roboto"} -->
        <h2 class="wp-block-heading has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family has-upper-heading-font-size" style="font-style:normal;font-weight:600">'. esc_html__('Ethereal Bloom','artist-art-gallery').'</h2>
        <!-- /wp:heading -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontStyle":"normal","fontWeight":"800"}},"textColor":"tertiary","fontSize":"upper-heading","fontFamily":"roboto"} -->
        <p class="has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family has-upper-heading-font-size" style="font-style:normal;font-weight:800">'. esc_html__('$30.00','artist-art-gallery').'</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column -->

        <!-- wp:column {"verticalAlignment":"center","className":"static-product wow pulse animated","style":{"spacing":{"blockGap":"var:preset|spacing|30","padding":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
        <div class="wp-block-column is-vertically-aligned-center static-product wow pulse animated" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":216,"sizeSlug":"full","linkDestination":"none"} -->
        <figure class="wp-block-image size-full"><img src="'.esc_url(get_template_directory_uri()) .'/assets/images/product02.png" alt="" class="wp-image-216"/></figure>
        <!-- /wp:image -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"tertiary"} -->
        <p class="has-text-align-left has-tertiary-color has-text-color has-link-color" style="font-style:normal;font-weight:400">'. esc_html__('Artist Name Here','artist-art-gallery').'</p>
        <!-- /wp:paragraph -->

        <!-- wp:heading {"textAlign":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}}},"textColor":"tertiary","fontSize":"upper-heading","fontFamily":"roboto"} -->
        <h2 class="wp-block-heading has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family has-upper-heading-font-size" style="font-style:normal;font-weight:600">'. esc_html__('Sculpted Grace','artist-art-gallery').'</h2>
        <!-- /wp:heading -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontStyle":"normal","fontWeight":"800"}},"textColor":"tertiary","fontSize":"upper-heading","fontFamily":"roboto"} -->
        <p class="has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family has-upper-heading-font-size" style="font-style:normal;font-weight:800">'. esc_html__('$30.00','artist-art-gallery').'</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column -->

        <!-- wp:column {"verticalAlignment":"center","className":"static-product wow pulse animated","style":{"spacing":{"blockGap":"var:preset|spacing|30","padding":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
        <div class="wp-block-column is-vertically-aligned-center static-product wow pulse animated" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":215,"sizeSlug":"full","linkDestination":"none"} -->
        <figure class="wp-block-image size-full"><img src="'.esc_url(get_template_directory_uri()) .'/assets/images/product01.png" alt="" class="wp-image-215"/></figure>
        <!-- /wp:image -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"tertiary"} -->
        <p class="has-text-align-left has-tertiary-color has-text-color has-link-color" style="font-style:normal;font-weight:400">'. esc_html__('Artist Name Here','artist-art-gallery').'</p>
        <!-- /wp:paragraph -->

        <!-- wp:heading {"textAlign":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}}},"textColor":"tertiary","fontSize":"upper-heading","fontFamily":"roboto"} -->
        <h2 class="wp-block-heading has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family has-upper-heading-font-size" style="font-style:normal;font-weight:600">'. esc_html__('Light & Shadow','artist-art-gallery').'</h2>
        <!-- /wp:heading -->

        <!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|tertiary"}}},"typography":{"fontStyle":"normal","fontWeight":"800"}},"textColor":"tertiary","fontSize":"upper-heading","fontFamily":"roboto"} -->
        <p class="has-text-align-left has-tertiary-color has-text-color has-link-color has-roboto-font-family has-upper-heading-font-size" style="font-style:normal;font-weight:800">'. esc_html__('$30.00','artist-art-gallery').'</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns --></div>
        <!-- /wp:group --></div>
        <!-- /wp:group -->

        <!-- wp:spacer {"height":"40px"} -->
        <div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer -->',
    );
}
