<?php
/**
 * Customizer
 * 
 * @package WordPress
 * @subpackage artist-art-gallery
 * @since artist-art-gallery 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function artist_art_gallery_customize_register( $wp_customize ) {
	$wp_customize->add_section( new Artist_Art_Gallery_Upsell_Section($wp_customize,'upsell_section',array(
		'title'            => __( 'Artist Art Gallery Pro', 'artist-art-gallery' ),
		'button_text'      => __( 'Upgrade Pro', 'artist-art-gallery' ),
		'url'              => 'https://www.wpradiant.net/products/museum-wordpress-theme',
		'priority'         => 0,
	)));
}
add_action( 'customize_register', 'artist_art_gallery_customize_register' );

/**
 * Enqueue script for custom customize control.
 */
function artist_art_gallery_custom_control_scripts() {
	wp_enqueue_script( 'artist-art-gallery-custom-controls-js', get_template_directory_uri() . '/assets/js/custom-controls.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-sortable' ), '1.0', true );
	wp_enqueue_style( 'artist-art-gallery-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/css/customize-controls.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'artist_art_gallery_custom_control_scripts' );