<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package WordPress
 * @subpackage artist-art-gallery
 * @since artist-art-gallery 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since artist-art-gallery 1.0
	 *
	 * @return void
	 */
	function artist_art_gallery_register_block_styles() {
		

		// Image: Borders.
		register_block_style(
			'core/image',
			array(
				'name'  => 'artist-art-gallery-border',
				'label' => esc_html__( 'Borders', 'artist-art-gallery' ),
			)
		);

		
	}
	add_action( 'init', 'artist_art_gallery_register_block_styles' );
}