jQuery(document).ready(function ($) {
    // Attach click event to the dismiss button
    $(document).on('click', '.notice[data-notice="get-start"] button.notice-dismiss', function () {
        // Dismiss the notice via AJAX
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                action: 'artist_art_gallery_dismissed_notice',
            },
            success: function () {
                // Remove the notice on success
                $('.notice[data-notice="example"]').remove();
            }
        });
    });
});

// Plugin – AI Content Writer plugin activation
document.addEventListener('DOMContentLoaded', function () {
    const artist_art_gallery_button = document.getElementById('install-activate-button');

    if (!artist_art_gallery_button) return;

    artist_art_gallery_button.addEventListener('click', function (e) {
        e.preventDefault();

        const artist_art_gallery_redirectUrl = artist_art_gallery_button.getAttribute('data-redirect');

        // Step 1: Check if plugin is already active
        const artist_art_gallery_checkData = new FormData();
        artist_art_gallery_checkData.append('action', 'check_plugin_activation');

        fetch(installPluginData.ajaxurl, {
            method: 'POST',
            body: artist_art_gallery_checkData,
        })
        .then(res => res.json())
        .then(res => {
            if (res.success && res.data.active) {
                // Plugin is already active → just redirect
                window.location.href = artist_art_gallery_redirectUrl;
            } else {
                // Not active → proceed with install + activate
                artist_art_gallery_button.textContent = 'Installing & Activating...';

                const artist_art_gallery_installData = new FormData();
                artist_art_gallery_installData.append('action', 'install_and_activate_required_plugin');
                artist_art_gallery_installData.append('_ajax_nonce', installPluginData.nonce);

                fetch(installPluginData.ajaxurl, {
                    method: 'POST',
                    body: artist_art_gallery_installData,
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        window.location.href = artist_art_gallery_redirectUrl;
                    } else {
                        alert('Activation error: ' + (res.data?.message || 'Unknown error'));
                        artist_art_gallery_button.textContent = 'Try Again';
                    }
                })
                .catch(error => {
                    alert('Request failed: ' + error.message);
                    artist_art_gallery_button.textContent = 'Try Again';
                });
            }
        })
        .catch(error => {
            alert('Check request failed: ' + error.message);
        });
    });
});
